/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontManagerConfigurator;
import org.apache.fop.util.LogUtil;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.xml.sax.SAXException;

public class FopFactoryConfigurator {
    public static final boolean DEFAULT_BREAK_INDENT_INHERITANCE = false;
    public static final boolean DEFAULT_STRICT_USERCONFIG_VALIDATION = true;
    public static final boolean DEFAULT_STRICT_FO_VALIDATION = true;
    public static final String DEFAULT_PAGE_WIDTH = "8.26in";
    public static final String DEFAULT_PAGE_HEIGHT = "11in";
    public static final float DEFAULT_SOURCE_RESOLUTION = 72.0f;
    public static final float DEFAULT_TARGET_RESOLUTION = 72.0f;
    private static final String PREFER_RENDERER = "prefer-renderer";
    private final Log log = LogFactory.getLog((Class)FopFactoryConfigurator.class);
    private FopFactory factory = null;
    private Configuration cfg = null;

    public FopFactoryConfigurator(FopFactory factory) {
        this.factory = factory;
    }

    public void configure(FopFactory factory) throws FOPException {
        Configuration pageConfig;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Initializing FopFactory Configuration");
        }
        if (this.cfg.getChild("accessibility", false) != null) {
            try {
                this.factory.setAccessibility(this.cfg.getChild("accessibility").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                throw new FOPException(e);
            }
        }
        if (this.cfg.getChild("strict-configuration", false) != null) {
            try {
                factory.setStrictUserConfigValidation(this.cfg.getChild("strict-configuration").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, e, false);
            }
        }
        boolean strict = factory.validateUserConfigStrictly();
        if (this.cfg.getChild("strict-validation", false) != null) {
            try {
                factory.setStrictValidation(this.cfg.getChild("strict-validation").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, e, strict);
            }
        }
        if (this.cfg.getChild("base", false) != null) {
            try {
                factory.setBaseURL(this.cfg.getChild("base").getValue(null));
            }
            catch (MalformedURLException mfue) {
                LogUtil.handleException(this.log, mfue, strict);
            }
        }
        if (this.cfg.getChild("hyphenation-base", false) != null) {
            try {
                factory.setHyphenBaseURL(this.cfg.getChild("hyphenation-base").getValue(null));
            }
            catch (MalformedURLException mfue) {
                LogUtil.handleException(this.log, mfue, strict);
            }
        }
        if (this.cfg.getChild("source-resolution", false) != null) {
            factory.setSourceResolution(this.cfg.getChild("source-resolution").getValueAsFloat(72.0f));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("source-resolution set to: " + factory.getSourceResolution() + "dpi (px2mm=" + factory.getSourcePixelUnitToMillimeter() + ")"));
            }
        }
        if (this.cfg.getChild("target-resolution", false) != null) {
            factory.setTargetResolution(this.cfg.getChild("target-resolution").getValueAsFloat(72.0f));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("target-resolution set to: " + factory.getTargetResolution() + "dpi (px2mm=" + factory.getTargetPixelUnitToMillimeter() + ")"));
            }
        }
        if (this.cfg.getChild("break-indent-inheritance", false) != null) {
            try {
                factory.setBreakIndentInheritanceOnReferenceAreaBoundary(this.cfg.getChild("break-indent-inheritance").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, e, strict);
            }
        }
        if ((pageConfig = this.cfg.getChild("default-page-settings")).getAttribute("height", null) != null) {
            factory.setPageHeight(pageConfig.getAttribute("height", DEFAULT_PAGE_HEIGHT));
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Default page-height set to: " + factory.getPageHeight()));
            }
        }
        if (pageConfig.getAttribute("width", null) != null) {
            factory.setPageWidth(pageConfig.getAttribute("width", DEFAULT_PAGE_WIDTH));
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Default page-width set to: " + factory.getPageWidth()));
            }
        }
        if (this.cfg.getChild(PREFER_RENDERER, false) != null) {
            try {
                factory.getRendererFactory().setRendererPreferred(this.cfg.getChild(PREFER_RENDERER).getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, e, strict);
            }
        }
        FontManager fontManager = factory.getFontManager();
        FontManagerConfigurator fontManagerConfigurator = new FontManagerConfigurator(this.cfg);
        fontManagerConfigurator.configure(fontManager, strict);
        this.configureImageLoading(this.cfg.getChild("image-loading", false), strict);
    }

    private void configureImageLoading(Configuration parent, boolean strict) throws FOPException {
        if (parent == null) {
            return;
        }
        ImageImplRegistry registry = this.factory.getImageManager().getRegistry();
        Configuration[] penalties = parent.getChildren("penalty");
        try {
            int c = penalties.length;
            for (int i = 0; i < c; ++i) {
                Configuration penaltyCfg = penalties[i];
                String className = penaltyCfg.getAttribute("class");
                String value = penaltyCfg.getAttribute("value");
                Penalty p = null;
                if (value.toUpperCase().startsWith("INF")) {
                    p = Penalty.INFINITE_PENALTY;
                } else {
                    try {
                        p = Penalty.toPenalty((int)Integer.parseInt(value));
                    }
                    catch (NumberFormatException nfe) {
                        LogUtil.handleException(this.log, nfe, strict);
                    }
                }
                if (p == null) continue;
                registry.setAdditionalPenalty(className, p);
            }
        }
        catch (ConfigurationException e) {
            LogUtil.handleException(this.log, e, strict);
        }
    }

    public void setUserConfig(File userConfigFile) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.buildFromFile(userConfigFile));
        }
        catch (ConfigurationException e) {
            throw new FOPException(e);
        }
    }

    public void setUserConfig(String uri) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.build(uri));
        }
        catch (ConfigurationException e) {
            throw new FOPException(e);
        }
    }

    public void setUserConfig(Configuration cfg) throws FOPException {
        this.cfg = cfg;
        this.configure(this.factory);
    }

    public Configuration getUserConfig() {
        return this.cfg;
    }
}

