/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setpp.anzeige.beans;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.sportdata.setpp.anzeige.Anzeige;
import org.sportdata.setpp.anzeige.AnzeigeControlPanel;
import org.sportdata.setpp.anzeige.AnzeigeController;
import org.sportdata.setpp.anzeige.ProtestClockPanel;
import org.sportdata.setpp.anzeige.ScoreClockPanel;
import org.sportdata.setpp.anzeige.beans.ScoringAuthObject;
import org.sportdata.setpp.anzeige.beans.ScoringObject;
import org.sportdata.setpp.anzeige.components.HanteiComponent;
import org.sportdata.setpp.anzeige.components.ProtestComponent;
import org.sportdata.setpp.anzeige.components.ScoreComponent;
import org.sportdata.setpp.anzeige.constants.MainConstants;
import org.sportdata.setpp.anzeige.matchtime.MatchtimeHelper;
import org.sportdata.setpp.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setpp.anzeige.ressource.AnzeigeResource;
import org.sportdata.setpp.anzeige.utils.DateUtils;
import org.sportdata.setpp.anzeige.utils.FehlerFenster;
import org.sportdata.setpp.anzeige.utils.HostName;
import org.sportdata.setpp.anzeige.utils.LicenseHelper;
import org.sportdata.setpp.anzeige.utils.Passwort;
import org.sportdata.setpp.scores.TestClicker;
import org.sportdata.setpp.server.servlet.SETPPKumiteClickerScores;
import org.sportdata.setpp.server.servlet.SETPPScorelogServlet;
import org.sportdata.setpp.server.servlet.ScoringAuthServlet;
import org.sportdata.setpp.server.servlet.ScoringCheckstatusServlet;
import org.sportdata.setpp.server.servlet.ScoringServlet;

public class AnzeigeMaster {
    private static AnzeigeMaster anzmaster;
    private Properties anzeigeprops = new Properties();
    private LicenseParam licenceParam;
    private LicenseManager licenseManager;
    private LicenseContent licenseContent;
    public static final String SUBJECT = "SET POINT PANEL";
    private static ResourceBundle resourceBundle;
    private String langueage = "";
    private TreeMap<Integer, String> wintypes = new TreeMap();
    private int lastwintypeselected = -1;
    private String lastlogo = "";
    private HashMap<Integer, Integer> matchtime = new HashMap();
    private AnzeigeControlPanel acp;
    private Server server;
    private int pin = -1;
    private TreeMap<String, ScoringAuthObject> referees = new TreeMap();
    private int SERVER_PORT = 8080;
    private TreeMap<Integer, ScoringObject> refereesPointsRed = new TreeMap();
    private TreeMap<Integer, ScoringObject> refereesPointsBlue = new TreeMap();
    private Anzeige anzeige;
    private Anzeige anzeigebig;
    private ScoreClockPanel pcpaka;
    private ScoreClockPanel pcpao;
    private ProtestClockPanel pcpakavr;
    private ProtestClockPanel pcpaovr;
    private Object ath1;
    private Object ath2;
    private Object club1;
    private Object club2;
    private Object nat1;
    private Object nat2;
    private Object cat;
    private LicenseContent templicensecontent;
    private HanteiComponent hanteicomponent;
    private TreeMap<Integer, ScoringObject> refereesPointsRedHantei = new TreeMap();
    private TreeMap<Integer, ScoringObject> refereesPointsBlueHantei = new TreeMap();
    private boolean isembedded = false;
    private boolean isTestmode = false;
    private TestClicker testclicker;

    static {
        resourceBundle = ResourceBundle.getBundle("languages.english_pp");
    }

    public AnzeigeMaster(boolean isembedded) {
        anzmaster = this;
        this.isembedded = isembedded;
        anzmaster.loadProps();
        anzmaster.initLicenseParam();
        anzmaster.initLicenseManager();
        anzmaster.initLicenseContent();
        anzmaster.checkLicense();
        anzmaster.initLanguage();
        anzmaster.startJettyServer();
        anzmaster.generateRandomPin();
        anzmaster.loadRefereesFromProps();
    }

    public AnzeigeMaster(Properties anzeigeprops, Server server, int port, LicenseContent templicensecontent) {
        anzmaster = this;
        this.isembedded = true;
        this.server = server;
        this.SERVER_PORT = port;
        this.templicensecontent = templicensecontent;
        anzmaster.setAnzeigeprops(anzeigeprops);
        anzmaster.initLicenseParam();
        anzmaster.initLicenseManager();
        anzmaster.initLicenseContent();
        anzmaster.checkLicense();
        anzmaster.initLanguage();
        anzmaster.startJettyServer();
        anzmaster.generateRandomPin();
        anzmaster.loadRefereesFromProps();
    }

    public static AnzeigeMaster getInstance() {
        return anzmaster;
    }

    public Properties getAnzeigeprops() {
        return this.anzeigeprops;
    }

    public void initLanguage() {
        this.setLangueage(AnzeigePropertiesHelper.getLanguage());
    }

    public void setAnzeigeprops(Properties wkvprops) {
        this.anzeigeprops = wkvprops;
    }

    public String getLastlogo() {
        return this.lastlogo;
    }

    public void setLastlogo(String lastlogo) {
        this.lastlogo = lastlogo;
    }

    public void loadProps() {
        try {
            FileInputStream fis = new FileInputStream("props/set.properties");
            this.anzeigeprops.load(fis);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            AnzeigePropertiesHelper.setDefaults();
        }
    }

    public void saveProps() {
        try {
            FileOutputStream fos = new FileOutputStream("props/set.properties");
            this.anzeigeprops.store(fos, "set main properties");
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initLicenseParam() {
        this.licenceParam = new LicenseParam(){
            KeyStoreParam a = new KeyStoreParam(){

                @Override
                public InputStream getStream() throws IOException {
                    String resourceName = "/keystore/publicSETCerts.store";
                    InputStream in = this.getClass().getResourceAsStream("/keystore/publicSETCerts.store");
                    if (in == null) {
                        throw new FileNotFoundException("/keystore/publicSETCerts.store");
                    }
                    return in;
                }

                @Override
                public String getAlias() {
                    return Passwort.deobfuscate("1y7v1yte1sho1u2w1thh1th51u2e1shu1yt81y83");
                }

                @Override
                public String getStorePwd() {
                    return Passwort.deobfuscate("1ym71wmh1jda1vgf1jg01wnp1ym7");
                }

                @Override
                public String getKeyPwd() {
                    return null;
                }
            };
            CipherParam b = new CipherParam(){

                @Override
                public String getKeyPwd() {
                    return Passwort.deobfuscate("1x111saj1y0s19q71y0y1sar1x1l");
                }
            };

            @Override
            public String getSubject() {
                return AnzeigeMaster.SUBJECT;
            }

            @Override
            public Preferences getPreferences() {
                return Preferences.userRoot().node("/set/pointpanel");
            }

            @Override
            public KeyStoreParam getKeyStoreParam() {
                return this.a;
            }

            @Override
            public CipherParam getCipherParam() {
                return this.b;
            }
        };
    }

    private void initLicenseManager() {
        this.licenseManager = new LicenseManager(AnzeigeMaster.getInstance().getLicenceParam());
    }

    public void initLicenseContent() {
        try {
            this.licenseContent = AnzeigeMaster.getInstance().getLicenseManager().verify();
            if (AnzeigeMaster.getInstance().getLicenseContent() != null && LicenseHelper.LBL.containsKey(Passwort.obfuscate(AnzeigeMaster.getInstance().getLicenseContent().getHolder().toString().substring(AnzeigeMaster.getInstance().getLicenseContent().getHolder().toString().indexOf("=") + 1)))) {
                LicenseHelper.deleteLicense();
                AnzeigeMaster.getInstance().initLicenseManager();
                this.licenseContent = AnzeigeMaster.getInstance().getLicenseManager().verify();
            }
        }
        catch (Exception e) {
            this.licenseContent = null;
        }
    }

    public void checkLicense() {
        if (AnzeigeMaster.getInstance().getLicenseContent() == null) {
            // empty if block
        }
    }

    public LicenseParam getLicenceParam() {
        return this.licenceParam;
    }

    public void setLicenceParam(LicenseParam licenceParam) {
        this.licenceParam = licenceParam;
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public LicenseContent getLicenseContent() {
        if (this.licenseContent == null && this.templicensecontent != null) {
            return this.templicensecontent;
        }
        return this.licenseContent;
    }

    public void setLicenseContent(LicenseContent licenseContent) {
        this.licenseContent = licenseContent;
    }

    public String getLangueage() {
        return this.langueage;
    }

    public void setLangueage(String langueage) {
        if (langueage != null && !langueage.equals("")) {
            this.langueage = langueage;
            this.actualizeResourceBundle();
            UIManager.put("OptionPane.cancelButtonText", AnzeigeResource.getResourceString("logon.button.cancel"));
            UIManager.put("OptionPane.noButtonText", AnzeigeResource.getResourceString("general.no"));
            UIManager.put("OptionPane.okButtonText", AnzeigeResource.getResourceString("general.ok"));
            UIManager.put("OptionPane.yesButtonText", AnzeigeResource.getResourceString("general.yes"));
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null) {
                this.actualizeResourceBundle();
            }
        }
        catch (MissingResourceException x) {
            resourceBundle = null;
        }
        return resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        AnzeigeMaster.resourceBundle = resourceBundle;
    }

    private void actualizeResourceBundle() {
        if (AnzeigeMaster.getInstance().getLangueage().equals("deutsch")) {
            resourceBundle = ResourceBundle.getBundle("languages.deutsch_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("english")) {
            resourceBundle = ResourceBundle.getBundle("languages.english_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("czech")) {
            resourceBundle = ResourceBundle.getBundle("languages.czech_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("francais")) {
            resourceBundle = ResourceBundle.getBundle("languages.francais_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("francais")) {
            resourceBundle = ResourceBundle.getBundle("languages.francais_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("turkce")) {
            resourceBundle = ResourceBundle.getBundle("languages.turkce_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("magyar")) {
            resourceBundle = ResourceBundle.getBundle("languages.magyar_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("italiano")) {
            resourceBundle = ResourceBundle.getBundle("languages.italiano_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("russian")) {
            resourceBundle = ResourceBundle.getBundle("languages.russian_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("nederlandse")) {
            resourceBundle = ResourceBundle.getBundle("languages.nederlandse_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u4e2d\u6587")) {
            resourceBundle = ResourceBundle.getBundle("languages.chinese_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac")) {
            resourceBundle = ResourceBundle.getBundle("languages.greek_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("espanol")) {
            resourceBundle = ResourceBundle.getBundle("languages.espanol_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("dansk")) {
            resourceBundle = ResourceBundle.getBundle("languages.danish_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("portugu\u00eas")) {
            resourceBundle = ResourceBundle.getBundle("languages.portuguese_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("c\u0440\u043f\u0441\u043a\u0438")) {
            resourceBundle = ResourceBundle.getBundle("languages.serbian_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u0641\u0627\u0631\u0633\u06cc")) {
            resourceBundle = ResourceBundle.getBundle("languages.persian_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u0639\u0631\u0628\u0649")) {
            resourceBundle = ResourceBundle.getBundle("languages.arabic_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("rom\u00e2n\u0103")) {
            resourceBundle = ResourceBundle.getBundle("languages.romana_pp");
        }
    }

    public TreeMap<Integer, String> getWintypes() {
        return this.wintypes;
    }

    public void setWintypes(TreeMap<Integer, String> wintypes) {
        this.wintypes = wintypes;
    }

    public int getWintypeID(int index) {
        Iterator<Integer> it = this.getWintypes().keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            int id = it.next();
            if (count == index) {
                return id;
            }
            ++count;
        }
        return -1;
    }

    public String getWintypeText(int index) {
        Iterator<Integer> it = this.getWintypes().keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            int id = it.next();
            if (count == index) {
                return this.getWintypes().get(id);
            }
            ++count;
        }
        return "";
    }

    public boolean hasWinTypes() {
        return this.getWintypes().size() > 0;
    }

    public int getLastwintypeselected() {
        return this.lastwintypeselected;
    }

    public void setLastwintypeselected(int lastwintypeselected) {
        this.lastwintypeselected = lastwintypeselected;
    }

    public void resetMatchtime() {
        this.matchtime.clear();
    }

    public void setMatchtimeRound(int round, int seconds) {
        int time = MatchtimeHelper.getMatchtime() - seconds;
        this.matchtime.put(round, time);
    }

    public int getMatchtime() {
        int totalmatchtime = 0;
        for (int round : this.matchtime.keySet()) {
            totalmatchtime += this.matchtime.get(round).intValue();
        }
        return totalmatchtime;
    }

    public AnzeigeControlPanel getAcp() {
        return this.acp;
    }

    public void setAcp(AnzeigeControlPanel acp) {
        this.acp = acp;
    }

    public Anzeige getAnzeige() {
        return this.anzeige;
    }

    public void setAnzeige(Anzeige anzeige) {
        this.anzeige = anzeige;
    }

    public void startJettyServer() {
        try {
            if (!this.isJettyServerRunning()) {
                this.server = new Server(this.SERVER_PORT);
                ServletHandler handler = new ServletHandler();
                this.server.setHandler((Handler)handler);
                handler.addServletWithMapping(ScoringServlet.class, "/ppwkf/scoring");
                handler.addServletWithMapping(ScoringAuthServlet.class, "/ppwkf/scoringAuth");
                handler.addServletWithMapping(ScoringCheckstatusServlet.class, "/ppwkf/scoringCheckStatus");
                handler.addServletWithMapping(SETPPKumiteClickerScores.class, "/ppwkf/kumitescoreobserver");
                handler.addServletWithMapping(SETPPScorelogServlet.class, "/ppwkf/scorelog");
                File imagefiles = new File("images");
                File jsfiles = new File("js");
                WebAppContext context = new WebAppContext();
                context.setResourceBase(imagefiles.getAbsolutePath());
                context.setContextPath("/ppwkf/images");
                WebAppContext context3 = new WebAppContext();
                context3.setResourceBase(jsfiles.getAbsolutePath());
                context3.setContextPath("/ppwkf/js");
                HandlerCollection collection = new HandlerCollection();
                collection.setHandlers(new Handler[]{context, context3, handler});
                this.server.setHandler((Handler)collection);
                this.server.start();
            } else {
                System.out.println(String.valueOf(this.getClass()) + ": Webserver is already running! Do not start another server.");
            }
        }
        catch (Exception e) {
            new FehlerFenster("Local Server Error: " + e.getMessage());
        }
    }

    public boolean isJettyServerRunning() {
        return this.server != null && this.server.isRunning();
    }

    public void stopJettyServer() {
        if (this.isJettyServerRunning()) {
            try {
                System.out.println("Stopping Webserver...");
                if (this.server.isRunning()) {
                    this.server.stop();
                }
                this.server = null;
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
    }

    public String getServletScoringUrlIP() {
        return "http://" + HostName.getIP() + ":" + this.SERVER_PORT + "/ppwkf/scoring";
    }

    public String getServletScoringUrlHostname() {
        return "http://" + HostName.getHostname() + ":" + this.SERVER_PORT + "/ppwkf/scoring";
    }

    public String getServletScoringAuthUrlIP() {
        return "http://" + HostName.getIP() + ":" + this.SERVER_PORT + "/ppwkf/scoringAuth";
    }

    public String getServletScoringAuthUrlHostname() {
        return "http://" + HostName.getHostname() + ":" + this.SERVER_PORT + "/ppwkf/scoringAuth";
    }

    public String getServletScoringCheckStatusUrlIP() {
        return "http://" + HostName.getIP() + ":" + this.SERVER_PORT + "/ppwkf/scoringCheckStatus?pptime=" + Calendar.getInstance().getTimeInMillis();
    }

    public String getServletScoringCheckStatusUrlHostname() {
        return "http://" + HostName.getHostname() + ":" + this.SERVER_PORT + "/ppwkf/scoringCheckStatus?pptime=" + Calendar.getInstance().getTimeInMillis();
    }

    public int generateRandomPin() {
        this.pin = (int)(Math.random() * 9999.0) + 1000;
        return this.pin;
    }

    public int getPin() {
        return this.pin;
    }

    public void setPin(int pin) {
        this.pin = pin;
    }

    public TreeMap<String, ScoringAuthObject> getReferees() {
        return this.referees;
    }

    public void setReferees(TreeMap<String, ScoringAuthObject> referees) {
        this.referees = referees;
    }

    public boolean hasAssignedReferee(String refnr) {
        for (String imei : this.referees.keySet()) {
            if (!this.referees.get(imei).isIsassigned() || !this.referees.get(imei).getRefnr().equals(refnr)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<String> getRefereeNumbers() {
        ArrayList<String> refnumbers = new ArrayList<String>();
        for (String imei : this.referees.keySet()) {
            refnumbers.add(this.referees.get(imei).getRefnr());
        }
        return refnumbers;
    }

    public boolean hasImeiReferee(String imei, String refnr) {
        return this.referees.containsKey(imei) && this.referees.get(imei).getRefnr().equals(refnr);
    }

    public boolean hasAssignedImeiReferee(String imei, String refnr) {
        return this.referees.containsKey(imei) && this.referees.get(imei).isIsassigned() && this.referees.get(imei).getRefnr().equals(refnr);
    }

    public void addReferee(ScoringAuthObject sao) {
        this.referees.put(sao.getImei(), sao);
        this.saveRefereesToProps();
    }

    public void removeReferee(String imei) {
        this.referees.remove(imei);
        this.saveRefereesToProps();
    }

    public void loadRefereesFromProps() {
        if (!AnzeigePropertiesHelper.getPpsetscoringappdevice().trim().equals("")) {
            try {
                String[] refprops = AnzeigePropertiesHelper.getPpsetscoringappdevice().split(";");
                int i = 0;
                while (i < refprops.length) {
                    String[] refprop = refprops[i].split(",");
                    ScoringAuthObject sao = new ScoringAuthObject();
                    sao.setImei(refprop[0]);
                    sao.setRefnr(refprop[1]);
                    if (refprop[2].equals("true")) {
                        sao.setIsassigned(true);
                    } else {
                        sao.setIsassigned(false);
                    }
                    this.referees.put(sao.getImei(), sao);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveRefereesToProps() {
        Object refprops = "";
        Iterator<String> refs = this.referees.keySet().iterator();
        int count = 0;
        while (refs.hasNext()) {
            String imei = refs.next();
            ScoringAuthObject sao = this.referees.get(imei);
            if (count > 0) {
                refprops = (String)refprops + ";";
            }
            refprops = (String)refprops + sao.getImei() + "," + sao.getRefnr() + "," + sao.isIsassigned();
            ++count;
        }
        AnzeigePropertiesHelper.setPpsetscoringappdevice((String)refprops);
        AnzeigePropertiesHelper.saveAnzeigeProps();
    }

    public void printRefereesList() {
        System.out.println("Referees APP Device List: " + this.referees.size());
        System.out.println("------------------------------------------");
        for (String imei : this.referees.keySet()) {
            System.out.println("IMEI: " + imei + " RefereeNr: " + this.referees.get(imei).getRefnr() + " IsAssigned: " + this.referees.get(imei).isIsassigned());
        }
        System.out.println("------------------------------------------");
    }

    public TreeMap<Integer, ScoringObject> getRefereesPointsRed() {
        return this.refereesPointsRed;
    }

    public void setRefereesPointsRed(TreeMap<Integer, ScoringObject> refereesPointsRed) {
        this.refereesPointsRed = refereesPointsRed;
    }

    public TreeMap<Integer, ScoringObject> getRefereesPointsBlue() {
        return this.refereesPointsBlue;
    }

    public void setRefereesPointsBlue(TreeMap<Integer, ScoringObject> refereesPointsBlue) {
        this.refereesPointsBlue = refereesPointsBlue;
    }

    public Vector<Object> countScoreRed() {
        int score = 0;
        int refcount = 0;
        Vector<Object> vec = new Vector<Object>();
        Vector<Integer> scores = new Vector<Integer>();
        ArrayList<Integer> refswithscores = new ArrayList<Integer>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        Date aktdate = new Date();
        System.out.println("Check Score Red");
        System.out.println("------------------------------------------");
        for (int ref : this.refereesPointsRed.keySet()) {
            if (!this.refereesPointsRed.get(ref).getScorer().equals("RED")) continue;
            try {
                Date daterequest = sdf.parse(this.refereesPointsRed.get(ref).getGenerated());
                System.out.println("RefereeNr: " + ref + " Score Red: " + this.refereesPointsRed.get(ref).getScoreValue() + " " + this.refereesPointsRed.get(ref).getGenerated());
                long ms = aktdate.getTime() - daterequest.getTime();
                long maxtime = MainConstants.MAX_TIME_DIFF;
                if (!AnzeigePropertiesHelper.getPpwkfscoremaxtimedifference().equals("")) {
                    try {
                        maxtime = Long.parseLong(AnzeigePropertiesHelper.getPpwkfscoremaxtimedifference());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (ms >= maxtime) continue;
                score += (int)this.refereesPointsRed.get(ref).getScoreValue();
                ++refcount;
                scores.add((int)this.refereesPointsRed.get(ref).getScoreValue());
                refswithscores.add(ref);
            }
            catch (ParseException daterequest) {
                // empty catch block
            }
        }
        System.out.println("Total score: " + score);
        if (refcount < 2) {
            score = 0;
        } else {
            int threescore = 0;
            int twoscore = 0;
            int onescore = 0;
            int i = 0;
            while (i < scores.size()) {
                if ((Integer)scores.get(i) == 1) {
                    ++onescore;
                }
                if ((Integer)scores.get(i) == 2) {
                    ++twoscore;
                }
                if ((Integer)scores.get(i) == 3) {
                    ++threescore;
                }
                ++i;
            }
            int value = 0;
            value = AnzeigePropertiesHelper.getPpwkfscorecounthighest().equals("true") ? (threescore > 0 && threescore >= twoscore && threescore >= onescore ? 3 : (twoscore > 0 && twoscore >= onescore ? 2 : 1)) : (threescore > 0 && threescore > twoscore && threescore > onescore ? 3 : (twoscore > 0 && twoscore > onescore ? 2 : 1));
            if (value > 0) {
                score = value;
            } else if (onescore > 0) {
                score = 1;
            } else if (twoscore > 0) {
                score = 2;
            } else if (threescore > 0) {
                score = 3;
            }
            vec.add(score);
            vec.add(refcount);
            vec.add(refswithscores);
        }
        System.out.println("Total score RED: " + score + " Refs: " + refswithscores.toString());
        System.out.println("------------------------------------------");
        return vec;
    }

    public Vector<Object> countScoreBlue() {
        int score = 0;
        int refcount = 0;
        Vector<Object> vec = new Vector<Object>();
        Vector<Integer> scores = new Vector<Integer>();
        ArrayList<Integer> refswithscores = new ArrayList<Integer>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        Date aktdate = new Date();
        System.out.println("Check Score Blue");
        System.out.println("------------------------------------------");
        for (int ref : this.refereesPointsBlue.keySet()) {
            if (!this.refereesPointsBlue.get(ref).getScorer().equals("BLUE")) continue;
            try {
                Date daterequest = sdf.parse(this.refereesPointsBlue.get(ref).getGenerated());
                System.out.println("RefereeNr: " + ref + " Score Blue: " + this.refereesPointsBlue.get(ref).getScoreValue() + " " + this.refereesPointsBlue.get(ref).getGenerated());
                long ms = aktdate.getTime() - daterequest.getTime();
                long maxtime = MainConstants.MAX_TIME_DIFF;
                if (!AnzeigePropertiesHelper.getPpwkfscoremaxtimedifference().equals("")) {
                    try {
                        maxtime = Long.parseLong(AnzeigePropertiesHelper.getPpwkfscoremaxtimedifference());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (ms >= maxtime) continue;
                score += (int)this.refereesPointsBlue.get(ref).getScoreValue();
                ++refcount;
                scores.add((int)this.refereesPointsBlue.get(ref).getScoreValue());
                refswithscores.add(ref);
            }
            catch (ParseException daterequest) {
                // empty catch block
            }
        }
        System.out.println("Total score: " + score);
        if (refcount < 2) {
            score = 0;
        } else {
            int threescore = 0;
            int twoscore = 0;
            int onescore = 0;
            int i = 0;
            while (i < scores.size()) {
                if ((Integer)scores.get(i) == 1) {
                    ++onescore;
                }
                if ((Integer)scores.get(i) == 2) {
                    ++twoscore;
                }
                if ((Integer)scores.get(i) == 3) {
                    ++threescore;
                }
                ++i;
            }
            int value = 0;
            value = AnzeigePropertiesHelper.getPpwkfscorecounthighest().equals("true") ? (threescore > 0 && threescore >= twoscore && threescore >= onescore ? 3 : (twoscore > 0 && twoscore >= onescore ? 2 : 1)) : (threescore > 0 && threescore > twoscore && threescore > onescore ? 3 : (twoscore > 0 && twoscore > onescore ? 2 : 1));
            if (value > 0) {
                score = value;
            } else if (onescore > 0) {
                score = 1;
            } else if (twoscore > 0) {
                score = 2;
            } else if (threescore > 0) {
                score = 3;
            }
            vec.add(score);
            vec.add(refcount);
            vec.add(refswithscores);
        }
        System.out.println("Total score BLUE: " + score + " Refs: " + refswithscores.toString());
        System.out.println("------------------------------------------");
        return vec;
    }

    public synchronized void showAKAVR(AnzeigeController acontrol) {
        try {
            if (this.pcpakavr == null || !this.pcpakavr.isVisible()) {
                boolean signal = true;
                if (this.pcpakavr != null && this.pcpakavr.isVisible() || this.pcpaovr != null && this.pcpaovr.isVisible()) {
                    signal = false;
                }
                if (this.pcpakavr != null) {
                    this.pcpakavr.closeWindow();
                }
                ProtestComponent protestclock = new ProtestComponent(acontrol, true, 1, this.anzeigebig.getWidth(), this.anzeigebig.getHeight() / 2, this.anzeigebig.getClock());
                protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y);
                this.pcpakavr = new ProtestClockPanel(protestclock, 1);
                this.pcpakavr.setPenalties(this.anzeigebig.getSakacompnew().getSanction1(), this.anzeigebig.getSaocompnew().getSanction1());
                Thread counterThread = new Thread((Runnable)protestclock, "protestClockaka");
                counterThread.start();
                if (this.pcpaovr != null && this.pcpaovr.isVisible() || this.pcpaka != null && this.pcpaka.isVisible() || this.pcpao != null && this.pcpao.isVisible()) {
                    this.pcpakavr.setNormalSize();
                    if (this.pcpaovr != null && this.pcpaovr.isVisible()) {
                        this.pcpaovr.setNormalSize();
                    }
                    if (this.pcpaka != null && this.pcpaka.isVisible()) {
                        this.pcpaka.setNormalSize();
                    }
                    if (this.pcpao != null && this.pcpao.isVisible()) {
                        this.pcpao.setNormalSize();
                    }
                    if (this.pcpaka != null && this.pcpaka.isVisible()) {
                        this.pcpaka.setNormalSize();
                        this.pcpaka.setClockSize(this.anzeigebig.getWidth() / 2, this.anzeigebig.getHeight() / 2);
                        this.pcpaka.setClockLocation(this.anzeigebig.getLocation().x + this.anzeigebig.getWidth() / 2, this.anzeigebig.getLocation().y);
                        protestclock.setSize(this.anzeigebig.getWidth() / 2, this.anzeigebig.getHeight() / 2);
                        protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y);
                    } else {
                        protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y);
                    }
                } else {
                    this.pcpakavr.setFullScreen();
                }
                if (signal) {
                    acontrol.notifyListeners(187, "");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void showAOVR(AnzeigeController acontrol) {
        try {
            if (this.pcpaovr == null || !this.pcpaovr.isVisible()) {
                boolean signal = true;
                if (this.pcpakavr != null && this.pcpakavr.isVisible() || this.pcpaovr != null && this.pcpaovr.isVisible()) {
                    signal = false;
                }
                if (this.pcpaovr != null) {
                    this.pcpaovr.closeWindow();
                }
                ProtestComponent protestclock = new ProtestComponent(acontrol, true, 2, this.anzeigebig.getWidth(), this.anzeigebig.getHeight() / 2, this.anzeigebig.getClock());
                protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y + this.anzeigebig.getHeight() / 2);
                this.pcpaovr = new ProtestClockPanel(protestclock, 2);
                this.pcpaovr.setPenalties(this.anzeigebig.getSakacompnew().getSanction1(), this.anzeigebig.getSaocompnew().getSanction1());
                Thread counterThread = new Thread((Runnable)protestclock, "protestClockao");
                counterThread.start();
                if (this.pcpakavr != null && this.pcpakavr.isVisible() || this.pcpaka != null && this.pcpaka.isVisible() || this.pcpao != null && this.pcpao.isVisible()) {
                    this.pcpaovr.setNormalSize();
                    if (this.pcpakavr != null && this.pcpakavr.isVisible()) {
                        this.pcpakavr.setNormalSize();
                    }
                    if (this.pcpaka != null && this.pcpaka.isVisible()) {
                        this.pcpaka.setNormalSize();
                    }
                    if (this.pcpao != null && this.pcpao.isVisible()) {
                        this.pcpao.setNormalSize();
                    }
                    if (this.pcpao != null && this.pcpao.isVisible()) {
                        this.pcpao.setNormalSize();
                        this.pcpao.setClockSize(this.anzeigebig.getWidth() / 2, this.anzeigebig.getHeight() / 2);
                        this.pcpao.setClockLocation(this.anzeigebig.getLocation().x + this.anzeigebig.getWidth() / 2, this.anzeigebig.getLocation().y + this.anzeigebig.getHeight() / 2);
                        protestclock.setSize(this.anzeigebig.getWidth() / 2, this.anzeigebig.getHeight() / 2);
                        protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y + this.anzeigebig.getHeight() / 2);
                    } else {
                        protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y + this.anzeigebig.getHeight() / 2);
                    }
                } else {
                    this.pcpaovr.setFullScreen();
                }
                if (signal) {
                    acontrol.notifyListeners(187, "");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void showScore(int redblue, AnzeigeController acontrol, String selitem, int refcount, ArrayList<Integer> refs) {
        if (redblue == 1) {
            this.showScoreRed(acontrol, selitem, refcount, refs);
        }
        if (redblue == 2) {
            this.showScoreBlue(acontrol, selitem, refcount, refs);
        }
    }

    public synchronized void showScoreRed(AnzeigeController acontrol, String selitem, int refcount, ArrayList<Integer> refs) {
        try {
            boolean signal = true;
            if (this.pcpaka != null && this.pcpaka.isVisible() || this.pcpao != null && this.pcpao.isVisible()) {
                signal = false;
            }
            if (this.pcpaka != null) {
                try {
                    this.pcpaka.stopClock();
                    this.pcpaka.closeWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String title = "SCORE";
            if (selitem.equals("HANTEI")) {
                title = "HANTEI";
            }
            ScoreComponent protestclock = new ScoreComponent(acontrol, true, 1, this.anzeigebig.getWidth(), this.anzeigebig.getHeight() / 2, this.anzeigebig.getClock(), title);
            protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y);
            this.pcpaka = new ScoreClockPanel(protestclock, 1);
            this.pcpaka.setRefs(refs);
            if (selitem.equals("HANTEI")) {
                this.pcpaka.setScoreType("VOTES " + refcount);
                if (this.isHantei()) {
                    this.hanteicomponent.toBack();
                }
            } else {
                this.pcpaka.setScoreType(selitem);
                this.pcpaka.addAdditionalText(refcount + " JUDGES");
            }
            this.pcpaka.setPenalties(this.anzeigebig.getSakacompnew().getSanction1(), this.anzeigebig.getSaocompnew().getSanction1());
            Thread counterThread = new Thread((Runnable)protestclock, "scoreClockaka");
            counterThread.start();
            this.addustDisplayRed(protestclock);
            if (!selitem.equals("HANTEI")) {
                if (signal) {
                    acontrol.notifyListeners(187, "");
                }
                if (AnzeigePropertiesHelper.getPpwkfscorstoptime().equals("true")) {
                    acontrol.notifyListeners(1, "");
                    AnzeigeMaster.getInstance().getAnzeige().getClock().getClockendautomatic().add(DateUtils.getDateFormatedShort());
                }
            }
            if (refs != null) {
                this.checkRefereeChangedMindRed();
            }
            if (!selitem.equals("HANTEI")) {
                acontrol.notifyListeners(188, this.getScoreFlagsMessage());
            } else {
                acontrol.notifyListeners(189, this.getScoreFlagsMessageHantei());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addustDisplayRed(ScoreComponent protestclock) {
        if (this.pcpaovr != null && this.pcpaovr.isVisible() || this.pcpakavr != null && this.pcpakavr.isVisible() || this.pcpao != null && this.pcpao.isVisible()) {
            this.pcpaka.setNormalSize();
            if (this.pcpakavr != null && this.pcpakavr.isVisible()) {
                this.pcpakavr.setNormalSize();
            }
            if (this.pcpaovr != null && this.pcpaovr.isVisible()) {
                this.pcpaovr.setNormalSize();
            }
            if (this.pcpao != null && this.pcpao.isVisible()) {
                this.pcpao.setNormalSize();
            }
            if (this.pcpakavr != null && this.pcpakavr.isVisible()) {
                this.pcpakavr.setNormalSize();
                this.pcpakavr.setClockSize(this.anzeigebig.getWidth() / 2, this.anzeigebig.getHeight() / 2);
                this.pcpakavr.setClockLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y);
                protestclock.setSize(this.anzeigebig.getWidth() / 2, this.anzeigebig.getHeight() / 2);
                protestclock.setLocation(this.anzeigebig.getLocation().x + this.anzeigebig.getWidth() / 2, this.anzeigebig.getLocation().y);
            } else {
                protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y);
            }
        } else {
            this.pcpaka.setFullScreen();
        }
    }

    public synchronized void showScoreBlue(AnzeigeController acontrol, String selitem, int refcount, ArrayList<Integer> refs) {
        try {
            boolean signal = true;
            if (this.pcpaka != null && this.pcpaka.isVisible() || this.pcpao != null && this.pcpao.isVisible()) {
                signal = false;
            }
            if (this.pcpao != null) {
                try {
                    this.pcpao.stopClock();
                    this.pcpao.closeWindow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String title = "SCORE";
            if (selitem.equals("HANTEI")) {
                title = "HANTEI";
            }
            ScoreComponent protestclock = new ScoreComponent(acontrol, true, 2, this.anzeigebig.getWidth(), this.anzeigebig.getHeight() / 2, this.anzeigebig.getClock(), title);
            protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y + this.anzeigebig.getHeight() / 2);
            this.pcpao = new ScoreClockPanel(protestclock, 2);
            this.pcpao.setRefs(refs);
            if (selitem.equals("HANTEI")) {
                this.pcpao.setScoreType("VOTES " + refcount);
                if (this.isHantei()) {
                    this.hanteicomponent.toBack();
                }
            } else {
                this.pcpao.setScoreType(selitem);
                this.pcpao.addAdditionalText(refcount + " JUDGES");
            }
            this.pcpao.setPenalties(this.anzeigebig.getSakacompnew().getSanction1(), this.anzeigebig.getSaocompnew().getSanction1());
            Thread counterThread = new Thread((Runnable)protestclock, "scoreClockaka");
            counterThread.start();
            this.addustDisplayBlue(protestclock);
            if (!selitem.equals("HANTEI")) {
                if (signal) {
                    acontrol.notifyListeners(187, "");
                }
                if (AnzeigePropertiesHelper.getPpwkfscorstoptime().equals("true")) {
                    acontrol.notifyListeners(1, "");
                    AnzeigeMaster.getInstance().getAnzeige().getClock().getClockendautomatic().add(DateUtils.getDateFormatedShort());
                }
            }
            if (refs != null) {
                this.checkRefereeChangedMindBlue();
            }
            if (!selitem.equals("HANTEI")) {
                acontrol.notifyListeners(188, this.getScoreFlagsMessage());
            } else {
                acontrol.notifyListeners(189, this.getScoreFlagsMessageHantei());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void addustDisplayBlue(ScoreComponent protestclock) {
        if (this.pcpaovr != null && this.pcpaovr.isVisible() || this.pcpakavr != null && this.pcpakavr.isVisible() || this.pcpaka != null && this.pcpaka.isVisible()) {
            this.pcpao.setNormalSize();
            if (this.pcpakavr != null && this.pcpakavr.isVisible()) {
                this.pcpakavr.setNormalSize();
            }
            if (this.pcpaovr != null && this.pcpaovr.isVisible()) {
                this.pcpaovr.setNormalSize();
            }
            if (this.pcpaka != null && this.pcpaka.isVisible()) {
                this.pcpaka.setNormalSize();
            }
            if (this.pcpaovr != null && this.pcpaovr.isVisible()) {
                this.pcpaovr.setNormalSize();
                this.pcpaovr.setClockSize(this.anzeigebig.getWidth() / 2, this.anzeigebig.getHeight() / 2);
                this.pcpaovr.setClockLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y + this.anzeigebig.getHeight() / 2);
                protestclock.setSize(this.anzeigebig.getWidth() / 2, this.anzeigebig.getHeight() / 2);
                protestclock.setLocation(this.anzeigebig.getLocation().x + this.anzeigebig.getWidth() / 2, this.anzeigebig.getLocation().y + this.anzeigebig.getHeight() / 2);
            } else {
                protestclock.setLocation(this.anzeigebig.getLocation().x, this.anzeigebig.getLocation().y + this.anzeigebig.getHeight() / 2);
            }
        } else {
            this.pcpao.setFullScreen();
        }
    }

    public synchronized void checkRefereeChangedMindRed() {
        if (this.pcpaka != null && this.pcpaka.isVisible() && this.pcpaka.getRefs() != null && this.pcpao != null && this.pcpao.isVisible() && this.pcpao.getRefs() != null) {
            int i = 0;
            while (i < this.pcpaka.getRefs().size()) {
                if (this.pcpao.getRefs().contains(this.pcpaka.getRefs().get(i))) {
                    System.out.println("Referee " + String.valueOf(this.pcpaka.getRefs().get(i)) + " changed mind, from BLUE -> RED");
                    AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(160, "[SCORE DECISION CHANGE DETECTED] " + DateUtils.getLogDateFormatedMS() + " [JUDGE " + String.valueOf(this.pcpaka.getRefs().get(i)) + "] [BLUE]->[RED] ");
                    this.pcpao.getRefs().remove(this.pcpaka.getRefs().get(i));
                }
                ++i;
            }
            this.pcpao.getClock().addAdditionalText("<br>JUDGE " + this.pcpao.getRefs().stream().map(Object::toString).collect(Collectors.joining(",")));
            if (this.pcpao.getRefs().size() < 2) {
                try {
                    this.pcpao.stopClock();
                    this.pcpao.closeWindow();
                    this.addustDisplayRed(this.pcpaka.getClock());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void checkRefereeChangedMindBlue() {
        if (this.pcpaka != null && this.pcpaka.isVisible() && this.pcpaka.getRefs() != null && this.pcpao != null && this.pcpao.isVisible() && this.pcpao.getRefs() != null) {
            int i = 0;
            while (i < this.pcpao.getRefs().size()) {
                if (this.pcpaka.getRefs().contains(this.pcpao.getRefs().get(i))) {
                    System.out.println("Referee " + String.valueOf(this.pcpao.getRefs().get(i)) + " changed mind, from RED -> BLUE");
                    AnzeigeMaster.getInstance().getAcp().getAcontrol().notifyListeners(160, "[SCORE DECISION CHANGE DETECTED] " + DateUtils.getLogDateFormatedMS() + " [JUDGE " + String.valueOf(this.pcpao.getRefs().get(i)) + "] [RED]->[BLUE] ");
                    this.pcpaka.getRefs().remove(this.pcpao.getRefs().get(i));
                }
                ++i;
            }
            this.pcpaka.getClock().addAdditionalText("<b>JUDGE " + this.pcpaka.getRefs().stream().map(Object::toString).collect(Collectors.joining(",")));
            if (this.pcpaka.getRefs().size() < 2) {
                try {
                    this.pcpaka.stopClock();
                    this.pcpaka.closeWindow();
                    this.addustDisplayBlue(this.pcpao.getClock());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void clearRefereePointsRed() {
        this.refereesPointsRed.clear();
    }

    public void clearRefereePointsBlue() {
        this.refereesPointsBlue.clear();
    }

    public Anzeige getAnzeigebig() {
        return this.anzeigebig;
    }

    public void setAnzeigebig(Anzeige anzeigebig) {
        this.anzeigebig = anzeigebig;
    }

    public Object getAth1() {
        return this.ath1;
    }

    public void setAth1(Object ath1) {
        this.ath1 = ath1;
    }

    public Object getAth2() {
        return this.ath2;
    }

    public void setAth2(Object ath2) {
        this.ath2 = ath2;
    }

    public Object getClub1() {
        return this.club1;
    }

    public void setClub1(Object club1) {
        this.club1 = club1;
    }

    public Object getClub2() {
        return this.club2;
    }

    public void setClub2(Object club2) {
        this.club2 = club2;
    }

    public Object getNat1() {
        return this.nat1;
    }

    public void setNat1(Object nat1) {
        this.nat1 = nat1;
    }

    public Object getNat2() {
        return this.nat2;
    }

    public void setNat2(Object nat2) {
        this.nat2 = nat2;
    }

    public Object getCat() {
        return this.cat;
    }

    public void setCat(Object cat) {
        this.cat = cat;
    }

    public void setMatchtime(HashMap<Integer, Integer> matchtime) {
        this.matchtime = matchtime;
    }

    public LicenseContent getTemplicensecontent() {
        return this.templicensecontent;
    }

    public void setTemplicensecontent(LicenseContent templicensecontent) {
        this.templicensecontent = templicensecontent;
    }

    public void showHantei(int x, int y) {
        try {
            if (this.hanteicomponent != null) {
                this.hanteicomponent.close();
            }
            this.hanteicomponent = new HanteiComponent(x, y);
            this.refereesPointsRedHantei.clear();
            this.refereesPointsBlueHantei.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void hideHantei() {
        try {
            if (this.hanteicomponent != null) {
                this.hanteicomponent.close();
                this.refereesPointsRedHantei.clear();
                this.refereesPointsBlueHantei.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void setFinalDecision(AnzeigeController acontrol) {
    }

    public boolean isHantei() {
        try {
            if (this.hanteicomponent != null && this.hanteicomponent.isVisible()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public ProtestClockPanel getPcpakavr() {
        return this.pcpakavr;
    }

    public ProtestClockPanel getPcpaovr() {
        return this.pcpaovr;
    }

    public TreeMap<Integer, ScoringObject> getRefereesPointsRedHantei() {
        return this.refereesPointsRedHantei;
    }

    public TreeMap<Integer, ScoringObject> getRefereesPointsBlueHantei() {
        return this.refereesPointsBlueHantei;
    }

    public boolean hasrefereevoteHantei(int ref) {
        return this.refereesPointsRedHantei.containsKey(ref) || this.refereesPointsBlueHantei.containsKey(ref);
    }

    public synchronized String getScoreFlagsMessage() {
        String matchNumber = "";
        Object akapoints = "0";
        Object akaflags = "0";
        Object aopoints = "0";
        Object aoflags = "0";
        try {
            matchNumber = this.getAnzeige().getMatchid();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.pcpaka != null && this.pcpaka.isVisible()) {
                akapoints = "" + this.pcpaka.getCBVAlueIndex();
                akaflags = "" + this.pcpaka.getRefcount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.pcpao != null && this.pcpao.isVisible()) {
                aopoints = "" + this.pcpao.getCBVAlueIndex();
                aoflags = "" + this.pcpao.getRefcount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return matchNumber + "|" + (String)akapoints + "|" + (String)akaflags + "|" + (String)aopoints + "|" + (String)aoflags;
    }

    public synchronized String getScoreFlagsMessageHantei() {
        String matchNumber = "";
        String status = "1";
        Object akaflags = "0";
        Object aoflags = "0";
        try {
            matchNumber = this.getAnzeige().getMatchid();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.pcpaka != null && this.pcpaka.isVisible()) {
                akaflags = "" + this.pcpaka.getRefcount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.pcpao != null && this.pcpao.isVisible()) {
                aoflags = "" + this.pcpao.getRefcount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return matchNumber + "|" + status + "|" + (String)akaflags + "|" + (String)aoflags;
    }

    public boolean isWKF2023() {
        return false;
    }

    public void setVRIconAnzeige2Red(ImageIcon icon) {
    }

    public void setVRIconAnzeige2Blue(ImageIcon icon) {
    }

    public boolean isIsembedded() {
        return this.isembedded;
    }

    public void setIsembedded(boolean isembedded) {
        this.isembedded = isembedded;
    }

    public void openClickerTest() {
        if (this.testclicker != null) {
            this.testclicker.closeWindow();
        }
        this.testclicker = new TestClicker();
        this.acp.getAcontrol().notifyListeners(1, "");
    }

    public void clickerTestToFront() {
        try {
            if (this.testclicker != null) {
                this.testclicker.setState(0);
                this.testclicker.toFront();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void processTestScore(ScoringObject obj) {
        if (this.isTestmode() && this.testclicker != null) {
            this.testclicker.processScore(obj);
        }
    }

    public boolean isTestmode() {
        return this.isTestmode;
    }

    public void setTestmode(boolean isTestmode) {
        this.isTestmode = isTestmode;
    }
}

