/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.xmlns.parser;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.XMLParserFactoryProducer;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.xmlns.parser.LoggingErrorHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParserEntityResolver;
import org.pentaho.reporting.libraries.xmlns.parser.ResourceDataInputSource;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DomTreeResourceFactory
implements ResourceFactory {
    private static final Log logger = LogFactory.getLog(DomTreeResourceFactory.class);

    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        try {
            DocumentBuilderFactory dbf = XMLParserFactoryProducer.createSecureDocBuilderFactory();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(ParserEntityResolver.getDefaultResolver());
            db.setErrorHandler(new LoggingErrorHandler());
            ResourceDataInputSource input = new ResourceDataInputSource(data, manager);
            return new DomResource(data.getKey(), db.parse(input), data.getVersion(manager));
        }
        catch (ParserConfigurationException e) {
            throw new ResourceCreationException("Unable to initialize the XML-Parser", (Exception)e);
        }
        catch (SAXException e) {
            throw new ResourceCreationException("Unable to parse the document: " + data.getKey(), (Exception)e);
        }
        catch (IOException e) {
            throw new ResourceLoadingException("Unable to read the stream from document: " + data.getKey(), (Exception)e);
        }
    }

    public void initializeDefaults() {
    }

    public Class getFactoryType() {
        return Document.class;
    }

    private static class DomResource
    extends SimpleResource {
        public DomResource(ResourceKey resourceKey, Document document, long version) {
            super(resourceKey, (Object)document, Document.class, version);
        }

        public Object getResource() {
            Document resource = (Document)super.getResource();
            return resource.cloneNode(true);
        }
    }
}

