/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FullscreenActionSource
extends AbstractDockActionSource {
    private DockAction action;
    private LocationHint hint;
    private boolean showing = false;

    public FullscreenActionSource(DockAction action, LocationHint hint) {
        this.action = action;
        this.hint = hint;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener listener) {
        if (!this.hasListeners()) {
            this.listen(true);
            this.update();
        }
        super.addDockActionSourceListener(listener);
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        super.removeDockActionSourceListener(listener);
        if (!this.hasListeners()) {
            this.listen(false);
        }
    }

    public void update() {
        boolean enabled = this.isFullscreenEnabled();
        if (this.showing != enabled) {
            this.showing = enabled;
            if (this.showing) {
                this.fireAdded(0, 0);
            } else {
                this.fireRemoved(0, 0);
            }
        }
    }

    @Override
    public int getDockActionCount() {
        if (this.hasListeners()) {
            if (this.showing) {
                return 1;
            }
            return 0;
        }
        if (this.isFullscreenEnabled()) {
            this.showing = true;
            return 1;
        }
        this.showing = false;
        return 0;
    }

    @Override
    public DockAction getDockAction(int index) {
        if (index < 0 || index >= this.getDockActionCount()) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.action;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FullscreenActionSource.this.getDockActionCount();
            }

            @Override
            public DockAction next() {
                return FullscreenActionSource.this.getDockAction(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected abstract boolean isFullscreenEnabled();

    protected abstract void listen(boolean var1);
}

