/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultAxisConversion;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.AbstractTabsLayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class LineTabsLayoutBlock
extends AbstractTabsLayoutBlock {
    private boolean sameSize = true;

    public boolean isSameSize() {
        return this.sameSize;
    }

    public void setSameSize(boolean sameSize) {
        this.sameSize = sameSize;
    }

    public boolean isAllTabs(Size size) {
        return ((LineSize)size).isAllTabs();
    }

    public Tab[] getTabs(Size size) {
        return ((LineSize)size).getTabs();
    }

    public int getTabsCount(Size size) {
        return ((LineSize)size).getTabCount();
    }

    protected void checkSelection() {
        if (this.getSelectedTab() != null) {
            return;
        }
        TabPane pane = this.getPane();
        if (pane == null) {
            return;
        }
        Dockable selection = pane.getSelectedDockable();
        if (selection == null) {
            return;
        }
        this.insertTab(pane.putOnTab(selection));
    }

    public LineSize[] getSizes() {
        Tab[] tabs = this.getTabsOrderedByImportance();
        SizeCollector collector = new SizeCollector(this.getPane().getDockables());
        LineSize[] result = new LineSize[tabs.length + 1];
        for (int i = 0; i < tabs.length; ++i) {
            collector.insert(tabs[i]);
            Dimension size = collector.getMinimumSize();
            Tab[] selection = new Tab[i + 1];
            System.arraycopy(tabs, 0, selection, 0, i + 1);
            result[i] = new LineSize(Size.Type.MINIMUM, size, selection, i + 1 == tabs.length, (double)i / (double)tabs.length);
        }
        Dimension preferred = collector.getPreferredSize();
        result[tabs.length] = new LineSize(Size.Type.PREFERRED, preferred, tabs, true, 1.0);
        return result;
    }

    public int getIndexOfTabAt(Point mouseLocation) {
        Tab[] tabs = this.getCurrentTabs();
        int[] overlapPrevious = this.getOverlapToPrevious(tabs);
        int[] overlapNext = this.getOverlapToNext(tabs);
        int backup = -1;
        boolean horizontal = this.getOrientation().isHorizontal();
        for (int i = 0; i < tabs.length; ++i) {
            boolean exact;
            Rectangle bounds = tabs[i].getBounds();
            if (!bounds.contains(mouseLocation)) continue;
            if (horizontal) {
                exact = mouseLocation.x >= bounds.x + overlapPrevious[i] && mouseLocation.x < bounds.x + bounds.width - overlapNext[i];
            } else {
                boolean bl = exact = mouseLocation.y >= bounds.y + overlapPrevious[i] && mouseLocation.y < bounds.y + bounds.height - overlapNext[i];
            }
            if (exact) {
                return i;
            }
            backup = i;
        }
        return backup;
    }

    protected Tab[] getCurrentTabs() {
        TabPane pane = this.getPane();
        Tab[] tabs = pane.getTabs();
        Arrays.sort(tabs, new Comparator<Tab>(){

            @Override
            public int compare(Tab a, Tab b) {
                return a.getZOrder() - b.getZOrder();
            }
        });
        return tabs;
    }

    public void doLayout() {
        Tab[] zOrdered;
        Tab[] tabs = this.getTabs();
        Rectangle bounds = this.getBounds();
        DefaultAxisConversion conversion = new DefaultAxisConversion(bounds, this.getOrientation());
        bounds = conversion.viewToModel(bounds);
        Dimension[] preferreds = new Dimension[tabs.length];
        Dimension[] minimums = new Dimension[tabs.length];
        int sumPreferred = 0;
        int sumMinimum = 0;
        int[] overlapPrevious = this.getOverlapToPrevious(tabs);
        int[] overlapNext = this.getOverlapToNext(tabs);
        for (int i = 0; i < tabs.length; ++i) {
            preferreds[i] = conversion.viewToModel(tabs[i].getPreferredSize());
            minimums[i] = conversion.viewToModel(tabs[i].getMinimumSize());
            sumPreferred += preferreds[i].width;
            sumMinimum += minimums[i].width;
            if (i <= 0) continue;
            int delta = Math.max(overlapPrevious[i], overlapNext[i - 1]);
            sumPreferred -= delta;
            sumMinimum -= delta;
        }
        ZOrder zorder = new ZOrder(tabs);
        if (sumPreferred <= bounds.width) {
            this.doLayoutPreferred(conversion, bounds.width, bounds.height, preferreds, tabs, zorder, overlapPrevious, overlapNext);
        } else if (sumMinimum <= bounds.width) {
            this.doLayoutMinimum(conversion, bounds.width, bounds.height, minimums, preferreds, tabs, zorder, overlapPrevious, overlapNext);
        } else {
            this.doLayoutShrinked(conversion, bounds.width, bounds.height, minimums, tabs, zorder, overlapPrevious, overlapNext);
        }
        int z = 0;
        for (Tab tab : zOrdered = zorder.getOrderedByZ()) {
            if (tab == null) continue;
            tab.setZOrder(z++);
        }
    }

    private int[] getOverlapToPrevious(Tab[] tabs) {
        boolean horizontal = this.getOrientation().isHorizontal();
        int[] result = new int[tabs.length];
        for (int i = 1; i < tabs.length; ++i) {
            Insets overlap = tabs[i].getOverlap(tabs[i - 1]);
            result[i] = horizontal ? overlap.left : overlap.top;
        }
        return result;
    }

    private int[] getOverlapToNext(Tab[] tabs) {
        boolean horizontal = this.getOrientation().isHorizontal();
        int[] result = new int[tabs.length];
        for (int i = tabs.length - 2; i >= 0; --i) {
            Insets overlap = tabs[i].getOverlap(tabs[i + 1]);
            result[i] = horizontal ? overlap.right : overlap.bottom;
        }
        return result;
    }

    private void doLayoutPreferred(AxisConversion conversion, int width, int height, Dimension[] preferreds, Tab[] tabs, ZOrder order, int[] overlapPrevious, int[] overlapNext) {
        int x = 0;
        for (int i = 0; i < tabs.length; ++i) {
            Dimension size = preferreds[i];
            tabs[i].setBounds(conversion.modelToView(new Rectangle(x, 0, size.width, this.sameSize ? height : Math.min(height, size.height))));
            x += size.width;
            if (i + 1 >= tabs.length) continue;
            if (overlapNext[i] > overlapPrevious[i + 1]) {
                x -= overlapNext[i];
                order.putOrder(tabs[i + 1], tabs[i]);
                continue;
            }
            x -= overlapPrevious[i + 1];
            order.putOrder(tabs[i], tabs[i + 1]);
        }
    }

    private void doLayoutMinimum(AxisConversion conversion, int width, int height, Dimension[] minimums, Dimension[] preferreds, Tab[] tabs, ZOrder order, int[] overlapPrevious, int[] overlapNext) {
        int x = 0;
        int sumMinimum = 0;
        int sumPreferred = 0;
        for (Dimension minimum : minimums) {
            sumMinimum += minimum.width;
        }
        for (Dimension preferred : preferreds) {
            sumPreferred += preferred.width;
        }
        double passage = (double)(width - sumMinimum) / (double)(sumPreferred - sumMinimum);
        for (int i = 0; i < tabs.length - 1; ++i) {
            int tabWidth = (int)((double)minimums[i].width + passage * (double)(preferreds[i].width - minimums[i].width));
            tabs[i].setBounds(conversion.modelToView(new Rectangle(x, 0, tabWidth, this.sameSize ? height : Math.min(height, preferreds[i].height))));
            x += tabWidth;
            if (overlapNext[i] > overlapPrevious[i + 1]) {
                x -= overlapNext[i];
                order.putOrder(tabs[i + 1], tabs[i]);
                continue;
            }
            x -= overlapPrevious[i + 1];
            order.putOrder(tabs[i], tabs[i + 1]);
        }
        if (tabs.length > 0) {
            int last = tabs.length - 1;
            int tabWidth = Math.min(width - x, preferreds[last].width);
            tabs[last].setBounds(conversion.modelToView(new Rectangle(x, 0, tabWidth, this.sameSize ? height : Math.min(height, preferreds[last].height))));
        }
    }

    private void doLayoutShrinked(AxisConversion conversion, int width, int height, Dimension[] minimums, Tab[] tabs, ZOrder order, int[] overlapPrevious, int[] overlapNext) {
        int x = 0;
        int sum = 0;
        for (Dimension minimum : minimums) {
            sum += minimum.width;
        }
        double factor = (double)sum / (double)width;
        for (int i = 0; i < tabs.length - 1; ++i) {
            int tabWidth = (int)(factor * (double)minimums[i].width);
            tabs[i].setBounds(conversion.modelToView(new Rectangle(x, 0, tabWidth, this.sameSize ? height : Math.min(height, minimums[i].height))));
            x += tabWidth;
            if (overlapNext[i] > overlapPrevious[i + 1]) {
                x -= overlapNext[i];
                order.putOrder(tabs[i + 1], tabs[i]);
                continue;
            }
            x -= overlapPrevious[i + 1];
            order.putOrder(tabs[i], tabs[i + 1]);
        }
        int last = tabs.length - 1;
        if (last >= 0) {
            tabs[last].setBounds(conversion.modelToView(new Rectangle(x, 0, width - x, this.sameSize ? height : Math.min(height, minimums[last].height))));
        }
    }

    protected class SizeCollector {
        private Dockable[] dockables;
        private Tab[] tabs;
        private Dimension[] minimum;
        private Dimension[] preferred;
        private int[] overlapPrevious;
        private int[] overlapNext;

        public SizeCollector(Dockable[] dockables) {
            this.dockables = dockables;
            int size = dockables.length;
            this.tabs = new Tab[size];
            this.minimum = new Dimension[size];
            this.preferred = new Dimension[size];
            this.overlapPrevious = new int[size];
            this.overlapNext = new int[size];
        }

        public void insert(Tab tab) {
            Dockable dockable = tab.getDockable();
            for (int i = 0; i < this.dockables.length; ++i) {
                if (this.dockables[i] != dockable) continue;
                this.insert(tab, i);
                return;
            }
        }

        private Tab[] getVisibleTabs() {
            int count = 0;
            for (Tab tab : this.tabs) {
                if (tab == null) continue;
                ++count;
            }
            Tab[] visible = new Tab[count];
            int index = 0;
            for (Tab tab : this.tabs) {
                if (tab == null) continue;
                visible[index++] = tab;
            }
            return visible;
        }

        private void insert(Tab tab, int index) {
            int i;
            this.tabs[index] = tab;
            Tab[] visibleTabs = this.getVisibleTabs();
            for (int i2 = 0; i2 < this.tabs.length; ++i2) {
                if (this.tabs[i2] == null) continue;
                this.minimum[i2] = this.tabs[i2].getMinimumSize(visibleTabs);
                this.preferred[i2] = this.tabs[i2].getPreferredSize(visibleTabs);
            }
            boolean horizontal = LineTabsLayoutBlock.this.getOrientation().isHorizontal();
            for (i = index - 1; i >= 0; --i) {
                if (this.tabs[i] == null) continue;
                if (horizontal) {
                    this.overlapNext[i] = this.tabs[i].getOverlap((TabPaneComponent)tab).right;
                    this.overlapPrevious[index] = tab.getOverlap((TabPaneComponent)this.tabs[i]).left;
                    break;
                }
                this.overlapNext[i] = this.tabs[i].getOverlap((TabPaneComponent)tab).bottom;
                this.overlapPrevious[index] = tab.getOverlap((TabPaneComponent)this.tabs[i]).top;
                break;
            }
            for (i = index + 1; i < this.tabs.length; ++i) {
                if (this.tabs[i] == null) continue;
                if (horizontal) {
                    this.overlapNext[index] = tab.getOverlap((TabPaneComponent)this.tabs[i]).right;
                    this.overlapPrevious[i] = this.tabs[i].getOverlap((TabPaneComponent)tab).left;
                    break;
                }
                this.overlapNext[index] = tab.getOverlap((TabPaneComponent)this.tabs[i]).bottom;
                this.overlapPrevious[i] = this.tabs[i].getOverlap((TabPaneComponent)tab).top;
                break;
            }
        }

        public Dimension getMinimumSize() {
            return this.getSize(this.minimum);
        }

        public Dimension getPreferredSize() {
            return this.getSize(this.preferred);
        }

        private Dimension getSize(Dimension[] required) {
            int width = 0;
            int height = 0;
            int previous = -1;
            if (LineTabsLayoutBlock.this.getOrientation().isHorizontal()) {
                for (int i = 0; i < this.tabs.length; ++i) {
                    if (this.tabs[i] == null) continue;
                    Dimension size = required[i];
                    height = Math.max(height, size.height);
                    width += size.width;
                    if (previous != -1) {
                        width -= Math.max(this.overlapNext[previous], this.overlapPrevious[i]);
                    }
                    previous = i;
                }
            } else {
                for (int i = 0; i < this.tabs.length; ++i) {
                    if (this.tabs[i] == null) continue;
                    Dimension size = required[i];
                    width = Math.max(width, size.width);
                    height += size.height;
                    if (previous != -1) {
                        height -= Math.max(this.overlapNext[previous], this.overlapPrevious[i]);
                    }
                    previous = i;
                }
            }
            return new Dimension(width, height);
        }
    }

    protected class ZOrder {
        private Tab[] tabs;
        private List<Integer>[] onTop;
        private List<Integer>[] onBottom;

        public ZOrder(Tab[] tabs) {
            this.tabs = tabs;
            this.onTop = new List[tabs.length];
            this.onBottom = new List[tabs.length];
            for (int i = 0; i < tabs.length; ++i) {
                this.onTop[i] = new ArrayList<Integer>(5);
                this.onBottom[i] = new ArrayList<Integer>(5);
            }
        }

        public void putOrder(Tab front, Tab back) {
            for (int f = 0; f < this.tabs.length; ++f) {
                if (this.tabs[f] != front) continue;
                for (int b = 0; b < this.tabs.length; ++b) {
                    if (this.tabs[b] != back) continue;
                    this.onTop[b].add(f);
                    this.onBottom[f].add(b);
                    return;
                }
            }
        }

        public int[] getZOrders() {
            int[] results = new int[this.tabs.length];
            boolean[] handled = new boolean[results.length];
            for (int i = 0; i < results.length; ++i) {
                for (int j = 0; j < results.length; ++j) {
                    if (handled[j] || !this.onTop[j].isEmpty()) continue;
                    results[j] = results.length - i;
                    handled[j] = true;
                    Integer index = i;
                    for (int bottom : this.onBottom[j]) {
                        this.onTop[bottom].remove(index);
                    }
                }
            }
            return results;
        }

        public Tab[] getOrderedByZ() {
            Tab[] results = new Tab[this.tabs.length];
            boolean[] handled = new boolean[results.length];
            block0: for (int i = 0; i < results.length; ++i) {
                for (int j = 0; j < results.length; ++j) {
                    if (handled[j] || !this.onTop[j].isEmpty()) continue;
                    results[i] = this.tabs[j];
                    handled[j] = true;
                    Integer index = i;
                    for (int bottom : this.onBottom[j]) {
                        this.onTop[bottom].remove(index);
                    }
                    continue block0;
                }
            }
            return results;
        }
    }

    public class LineSize
    extends AbstractTabsLayoutBlock.TabsSize {
        private boolean allTabs;

        public LineSize(Size.Type type, Dimension size, Tab[] tabs, boolean allTabs, double score) {
            super(type, size, tabs, score);
            this.allTabs = allTabs;
        }

        public boolean isAllTabs() {
            return this.allTabs;
        }
    }
}

