/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.Type;

public class FilterUtil {
    public static final Set<String> builtInTypes = new HashSet<String>();

    public static String getPackagePart(String className) {
        return FilterUtil.getNamePart(className, '/').replace('/', '.');
    }

    public static String getClassPart(String className) {
        return FilterUtil.getPathPart(className, '/');
    }

    public static String getPathPart(String className, char delimiter) {
        int lastDelim = className.lastIndexOf(delimiter);
        return lastDelim >= 0 ? className.substring(0, lastDelim) : "";
    }

    public static String getNamePart(String className, char delimiter) {
        int lastDelim = className.lastIndexOf(delimiter);
        return lastDelim >= 0 ? className.substring(lastDelim + 1) : className;
    }

    public static String pushArg(String desc, String newType) {
        ArrayList<Type> types = new ArrayList<Type>();
        types.add(Type.getType((String)("L" + newType + ";")));
        types.addAll(Arrays.asList(Type.getArgumentTypes((String)desc)));
        return Type.getMethodDescriptor((Type)Type.getReturnType((String)desc), (Type[])types.toArray(new Type[types.size()]));
    }

    public static String extractBaseType(String type) {
        if (type == null) {
            return "";
        }
        int start = 0;
        int end = type.length();
        if (type.startsWith("[")) {
            start = type.lastIndexOf(91);
        }
        if (type.endsWith(";")) {
            ++start;
            --end;
        }
        if (start == 0 && end == type.length()) {
            return type;
        }
        return type.substring(start, end);
    }

    public static String extractBaseType(Type type) {
        if (type.getSort() == 9) {
            type = type.getElementType();
        }
        return type.getClassName().replace('.', '/');
    }

    public static boolean isPublic(int accessFlags) {
        return (accessFlags & 1) != 0;
    }

    public static boolean isPrivate(int accessFlags) {
        return (accessFlags & 2) != 0;
    }

    public static boolean isProtected(int accessFlags) {
        return (accessFlags & 4) != 0;
    }

    public static boolean isInterface(int accessFlags) {
        return (accessFlags & 0x200) != 0;
    }

    public static boolean isAbstract(int accessFlags) {
        return (accessFlags & 0x400) != 0;
    }

    public static boolean isFinal(int accessFlags) {
        return (accessFlags & 0x10) != 0;
    }

    public static boolean isStatic(int accessFlags) {
        return (accessFlags & 8) != 0;
    }

    public static boolean isAnnotation(int accessFlags) {
        return (accessFlags & 0x2000) != 0;
    }

    public static boolean isEnum(int accessFlags) {
        return (accessFlags & 0x4000) != 0;
    }

    public static boolean isBridge(int accessFlags) {
        return (accessFlags & 0x40) != 0;
    }

    public static boolean isSynthetic(int accessFlags) {
        return (accessFlags & 0x1000) != 0;
    }

    static {
        builtInTypes.add("void");
        builtInTypes.add("boolean");
        builtInTypes.add("int");
        builtInTypes.add("short");
        builtInTypes.add("long");
        builtInTypes.add("char");
        builtInTypes.add("byte");
        builtInTypes.add("float");
        builtInTypes.add("double");
    }
}

