/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import com.sun.tools.linker.filters.FilterUtil;
import com.sun.tools.linker.filters.MethodDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Injecter
extends AbstractFilter {
    HashMap<String, Collection<String>> interfaceMap = new HashMap();
    Map<MethodDescriptor, MethodDescriptor> extensionMap = new HashMap<MethodDescriptor, MethodDescriptor>();
    Set<String> hasMethods = new HashSet<String>();
    private static final String KEY_PREFIX = "injecter.";
    private static final String KEY_INTERFACE_PREFIX = "injecter.interface.";
    private static final String KEY_EXTENSION_PREFIX = "injecter.extension.";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    public String getName() {
        return "Injecter";
    }

    @Override
    public Collection<String> getIncompatibleUpstreamFilters() {
        return Collections.singleton("RetroLdc");
    }

    @Override
    public void afterPreVisit() {
        for (Map.Entry entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.toLowerCase().startsWith(KEY_PREFIX)) continue;
            if (key.toLowerCase().startsWith(KEY_INTERFACE_PREFIX)) {
                String className = key.substring(KEY_INTERFACE_PREFIX.length()).replace('.', '/');
                String[] interfaceNames = ((String)entry.getValue()).replace('.', '/').split(",");
                this.debug(String.format("Injecting interfaces %s into %s%n", Arrays.asList(interfaceNames), className));
                this.interfaceMap.put(className, Arrays.asList(interfaceNames));
                continue;
            }
            if (!key.toLowerCase().startsWith(KEY_EXTENSION_PREFIX)) continue;
            String classMethodSig = key.substring(KEY_EXTENSION_PREFIX.length());
            int parenIndex = classMethodSig.indexOf(40);
            if (parenIndex == -1) {
                this.warning("Malformed injected method descriptor: " + classMethodSig);
                continue;
            }
            String classMethod = classMethodSig.substring(0, parenIndex).replace('.', '/');
            String sig = classMethodSig.substring(parenIndex);
            String className = FilterUtil.getPathPart(classMethod, '/');
            String methodName = FilterUtil.getNamePart(classMethod, '/');
            String altClassMethod = ((String)entry.getValue()).replace('.', '/');
            String altClassName = FilterUtil.getPathPart(altClassMethod, '/');
            String altMethodName = FilterUtil.getNamePart(altClassMethod, '/');
            String altSig = FilterUtil.pushArg(sig, "java/lang/Object");
            this.hasMethods.add(className);
            this.extensionMap.put(new MethodDescriptor(className, methodName, sig, false), new MethodDescriptor(altClassName, altMethodName, altSig, true));
            this.debug(String.format("Mapping '%s %s %s' to '%s %s %s'%n", className, methodName, sig, altClassName, altMethodName, altSig));
        }
    }

    @Override
    public ClassVisitor makeVisitor(ClassVisitor chain) {
        return new ClassAdapter(chain){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                Collection<String> newInterfaces = Injecter.this.interfaceMap.get(name);
                if (newInterfaces == null) {
                    super.visit(version, access, name, signature, superName, interfaces);
                } else {
                    int iLen = interfaces == null ? 0 : interfaces.length;
                    String[] mergedInterfaces = new String[iLen + newInterfaces.size()];
                    newInterfaces.toArray(mergedInterfaces);
                    for (int i = 0; i < iLen; ++i) {
                        mergedInterfaces[i + newInterfaces.size()] = interfaces[i];
                    }
                    super.visit(version, access, name, signature, superName, mergedInterfaces);
                }
                if (Injecter.this.hasMethods.contains(name)) {
                    for (MethodDescriptor md : Injecter.this.extensionMap.keySet()) {
                        if (!md.owner.equals(name)) continue;
                        MethodDescriptor target = Injecter.this.extensionMap.get(md);
                        MethodVisitor mv = this.visitMethod(1, md.name, md.desc, md.desc, EMPTY_STRING_ARRAY);
                        mv.visitCode();
                        mv.visitVarInsn(25, 0);
                        mv.visitVarInsn(25, 1);
                        mv.visitMethodInsn(184, target.owner, target.name, target.desc);
                        mv.visitInsn(176);
                        mv.visitMaxs(0, 0);
                        mv.visitEnd();
                    }
                }
            }
        };
    }
}

