/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import com.sun.tools.linker.filters.ApplicationMapper;
import com.sun.tools.linker.filters.FilterUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceChecker
extends AbstractFilter {
    private ApplicationMapper mapper;
    private final Set<String> missingClasses = new TreeSet<String>();

    @Override
    public String getName() {
        return "ReferenceChecker";
    }

    @Override
    public Collection<String> getRequiredFilters() {
        return Collections.singleton("ClassMapper");
    }

    @Override
    public void beforePreVisit() {
        super.beforePreVisit();
        this.mapper = (ApplicationMapper)this.filterChain.locateFilterByName("ApplicationMapper");
    }

    @Override
    public ClassVisitor makeVisitor(ClassVisitor chain) {
        return new ClassAdapter(super.makeVisitor(chain)){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, access, name, signature, superName, interfaces);
                ReferenceChecker.this.ensureClass(superName, "superclass");
                for (String s : interfaces) {
                    ReferenceChecker.this.ensureClass(s, "interface");
                }
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (exceptions != null) {
                    for (String s : exceptions) {
                        ReferenceChecker.this.ensureClass(s, "exception");
                    }
                }
                ReferenceChecker.this.ensureClass(Type.getReturnType((String)desc).getClassName(), "return type");
                return new MethodAdapter(super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        super.visitFieldInsn(opcode, owner, name, desc);
                        ReferenceChecker.this.ensureClass(owner, "field reference");
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        super.visitMethodInsn(opcode, owner, name, desc);
                        ReferenceChecker.this.ensureClass(owner, "method invocation");
                    }
                };
            }
        };
    }

    @Override
    public void afterVisit() {
        super.afterVisit();
        StringBuffer sb = new StringBuffer("Missing classes:");
        String nl = System.getProperty("line.separator");
        for (String s : this.missingClasses) {
            sb.append(nl);
            sb.append("   ");
            sb.append(s);
        }
        if (this.missingClasses.size() > 0) {
            this.warning(sb.toString());
        }
    }

    private void ensureClass(String name, String what) {
        while (name.startsWith("[")) {
            name = name.substring(1);
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            name = name.substring(1, name.length() - 1);
        }
        while (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
        }
        if (name.indexOf(46) >= 0) {
            name = name.replaceAll("\\.", "/");
        }
        if (FilterUtil.builtInTypes.contains(name)) {
            return;
        }
        if (this.mapper.getClassModel(name) == null) {
            this.warning("Cannot find class " + name + " referenced as " + what);
            this.missingClasses.add(name);
        }
    }
}

