/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import java.util.Collection;
import java.util.Collections;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetroEnum
extends AbstractFilter {
    private static final String JAVA_LANG_ENUM = "java/lang/Enum";
    private static final String RETRO_ENUM_CLASS = "com/sun/tools/linker/runtime/Enum";
    private static final String VALUES_FIELD = "$VALUES";

    @Override
    public String getName() {
        return "RetroEnum";
    }

    @Override
    public Collection<String> getIncompatibleUpstreamFilters() {
        return Collections.singleton("RetroLdc");
    }

    @Override
    public ClassVisitor makeVisitor(ClassVisitor chain) {
        return new RemappingClassAdapter(chain, (Remapper)new SimpleRemapper(JAVA_LANG_ENUM, RETRO_ENUM_CLASS)){
            boolean isEnum;
            String currentClass;
            String currentClassArray;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.isEnum = superName.equals(RetroEnum.JAVA_LANG_ENUM);
                this.currentClass = name;
                this.currentClassArray = "[L" + name + ";";
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                if (this.isEnum && name.equals("values")) {
                    mv.visitCode();
                    mv.visitFieldInsn(178, this.currentClass, RetroEnum.VALUES_FIELD, this.currentClassArray);
                    mv.visitInsn(190);
                    mv.visitTypeInsn(189, this.currentClass);
                    mv.visitVarInsn(58, 1);
                    mv.visitFieldInsn(178, this.currentClass, RetroEnum.VALUES_FIELD, this.currentClassArray);
                    mv.visitInsn(3);
                    mv.visitVarInsn(25, 1);
                    mv.visitInsn(3);
                    mv.visitFieldInsn(178, this.currentClass, RetroEnum.VALUES_FIELD, this.currentClassArray);
                    mv.visitInsn(190);
                    mv.visitMethodInsn(184, "java/lang/System", "arraycopy", "(Ljava/lang/Object;ILjava/lang/Object;II)V");
                    mv.visitVarInsn(25, 1);
                    mv.visitInsn(176);
                    mv.visitMaxs(0, 0);
                    mv.visitEnd();
                    return new EmptyVisitor();
                }
                return mv;
            }
        };
    }
}

