/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.AltCheckMethodAdapter;
import org.objectweb.asm.util.CheckAnnotationAdapter;
import org.objectweb.asm.util.CheckFieldAdapter;
import org.objectweb.asm.util.CheckMethodAdapter;
import org.objectweb.asm.util.IdentifierValidator;
import org.objectweb.asm.util.TraceMethodVisitor;

public class AltCheckClassAdapter
extends ClassAdapter
implements IdentifierValidator {
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader cr = args[0].endsWith(".class") ? new ClassReader((InputStream)new FileInputStream(args[0])) : new ClassReader(args[0]);
        AltCheckClassAdapter.verify(cr, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader cr, boolean dump, PrintWriter pw) {
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)new AltCheckClassAdapter((ClassVisitor)cn), 2);
        Type syperType = cn.superName == null ? null : Type.getObjectType((String)cn.superName);
        List methods = cn.methods;
        for (int i = 0; i < methods.size(); ++i) {
            int j;
            MethodNode method = (MethodNode)methods.get(i);
            Analyzer a = new Analyzer((Interpreter)new SimpleVerifier(Type.getObjectType((String)cn.name), syperType, false));
            try {
                a.analyze(cn.name, method);
                if (!dump) {
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace(pw);
            }
            Frame[] frames = a.getFrames();
            TraceMethodVisitor mv = new TraceMethodVisitor();
            pw.println(method.name + method.desc);
            for (j = 0; j < method.instructions.size(); ++j) {
                method.instructions.get(j).accept((MethodVisitor)mv);
                StringBuffer s = new StringBuffer();
                Frame f = frames[j];
                if (f == null) {
                    s.append('?');
                } else {
                    int k;
                    for (k = 0; k < f.getLocals(); ++k) {
                        s.append(AltCheckClassAdapter.getShortName(f.getLocal(k).toString())).append(' ');
                    }
                    s.append(" : ");
                    for (k = 0; k < f.getStackSize(); ++k) {
                        s.append(AltCheckClassAdapter.getShortName(f.getStack(k).toString())).append(' ');
                    }
                }
                while (s.length() < method.maxStack + method.maxLocals + 1) {
                    s.append(' ');
                }
                pw.print(Integer.toString(j + 100000).substring(1));
                pw.print(" " + s + " : " + mv.buf);
            }
            for (j = 0; j < method.tryCatchBlocks.size(); ++j) {
                ((TryCatchBlockNode)method.tryCatchBlocks.get(j)).accept((MethodVisitor)mv);
                pw.print(" " + mv.buf);
            }
            pw.println();
        }
        pw.flush();
    }

    private static String getShortName(String name) {
        int n = name.lastIndexOf(47);
        int k = name.length();
        if (name.charAt(k - 1) == ';') {
            --k;
        }
        return n == -1 ? name : name.substring(n + 1, k);
    }

    public AltCheckClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        AltCheckClassAdapter.checkAccess(access, 161329);
        if (name == null || !name.endsWith("package-info")) {
            this.checkInternalName(name, "class name");
        }
        if ("java/lang/Object".equals(name)) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            this.checkInternalName(superName, "super class name");
        }
        if (signature != null) {
            this.checkClassSignature(signature);
        }
        if ((access & 0x200) != 0 && !"java/lang/Object".equals(superName)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.checkInternalName(interfaces[i], "interface name at index " + i);
            }
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public void visitSource(String file, String debug) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        this.cv.visitSource(file, debug);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.outer = true;
        if (owner == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (desc != null) {
            this.checkMethodDesc(desc);
        }
        this.cv.visitOuterClass(owner, name, desc);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.checkState();
        this.checkInternalName(name, "class name");
        if (outerName != null) {
            this.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            this.checkIdentifier(innerName, "inner class name");
        }
        AltCheckClassAdapter.checkAccess(access, 30239);
        this.cv.visitInnerClass(name, outerName, innerName, access);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.checkState();
        AltCheckClassAdapter.checkAccess(access, 151775);
        this.checkIdentifier(name, "field name");
        this.checkDesc(desc, false);
        if (signature != null) {
            this.checkFieldSignature(signature);
        }
        if (value != null) {
            this.checkConstant(value);
        }
        FieldVisitor av = this.cv.visitField(access, name, desc, signature, value);
        return new CheckFieldAdapter(av);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.checkState();
        AltCheckClassAdapter.checkAccess(access, 138751);
        this.checkMethodIdentifier(name, "method name");
        this.checkMethodDesc(desc);
        if (signature != null) {
            this.checkMethodSignature(signature);
        }
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                this.checkInternalName(exceptions[i], "exception name at index " + i);
            }
        }
        return new AltCheckMethodAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions), this);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkState();
        this.checkDesc(desc, false);
        return new CheckAnnotationAdapter(this.cv.visitAnnotation(desc, visible));
    }

    public void visitAttribute(Attribute attr) {
        this.checkState();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        this.cv.visitAttribute(attr);
    }

    public void visitEnd() {
        this.checkState();
        this.end = true;
        this.cv.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        int abs;
        int pro;
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int pub = (access & 1) == 0 ? 0 : 1;
        int pri = (access & 2) == 0 ? 0 : 1;
        int n = pro = (access & 4) == 0 ? 0 : 1;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access);
        }
        int fin = (access & 0x10) == 0 ? 0 : 1;
        int n2 = abs = (access & 0x400) == 0 ? 0 : 1;
        if (fin + abs > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }

    public void checkIdentifier(String name, String msg) {
        CheckMethodAdapter.checkIdentifier((String)name, (String)msg);
    }

    public void checkMethodIdentifier(String name, String msg) {
        CheckMethodAdapter.checkMethodIdentifier((String)name, (String)msg);
    }

    public void checkInternalName(String name, String msg) {
        CheckMethodAdapter.checkInternalName((String)name, (String)msg);
    }

    public void checkMethodSignature(String name) {
        CheckMethodAdapter.checkMethodSignature((String)name);
    }

    public void checkFieldSignature(String name) {
        CheckMethodAdapter.checkFieldSignature((String)name);
    }

    public void checkClassSignature(String name) {
        CheckMethodAdapter.checkClassSignature((String)name);
    }

    public void checkMethodDesc(String name) {
        CheckMethodAdapter.checkMethodDesc((String)name);
    }

    public void checkDesc(String name, boolean canBeVoid) {
        CheckMethodAdapter.checkDesc((String)name, (boolean)canBeVoid);
    }

    public void checkConstant(Object name) {
        CheckMethodAdapter.checkConstant((Object)name);
    }
}

