/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.text.font;

import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.text.font.FontSizeProducer;
import org.pentaho.reporting.libraries.fonts.text.font.GlyphMetrics;

public class VariableFontSizeProducer
implements FontSizeProducer {
    private FontMetrics fontMetrics;
    private int maxHeight;
    private int baseLine;

    public VariableFontSizeProducer(FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            throw new NullPointerException();
        }
        this.fontMetrics = fontMetrics;
        this.maxHeight = (int)(Integer.MAX_VALUE & fontMetrics.getMaxHeight());
        this.baseLine = (int)(Integer.MAX_VALUE & fontMetrics.getMaxHeight() - fontMetrics.getMaxDescent());
    }

    @Override
    public GlyphMetrics getCharacterSize(int codePoint, GlyphMetrics dimension) {
        int width = codePoint == Integer.MIN_VALUE || codePoint == Integer.MAX_VALUE || codePoint == -1 ? 0 : (int)(Integer.MAX_VALUE & this.fontMetrics.getCharWidth(codePoint));
        if (dimension == null) {
            dimension = new GlyphMetrics();
        }
        dimension.setWidth(width);
        dimension.setHeight(this.maxHeight);
        dimension.setBaselinePosition(this.baseLine);
        return dimension;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

