/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import impl.org.controlsfx.tools.MathTools;
import impl.org.controlsfx.tools.rectangle.CoordinatePosition;
import impl.org.controlsfx.tools.rectangle.CoordinatePositions;
import impl.org.controlsfx.tools.rectangle.change.MoveChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.NewChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.Rectangle2DChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToEastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNorthChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNortheastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToNorthwestChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSouthChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSoutheastChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToSouthwestChangeStrategy;
import impl.org.controlsfx.tools.rectangle.change.ToWestChangeStrategy;
import java.util.ArrayList;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.SnapshotView;

public class SnapshotViewBehavior
extends BehaviorBase<SnapshotView> {
    private static final double relativeEdgeTolerance = 0.01;
    private SelectionChange selectionChange;

    public SnapshotViewBehavior(SnapshotView snapshotView) {
        super((Control)snapshotView, new ArrayList());
    }

    private double getTolerance() {
        double meanLength = Math.sqrt(this.getImageWidth() * this.getImageHeight());
        return meanLength * 0.01;
    }

    private Rectangle2D getSelection() {
        return ((SnapshotView)this.getControl()).getSelection();
    }

    private double getImageWidth() {
        return ((SnapshotView)this.getControl()).getNode().prefWidth(-1.0);
    }

    private double getImageHeight() {
        return ((SnapshotView)this.getControl()).getNode().prefHeight(-1.0);
    }

    private boolean isSelectionRatioFixed() {
        return ((SnapshotView)this.getControl()).isSelectionRatioFixed();
    }

    private double getSelectionRatio() {
        return ((SnapshotView)this.getControl()).getFixedSelectionRatio();
    }

    public Cursor handleSelectionEvent(MouseEvent selectionEvent) {
        EventType eventType = selectionEvent.getEventType();
        if (eventType == MouseEvent.MOUSE_MOVED) {
            return this.getCursor(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            return this.handleMousePressedEvent(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_DRAGGED) {
            return this.handleMouseDraggedEvent(selectionEvent);
        }
        if (eventType == MouseEvent.MOUSE_RELEASED) {
            return this.handleMouseReleasedEvent(selectionEvent);
        }
        return Cursor.DEFAULT;
    }

    private Cursor handleMousePressedEvent(MouseEvent selectionEvent) {
        Cursor cursor = this.getCursor(selectionEvent);
        Rectangle2DChangeStrategy selectionChangeStrategy = this.getChangeStrategy(selectionEvent);
        boolean deactivateSelectionIfClick = this.willDeactivateSelectionIfClick(selectionEvent);
        Point2D pointInImage = this.transformToImageCoordiantes(selectionEvent);
        this.selectionChange = new SelectionChange((SnapshotView)this.getControl(), selectionChangeStrategy, cursor, deactivateSelectionIfClick);
        this.selectionChange.beginSelectionChange(pointInImage);
        return this.selectionChange.getCursor();
    }

    private Cursor handleMouseDraggedEvent(MouseEvent selectionEvent) {
        Point2D pointInImage = this.transformToImageCoordiantes(selectionEvent);
        this.selectionChange.continueSelectionChange(pointInImage);
        return this.selectionChange.getCursor();
    }

    private Cursor handleMouseReleasedEvent(MouseEvent selectionEvent) {
        Point2D pointInImage = this.transformToImageCoordiantes(selectionEvent);
        this.selectionChange.endSelectionChange(pointInImage);
        this.selectionChange = null;
        return this.getCursor(selectionEvent);
    }

    private CoordinatePosition getPosition(MouseEvent selectionEvent) {
        boolean noSelection;
        boolean bl = noSelection = !((SnapshotView)this.getControl()).isSelectionValid() || !((SnapshotView)this.getControl()).isSelectionActive();
        if (noSelection) {
            return CoordinatePosition.OUT_OF_RECTANGLE;
        }
        Point2D pointInImage = this.transformToImageCoordiantes(selectionEvent);
        CoordinatePosition onEdge = CoordinatePositions.onEdges(this.getSelection(), pointInImage, this.getTolerance());
        if (onEdge != null) {
            return onEdge;
        }
        return CoordinatePositions.inRectangle(this.getSelection(), pointInImage);
    }

    private Cursor getCursor(MouseEvent selectionEvent) {
        CoordinatePosition position = this.getPosition(selectionEvent);
        switch (position) {
            case IN_RECTANGLE: {
                return Cursor.MOVE;
            }
            case OUT_OF_RECTANGLE: {
                return Cursor.DEFAULT;
            }
            case NORTH_EDGE: {
                return Cursor.N_RESIZE;
            }
            case NORTHEAST_EDGE: {
                return Cursor.NE_RESIZE;
            }
            case EAST_EDGE: {
                return Cursor.E_RESIZE;
            }
            case SOUTHEAST_EDGE: {
                return Cursor.SE_RESIZE;
            }
            case SOUTH_EDGE: {
                return Cursor.S_RESIZE;
            }
            case SOUTHWEST_EDGE: {
                return Cursor.SW_RESIZE;
            }
            case WEST_EDGE: {
                return Cursor.W_RESIZE;
            }
            case NORTHWEST_EDGE: {
                return Cursor.NW_RESIZE;
            }
        }
        throw new IllegalArgumentException("The position " + (Object)((Object)position) + " is not fully implemented.");
    }

    private Rectangle2DChangeStrategy getChangeStrategy(MouseEvent selectionEvent) {
        boolean mousePressed;
        boolean bl = mousePressed = selectionEvent.getEventType() == MouseEvent.MOUSE_PRESSED;
        if (!mousePressed) {
            throw new IllegalArgumentException();
        }
        CoordinatePosition position = this.getPosition(selectionEvent);
        switch (position) {
            case IN_RECTANGLE: {
                return new MoveChangeStrategy(this.getSelection(), this.getImageWidth(), this.getImageHeight());
            }
            case OUT_OF_RECTANGLE: {
                return new NewChangeStrategy(this.isSelectionRatioFixed(), this.getSelectionRatio());
            }
            case NORTH_EDGE: {
                return new ToNorthChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), this.getImageWidth(), this.getImageHeight());
            }
            case NORTHEAST_EDGE: {
                return new ToNortheastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio());
            }
            case EAST_EDGE: {
                return new ToEastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), this.getImageWidth(), this.getImageHeight());
            }
            case SOUTHEAST_EDGE: {
                return new ToSoutheastChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio());
            }
            case SOUTH_EDGE: {
                return new ToSouthChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), this.getImageWidth(), this.getImageHeight());
            }
            case SOUTHWEST_EDGE: {
                return new ToSouthwestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio());
            }
            case WEST_EDGE: {
                return new ToWestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio(), this.getImageWidth(), this.getImageHeight());
            }
            case NORTHWEST_EDGE: {
                return new ToNorthwestChangeStrategy(this.getSelection(), this.isSelectionRatioFixed(), this.getSelectionRatio());
            }
        }
        throw new IllegalArgumentException("The position " + (Object)((Object)position) + " is not fully implemented.");
    }

    private boolean willDeactivateSelectionIfClick(MouseEvent selectionEvent) {
        CoordinatePosition position = this.getPosition(selectionEvent);
        return position == CoordinatePosition.OUT_OF_RECTANGLE;
    }

    private Point2D transformToImageCoordiantes(MouseEvent me) {
        Node n = ((SnapshotView)this.getControl()).getNode();
        double nodeWidth = n == null ? 0.0 : n.prefWidth(-1.0);
        double nodeHeight = n == null ? 0.0 : n.prefHeight(-1.0);
        double xRatio = 1.0;
        double yRatio = 1.0;
        double xInPicture = MathTools.inInterval(0.0, me.getX() / xRatio, nodeWidth);
        double yInPicture = MathTools.inInterval(0.0, me.getY() / yRatio, nodeHeight);
        return new Point2D(xInPicture, yInPicture);
    }

    private static class SelectionChange {
        private final SnapshotView snapshotView;
        private final Rectangle2DChangeStrategy selectionChangeStrategy;
        private final Cursor cursor;
        private final boolean deactivateSelectionIfClick;
        private Point2D startingPoint;
        private boolean mouseMoved;

        public SelectionChange(SnapshotView snapshotView, Rectangle2DChangeStrategy selectionChangeStrategy, Cursor cursor, boolean deactivateSelectionIfClick) {
            this.snapshotView = snapshotView;
            this.selectionChangeStrategy = selectionChangeStrategy;
            this.cursor = cursor;
            this.deactivateSelectionIfClick = deactivateSelectionIfClick;
        }

        public void beginSelectionChange(Point2D point) {
            this.startingPoint = point;
            this.snapshotView.selectionChangingProperty().set(true);
            Rectangle2D newSelection = this.selectionChangeStrategy.beginChange(point);
            this.snapshotView.setSelection(newSelection);
        }

        public void continueSelectionChange(Point2D point) {
            this.updateMouseMoved(point);
            Rectangle2D newSelection = this.selectionChangeStrategy.continueChange(point);
            this.snapshotView.setSelection(newSelection);
        }

        public void endSelectionChange(Point2D point) {
            boolean deactivateSelection;
            this.updateMouseMoved(point);
            Rectangle2D newSelection = this.selectionChangeStrategy.endChange(point);
            this.snapshotView.setSelection(newSelection);
            boolean bl = deactivateSelection = this.deactivateSelectionIfClick && !this.mouseMoved;
            if (deactivateSelection) {
                this.snapshotView.setSelection(null);
            }
            this.snapshotView.selectionChangingProperty().set(false);
        }

        private void updateMouseMoved(Point2D point) {
            boolean mouseMovedNow;
            if (this.mouseMoved) {
                return;
            }
            this.mouseMoved = mouseMovedNow = !this.startingPoint.equals((Object)point);
        }

        public Cursor getCursor() {
            return this.cursor;
        }
    }
}

