/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.event.EventHandlerManager;
import impl.org.controlsfx.skin.AutoCompletePopupSkin;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.stage.Window;
import javafx.util.StringConverter;

public class AutoCompletePopup<T>
extends PopupControl {
    private static final int TITLE_HEIGHT = 28;
    private final ObservableList<T> suggestions = FXCollections.observableArrayList();
    private StringConverter<T> converter;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private ObjectProperty<EventHandler<SuggestionEvent<T>>> onSuggestion = new ObjectPropertyBase<EventHandler<SuggestionEvent<T>>>(){

        protected void invalidated() {
            AutoCompletePopup.this.eventHandlerManager.setEventHandler(SuggestionEvent.SUGGESTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return AutoCompletePopup.this;
        }

        public String getName() {
            return "onSuggestion";
        }
    };
    public static final String DEFAULT_STYLE_CLASS = "auto-complete-popup";

    public AutoCompletePopup() {
        this.setAutoFix(true);
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public ObservableList<T> getSuggestions() {
        return this.suggestions;
    }

    public void show(Node node) {
        if (node.getScene() == null || node.getScene().getWindow() == null) {
            throw new IllegalStateException("Can not show popup. The node must be attached to a scene/window.");
        }
        Window parent = node.getScene().getWindow();
        this.show(parent, parent.getX() + node.localToScene(0.0, 0.0).getX() + node.getScene().getX(), parent.getY() + node.localToScene(0.0, 0.0).getY() + node.getScene().getY() + 28.0);
    }

    public void setConverter(StringConverter<T> converter) {
        this.converter = converter;
    }

    public StringConverter<T> getConverter() {
        return this.converter;
    }

    public final ObjectProperty<EventHandler<SuggestionEvent<T>>> onSuggestionProperty() {
        return this.onSuggestion;
    }

    public final void setOnSuggestion(EventHandler<SuggestionEvent<T>> value) {
        this.onSuggestionProperty().set(value);
    }

    public final EventHandler<SuggestionEvent<T>> getOnSuggestion() {
        return (EventHandler)this.onSuggestionProperty().get();
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return super.buildEventDispatchChain(tail).append((EventDispatcher)this.eventHandlerManager);
    }

    protected Skin<?> createDefaultSkin() {
        return new AutoCompletePopupSkin(this);
    }

    public static class SuggestionEvent<TE>
    extends Event {
        public static final EventType<SuggestionEvent> SUGGESTION = new EventType("SUGGESTION");
        private final TE suggestion;

        public SuggestionEvent(TE suggestion) {
            super(SUGGESTION);
            this.suggestion = suggestion;
        }

        public TE getSuggestion() {
            return this.suggestion;
        }
    }
}

