/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import java.util.ArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Circle;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.VLineTo;
import javafx.stage.Window;
import org.controlsfx.control.PopOver;

public class PopOverSkin
implements Skin<PopOver> {
    private static final String DETACHED_STYLE_CLASS = "detached";
    private double xOffset;
    private double yOffset;
    private boolean tornOff;
    private Label title;
    private Label closeIcon;
    private Path path;
    private BorderPane content;
    private StackPane titlePane;
    private StackPane stackPane;
    private Point2D dragStartLocation;
    private PopOver popOver;
    private MoveTo moveTo;
    private QuadCurveTo topCurveTo;
    private QuadCurveTo rightCurveTo;
    private QuadCurveTo bottomCurveTo;
    private QuadCurveTo leftCurveTo;
    private HLineTo lineBTop;
    private HLineTo lineETop;
    private HLineTo lineHTop;
    private HLineTo lineKTop;
    private LineTo lineCTop;
    private LineTo lineDTop;
    private LineTo lineFTop;
    private LineTo lineGTop;
    private LineTo lineITop;
    private LineTo lineJTop;
    private VLineTo lineBRight;
    private VLineTo lineERight;
    private VLineTo lineHRight;
    private VLineTo lineKRight;
    private LineTo lineCRight;
    private LineTo lineDRight;
    private LineTo lineFRight;
    private LineTo lineGRight;
    private LineTo lineIRight;
    private LineTo lineJRight;
    private HLineTo lineBBottom;
    private HLineTo lineEBottom;
    private HLineTo lineHBottom;
    private HLineTo lineKBottom;
    private LineTo lineCBottom;
    private LineTo lineDBottom;
    private LineTo lineFBottom;
    private LineTo lineGBottom;
    private LineTo lineIBottom;
    private LineTo lineJBottom;
    private VLineTo lineBLeft;
    private VLineTo lineELeft;
    private VLineTo lineHLeft;
    private VLineTo lineKLeft;
    private LineTo lineCLeft;
    private LineTo lineDLeft;
    private LineTo lineFLeft;
    private LineTo lineGLeft;
    private LineTo lineILeft;
    private LineTo lineJLeft;

    public PopOverSkin(PopOver popOver) {
        this.popOver = popOver;
        this.stackPane = new StackPane();
        this.stackPane.getStylesheets().add((Object)PopOver.class.getResource("popover.css").toExternalForm());
        this.stackPane.setPickOnBounds(false);
        this.stackPane.getStyleClass().add((Object)"popover");
        this.stackPane.minWidthProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.multiply((int)2, (ObservableNumberValue)popOver.arrowSizeProperty()), (ObservableNumberValue)Bindings.add((ObservableNumberValue)Bindings.multiply((int)2, (ObservableNumberValue)popOver.cornerRadiusProperty()), (ObservableNumberValue)Bindings.multiply((int)2, (ObservableNumberValue)popOver.arrowIndentProperty()))));
        this.stackPane.minHeightProperty().bind((ObservableValue)this.stackPane.minWidthProperty());
        this.title = new Label();
        this.title.textProperty().bind((ObservableValue)popOver.detachedTitleProperty());
        this.title.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.title.setAlignment(Pos.CENTER);
        this.title.getStyleClass().add((Object)"text");
        this.closeIcon = new Label();
        this.closeIcon.setGraphic(this.createCloseIcon());
        this.closeIcon.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.closeIcon.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.closeIcon.visibleProperty().bind((ObservableValue)popOver.detachedProperty());
        this.closeIcon.getStyleClass().add((Object)"icon");
        this.closeIcon.setAlignment(Pos.CENTER_LEFT);
        this.closeIcon.getGraphic().setOnMouseClicked(evt -> popOver.hide());
        this.titlePane = new StackPane();
        this.titlePane.getChildren().add((Object)this.title);
        this.titlePane.getChildren().add((Object)this.closeIcon);
        this.titlePane.getStyleClass().add((Object)"title");
        this.content = new BorderPane();
        this.content.setCenter(popOver.getContentNode());
        this.content.getStyleClass().add((Object)"content");
        if (popOver.isDetached()) {
            this.content.setTop((Node)this.titlePane);
            popOver.getStyleClass().add((Object)DETACHED_STYLE_CLASS);
            this.content.getStyleClass().add((Object)DETACHED_STYLE_CLASS);
        }
        InvalidationListener updatePathListener = observable -> this.updatePath();
        this.getPopupWindow().xProperty().addListener(updatePathListener);
        this.getPopupWindow().yProperty().addListener(updatePathListener);
        popOver.arrowLocationProperty().addListener(updatePathListener);
        popOver.contentNodeProperty().addListener((value, oldContent, newContent) -> this.content.setCenter(newContent));
        popOver.detachedProperty().addListener((value, oldDetached, newDetached) -> {
            this.updatePath();
            if (newDetached.booleanValue()) {
                popOver.getStyleClass().add((Object)DETACHED_STYLE_CLASS);
                this.content.getStyleClass().add((Object)DETACHED_STYLE_CLASS);
                this.content.setTop((Node)this.titlePane);
            } else {
                popOver.getStyleClass().remove((Object)DETACHED_STYLE_CLASS);
                this.content.getStyleClass().remove((Object)DETACHED_STYLE_CLASS);
                this.content.setTop(null);
            }
        });
        this.path = new Path();
        this.path.getStyleClass().add((Object)"border");
        this.path.setManaged(false);
        this.createPathElements();
        this.updatePath();
        EventHandler mousePressedHandler = evt -> {
            if (popOver.isDetachable() || popOver.isDetached()) {
                this.tornOff = false;
                this.xOffset = evt.getScreenX();
                this.yOffset = evt.getScreenY();
                this.dragStartLocation = new Point2D(this.xOffset, this.yOffset);
            }
        };
        EventHandler mouseReleasedHandler = evt -> {
            if (this.tornOff && !this.getSkinnable().isDetached()) {
                this.tornOff = false;
                this.getSkinnable().detach();
            }
        };
        EventHandler mouseDragHandler = evt -> {
            if (popOver.isDetachable() || popOver.isDetached()) {
                double deltaX = evt.getScreenX() - this.xOffset;
                double deltaY = evt.getScreenY() - this.yOffset;
                Window window = this.getSkinnable().getScene().getWindow();
                window.setX(window.getX() + deltaX);
                window.setY(window.getY() + deltaY);
                this.xOffset = evt.getScreenX();
                this.yOffset = evt.getScreenY();
                if (this.dragStartLocation.distance(this.xOffset, this.yOffset) > 20.0) {
                    this.tornOff = true;
                    this.updatePath();
                } else if (this.tornOff) {
                    this.tornOff = false;
                    this.updatePath();
                }
            }
        };
        this.stackPane.setOnMousePressed(mousePressedHandler);
        this.stackPane.setOnMouseDragged(mouseDragHandler);
        this.stackPane.setOnMouseReleased(mouseReleasedHandler);
        this.stackPane.getChildren().add((Object)this.path);
        this.stackPane.getChildren().add((Object)this.content);
    }

    public Node getNode() {
        return this.stackPane;
    }

    public PopOver getSkinnable() {
        return this.popOver;
    }

    public void dispose() {
    }

    private Node createCloseIcon() {
        Group group = new Group();
        group.getStyleClass().add((Object)"graphics");
        Circle circle = new Circle();
        circle.getStyleClass().add((Object)"circle");
        circle.setRadius(6.0);
        circle.setCenterX(6.0);
        circle.setCenterY(6.0);
        group.getChildren().add((Object)circle);
        Line line1 = new Line();
        line1.getStyleClass().add((Object)"line");
        line1.setStartX(4.0);
        line1.setStartY(4.0);
        line1.setEndX(8.0);
        line1.setEndY(8.0);
        group.getChildren().add((Object)line1);
        Line line2 = new Line();
        line2.getStyleClass().add((Object)"line");
        line2.setStartX(8.0);
        line2.setStartY(4.0);
        line2.setEndX(4.0);
        line2.setEndY(8.0);
        group.getChildren().add((Object)line2);
        return group;
    }

    private void createPathElements() {
        SimpleDoubleProperty centerYProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty centerXProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty leftEdgeProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty leftEdgePlusRadiusProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty topEdgeProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty topEdgePlusRadiusProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty rightEdgeProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty rightEdgeMinusRadiusProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty bottomEdgeProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty bottomEdgeMinusRadiusProperty = new SimpleDoubleProperty();
        DoubleProperty cornerProperty = this.getSkinnable().cornerRadiusProperty();
        DoubleProperty arrowSizeProperty = this.getSkinnable().arrowSizeProperty();
        DoubleProperty arrowIndentProperty = this.getSkinnable().arrowIndentProperty();
        centerYProperty.bind((ObservableValue)Bindings.divide((ObservableNumberValue)this.stackPane.heightProperty(), (int)2));
        centerXProperty.bind((ObservableValue)Bindings.divide((ObservableNumberValue)this.stackPane.widthProperty(), (int)2));
        leftEdgePlusRadiusProperty.bind((ObservableValue)Bindings.add((ObservableNumberValue)leftEdgeProperty, (ObservableNumberValue)this.getSkinnable().cornerRadiusProperty()));
        topEdgePlusRadiusProperty.bind((ObservableValue)Bindings.add((ObservableNumberValue)topEdgeProperty, (ObservableNumberValue)this.getSkinnable().cornerRadiusProperty()));
        rightEdgeProperty.bind((ObservableValue)this.stackPane.widthProperty());
        rightEdgeMinusRadiusProperty.bind((ObservableValue)Bindings.subtract((ObservableNumberValue)rightEdgeProperty, (ObservableNumberValue)this.getSkinnable().cornerRadiusProperty()));
        bottomEdgeProperty.bind((ObservableValue)this.stackPane.heightProperty());
        bottomEdgeMinusRadiusProperty.bind((ObservableValue)Bindings.subtract((ObservableNumberValue)bottomEdgeProperty, (ObservableNumberValue)this.getSkinnable().cornerRadiusProperty()));
        this.moveTo = new MoveTo();
        this.moveTo.xProperty().bind((ObservableValue)leftEdgePlusRadiusProperty);
        this.moveTo.yProperty().bind((ObservableValue)topEdgeProperty);
        this.lineBTop = new HLineTo();
        this.lineBTop.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)leftEdgePlusRadiusProperty, (ObservableNumberValue)arrowIndentProperty));
        this.lineCTop = new LineTo();
        this.lineCTop.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.lineBTop.xProperty(), (ObservableNumberValue)arrowSizeProperty));
        this.lineCTop.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)topEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineDTop = new LineTo();
        this.lineDTop.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.lineCTop.xProperty(), (ObservableNumberValue)arrowSizeProperty));
        this.lineDTop.yProperty().bind((ObservableValue)topEdgeProperty);
        this.lineETop = new HLineTo();
        this.lineETop.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)centerXProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineFTop = new LineTo();
        this.lineFTop.xProperty().bind((ObservableValue)centerXProperty);
        this.lineFTop.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)topEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineGTop = new LineTo();
        this.lineGTop.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)centerXProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineGTop.yProperty().bind((ObservableValue)topEdgeProperty);
        this.lineHTop = new HLineTo();
        this.lineHTop.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)rightEdgeMinusRadiusProperty, (ObservableNumberValue)arrowIndentProperty), (ObservableNumberValue)Bindings.multiply((ObservableNumberValue)arrowSizeProperty, (int)2)));
        this.lineITop = new LineTo();
        this.lineITop.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)rightEdgeMinusRadiusProperty, (ObservableNumberValue)arrowIndentProperty), (ObservableNumberValue)arrowSizeProperty));
        this.lineITop.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)topEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineJTop = new LineTo();
        this.lineJTop.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)rightEdgeMinusRadiusProperty, (ObservableNumberValue)arrowIndentProperty));
        this.lineJTop.yProperty().bind((ObservableValue)topEdgeProperty);
        this.lineKTop = new HLineTo();
        this.lineKTop.xProperty().bind((ObservableValue)rightEdgeMinusRadiusProperty);
        this.rightCurveTo = new QuadCurveTo();
        this.rightCurveTo.xProperty().bind((ObservableValue)rightEdgeProperty);
        this.rightCurveTo.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)topEdgeProperty, (ObservableNumberValue)cornerProperty));
        this.rightCurveTo.controlXProperty().bind((ObservableValue)rightEdgeProperty);
        this.rightCurveTo.controlYProperty().bind((ObservableValue)topEdgeProperty);
        this.lineBRight = new VLineTo();
        this.lineBRight.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)topEdgePlusRadiusProperty, (ObservableNumberValue)arrowIndentProperty));
        this.lineCRight = new LineTo();
        this.lineCRight.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)rightEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineCRight.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.lineBRight.yProperty(), (ObservableNumberValue)arrowSizeProperty));
        this.lineDRight = new LineTo();
        this.lineDRight.xProperty().bind((ObservableValue)rightEdgeProperty);
        this.lineDRight.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.lineCRight.yProperty(), (ObservableNumberValue)arrowSizeProperty));
        this.lineERight = new VLineTo();
        this.lineERight.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)centerYProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineFRight = new LineTo();
        this.lineFRight.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)rightEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineFRight.yProperty().bind((ObservableValue)centerYProperty);
        this.lineGRight = new LineTo();
        this.lineGRight.xProperty().bind((ObservableValue)rightEdgeProperty);
        this.lineGRight.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)centerYProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineHRight = new VLineTo();
        this.lineHRight.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)bottomEdgeMinusRadiusProperty, (ObservableNumberValue)arrowIndentProperty), (ObservableNumberValue)Bindings.multiply((ObservableNumberValue)arrowSizeProperty, (int)2)));
        this.lineIRight = new LineTo();
        this.lineIRight.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)rightEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineIRight.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)bottomEdgeMinusRadiusProperty, (ObservableNumberValue)arrowIndentProperty), (ObservableNumberValue)arrowSizeProperty));
        this.lineJRight = new LineTo();
        this.lineJRight.xProperty().bind((ObservableValue)rightEdgeProperty);
        this.lineJRight.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)bottomEdgeMinusRadiusProperty, (ObservableNumberValue)arrowIndentProperty));
        this.lineKRight = new VLineTo();
        this.lineKRight.yProperty().bind((ObservableValue)bottomEdgeMinusRadiusProperty);
        this.bottomCurveTo = new QuadCurveTo();
        this.bottomCurveTo.xProperty().bind((ObservableValue)rightEdgeMinusRadiusProperty);
        this.bottomCurveTo.yProperty().bind((ObservableValue)bottomEdgeProperty);
        this.bottomCurveTo.controlXProperty().bind((ObservableValue)rightEdgeProperty);
        this.bottomCurveTo.controlYProperty().bind((ObservableValue)bottomEdgeProperty);
        this.lineBBottom = new HLineTo();
        this.lineBBottom.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)rightEdgeMinusRadiusProperty, (ObservableNumberValue)arrowIndentProperty));
        this.lineCBottom = new LineTo();
        this.lineCBottom.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)this.lineBBottom.xProperty(), (ObservableNumberValue)arrowSizeProperty));
        this.lineCBottom.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)bottomEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineDBottom = new LineTo();
        this.lineDBottom.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)this.lineCBottom.xProperty(), (ObservableNumberValue)arrowSizeProperty));
        this.lineDBottom.yProperty().bind((ObservableValue)bottomEdgeProperty);
        this.lineEBottom = new HLineTo();
        this.lineEBottom.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)centerXProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineFBottom = new LineTo();
        this.lineFBottom.xProperty().bind((ObservableValue)centerXProperty);
        this.lineFBottom.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)bottomEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineGBottom = new LineTo();
        this.lineGBottom.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)centerXProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineGBottom.yProperty().bind((ObservableValue)bottomEdgeProperty);
        this.lineHBottom = new HLineTo();
        this.lineHBottom.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.add((ObservableNumberValue)leftEdgePlusRadiusProperty, (ObservableNumberValue)arrowIndentProperty), (ObservableNumberValue)Bindings.multiply((ObservableNumberValue)arrowSizeProperty, (int)2)));
        this.lineIBottom = new LineTo();
        this.lineIBottom.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.add((ObservableNumberValue)leftEdgePlusRadiusProperty, (ObservableNumberValue)arrowIndentProperty), (ObservableNumberValue)arrowSizeProperty));
        this.lineIBottom.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)bottomEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineJBottom = new LineTo();
        this.lineJBottom.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)leftEdgePlusRadiusProperty, (ObservableNumberValue)arrowIndentProperty));
        this.lineJBottom.yProperty().bind((ObservableValue)bottomEdgeProperty);
        this.lineKBottom = new HLineTo();
        this.lineKBottom.xProperty().bind((ObservableValue)leftEdgePlusRadiusProperty);
        this.leftCurveTo = new QuadCurveTo();
        this.leftCurveTo.xProperty().bind((ObservableValue)leftEdgeProperty);
        this.leftCurveTo.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)bottomEdgeProperty, (ObservableNumberValue)cornerProperty));
        this.leftCurveTo.controlXProperty().bind((ObservableValue)leftEdgeProperty);
        this.leftCurveTo.controlYProperty().bind((ObservableValue)bottomEdgeProperty);
        this.lineBLeft = new VLineTo();
        this.lineBLeft.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)bottomEdgeMinusRadiusProperty, (ObservableNumberValue)arrowIndentProperty));
        this.lineCLeft = new LineTo();
        this.lineCLeft.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)leftEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineCLeft.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)this.lineBLeft.yProperty(), (ObservableNumberValue)arrowSizeProperty));
        this.lineDLeft = new LineTo();
        this.lineDLeft.xProperty().bind((ObservableValue)leftEdgeProperty);
        this.lineDLeft.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)this.lineCLeft.yProperty(), (ObservableNumberValue)arrowSizeProperty));
        this.lineELeft = new VLineTo();
        this.lineELeft.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)centerYProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineFLeft = new LineTo();
        this.lineFLeft.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)leftEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineFLeft.yProperty().bind((ObservableValue)centerYProperty);
        this.lineGLeft = new LineTo();
        this.lineGLeft.xProperty().bind((ObservableValue)leftEdgeProperty);
        this.lineGLeft.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)centerYProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineHLeft = new VLineTo();
        this.lineHLeft.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.add((ObservableNumberValue)topEdgePlusRadiusProperty, (ObservableNumberValue)arrowIndentProperty), (ObservableNumberValue)Bindings.multiply((ObservableNumberValue)arrowSizeProperty, (int)2)));
        this.lineILeft = new LineTo();
        this.lineILeft.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)leftEdgeProperty, (ObservableNumberValue)arrowSizeProperty));
        this.lineILeft.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.add((ObservableNumberValue)topEdgePlusRadiusProperty, (ObservableNumberValue)arrowIndentProperty), (ObservableNumberValue)arrowSizeProperty));
        this.lineJLeft = new LineTo();
        this.lineJLeft.xProperty().bind((ObservableValue)leftEdgeProperty);
        this.lineJLeft.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)topEdgePlusRadiusProperty, (ObservableNumberValue)arrowIndentProperty));
        this.lineKLeft = new VLineTo();
        this.lineKLeft.yProperty().bind((ObservableValue)topEdgePlusRadiusProperty);
        this.topCurveTo = new QuadCurveTo();
        this.topCurveTo.xProperty().bind((ObservableValue)leftEdgePlusRadiusProperty);
        this.topCurveTo.yProperty().bind((ObservableValue)topEdgeProperty);
        this.topCurveTo.controlXProperty().bind((ObservableValue)leftEdgeProperty);
        this.topCurveTo.controlYProperty().bind((ObservableValue)topEdgeProperty);
    }

    private Window getPopupWindow() {
        return this.getSkinnable().getScene().getWindow();
    }

    private boolean showArrow(PopOver.ArrowLocation location) {
        PopOver.ArrowLocation arrowLocation = this.getSkinnable().getArrowLocation();
        return location.equals((Object)arrowLocation) && !this.getSkinnable().isDetached() && !this.tornOff;
    }

    private void updatePath() {
        ArrayList<Object> elements = new ArrayList<Object>();
        elements.add(this.moveTo);
        if (this.showArrow(PopOver.ArrowLocation.TOP_LEFT)) {
            elements.add(this.lineBTop);
            elements.add(this.lineCTop);
            elements.add(this.lineDTop);
        }
        if (this.showArrow(PopOver.ArrowLocation.TOP_CENTER)) {
            elements.add(this.lineETop);
            elements.add(this.lineFTop);
            elements.add(this.lineGTop);
        }
        if (this.showArrow(PopOver.ArrowLocation.TOP_RIGHT)) {
            elements.add(this.lineHTop);
            elements.add(this.lineITop);
            elements.add(this.lineJTop);
        }
        elements.add(this.lineKTop);
        elements.add(this.rightCurveTo);
        if (this.showArrow(PopOver.ArrowLocation.RIGHT_TOP)) {
            elements.add(this.lineBRight);
            elements.add(this.lineCRight);
            elements.add(this.lineDRight);
        }
        if (this.showArrow(PopOver.ArrowLocation.RIGHT_CENTER)) {
            elements.add(this.lineERight);
            elements.add(this.lineFRight);
            elements.add(this.lineGRight);
        }
        if (this.showArrow(PopOver.ArrowLocation.RIGHT_BOTTOM)) {
            elements.add(this.lineHRight);
            elements.add(this.lineIRight);
            elements.add(this.lineJRight);
        }
        elements.add(this.lineKRight);
        elements.add(this.bottomCurveTo);
        if (this.showArrow(PopOver.ArrowLocation.BOTTOM_RIGHT)) {
            elements.add(this.lineBBottom);
            elements.add(this.lineCBottom);
            elements.add(this.lineDBottom);
        }
        if (this.showArrow(PopOver.ArrowLocation.BOTTOM_CENTER)) {
            elements.add(this.lineEBottom);
            elements.add(this.lineFBottom);
            elements.add(this.lineGBottom);
        }
        if (this.showArrow(PopOver.ArrowLocation.BOTTOM_LEFT)) {
            elements.add(this.lineHBottom);
            elements.add(this.lineIBottom);
            elements.add(this.lineJBottom);
        }
        elements.add(this.lineKBottom);
        elements.add(this.leftCurveTo);
        if (this.showArrow(PopOver.ArrowLocation.LEFT_BOTTOM)) {
            elements.add(this.lineBLeft);
            elements.add(this.lineCLeft);
            elements.add(this.lineDLeft);
        }
        if (this.showArrow(PopOver.ArrowLocation.LEFT_CENTER)) {
            elements.add(this.lineELeft);
            elements.add(this.lineFLeft);
            elements.add(this.lineGLeft);
        }
        if (this.showArrow(PopOver.ArrowLocation.LEFT_TOP)) {
            elements.add(this.lineHLeft);
            elements.add(this.lineILeft);
            elements.add(this.lineJLeft);
        }
        elements.add(this.lineKLeft);
        elements.add(this.topCurveTo);
        this.path.getElements().setAll(elements);
    }
}

