/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.decoration;

import impl.org.controlsfx.ImplUtils;
import impl.org.controlsfx.skin.DecorationPane;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.controlsfx.control.decoration.Decoration;

public class Decorator {
    private static final String DECORATIONS_PROPERTY_KEY = "$org.controlsfx.decorations$";
    private static List<Scene> currentlyInstallingScenes = new ArrayList<Scene>();

    private Decorator() {
    }

    public static final void addDecoration(Node target, Decoration decoration) {
        Decorator.getDecorations(target, true).add((Object)decoration);
        Decorator.updateDecorationsOnNode(target, (List<Decoration>)FXCollections.observableArrayList((Object[])new Decoration[]{decoration}), null);
    }

    public static final void removeDecoration(Node target, Decoration decoration) {
        Decorator.getDecorations(target, true).remove((Object)decoration);
        Decorator.updateDecorationsOnNode(target, null, (List<Decoration>)FXCollections.observableArrayList((Object[])new Decoration[]{decoration}));
    }

    public static final void removeAllDecorations(Node target) {
        ObservableList<Decoration> decorations = Decorator.getDecorations(target, true);
        ObservableList removed = FXCollections.observableArrayList(decorations);
        target.getProperties().remove((Object)DECORATIONS_PROPERTY_KEY);
        Decorator.updateDecorationsOnNode(target, null, (List<Decoration>)removed);
    }

    public static final ObservableList<Decoration> getDecorations(Node target) {
        return Decorator.getDecorations(target, false);
    }

    private static final ObservableList<Decoration> getDecorations(Node target, boolean createIfAbsent) {
        ObservableList decorations = (ObservableList)target.getProperties().get((Object)DECORATIONS_PROPERTY_KEY);
        if (decorations == null && createIfAbsent) {
            decorations = FXCollections.observableArrayList();
            target.getProperties().put((Object)DECORATIONS_PROPERTY_KEY, (Object)decorations);
        }
        return decorations;
    }

    private static void updateDecorationsOnNode(Node target, List<Decoration> added, List<Decoration> removed) {
        Decorator.getDecorationPane(target, pane -> pane.updateDecorationsOnNode(target, added, removed));
    }

    private static void getDecorationPane(final Node target, Consumer<DecorationPane> task) {
        DecorationPane pane = Decorator.getDecorationPaneInParentHierarchy(target);
        if (pane != null) {
            task.accept(pane);
        } else {
            final Consumer<Scene> sceneConsumer = scene -> {
                if (currentlyInstallingScenes.contains(scene)) {
                    return;
                }
                DecorationPane _pane = Decorator.getDecorationPaneInParentHierarchy(target);
                if (_pane == null) {
                    currentlyInstallingScenes.add((Scene)scene);
                    _pane = new DecorationPane();
                    Parent oldRoot = scene.getRoot();
                    ImplUtils.injectAsRootPane(scene, (Parent)_pane, true);
                    _pane.setRoot((Node)oldRoot);
                    currentlyInstallingScenes.remove(scene);
                }
                task.accept(_pane);
            };
            Scene scene2 = target.getScene();
            if (scene2 != null) {
                sceneConsumer.accept(scene2);
            } else {
                InvalidationListener sceneListener = new InvalidationListener(){

                    public void invalidated(Observable o) {
                        if (target.getScene() != null) {
                            sceneConsumer.accept(target.getScene());
                            target.sceneProperty().removeListener((InvalidationListener)this);
                        }
                    }
                };
                target.sceneProperty().addListener(sceneListener);
            }
        }
    }

    private static DecorationPane getDecorationPaneInParentHierarchy(Node target) {
        for (Parent p = target.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof DecorationPane)) continue;
            return (DecorationPane)p;
        }
        return null;
    }
}

