/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.metadata.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import org.pentaho.reporting.libraries.docbundle.LibDocBundleBoot;
import org.pentaho.reporting.libraries.docbundle.metadata.BundleManifest;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class BundleManifestXmlWriter {
    public static final String NAMESPACE = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
    private static final String CONFIG_PREFIX = "org.pentaho.reporting.libraries.docbundle.metadata.writer.manifest.";
    private BundleManifest bundleManifest;

    public BundleManifestXmlWriter(BundleManifest bundleManifest) {
        if (bundleManifest == null) {
            throw new NullPointerException();
        }
        this.bundleManifest = bundleManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) throws IOException {
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.configure(LibDocBundleBoot.getInstance().getGlobalConfig(), CONFIG_PREFIX);
        XmlWriter writer = new XmlWriter((Writer)new OutputStreamWriter(out, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        writer.setAlwaysAddNamespace(true);
        writer.setWriteFinalLinebreak(true);
        try {
            writer.writeXmlDeclaration("UTF-8");
            AttributeList rootAttributes = new AttributeList();
            rootAttributes.addNamespaceDeclaration("manifest", NAMESPACE);
            writer.writeTag(NAMESPACE, "manifest", rootAttributes, false);
            Object[] entries = this.bundleManifest.getEntries();
            Arrays.sort(entries);
            for (Object fullPath : entries) {
                String mediaType = this.bundleManifest.getMimeType((String)fullPath);
                if (mediaType == null) continue;
                AttributeList entryAttrs = new AttributeList();
                String[] attributeNames = this.bundleManifest.getAttributeNames((String)fullPath);
                for (int j = 0; j < attributeNames.length; ++j) {
                    String attributeName = attributeNames[j];
                    String attr = this.bundleManifest.getAttribute((String)fullPath, attributeName);
                    if (attr == null) continue;
                    entryAttrs.setAttribute(NAMESPACE, attributeName, attr);
                }
                entryAttrs.setAttribute(NAMESPACE, "full-path", (String)fullPath);
                entryAttrs.setAttribute(NAMESPACE, "media-type", mediaType);
                writer.writeTag(NAMESPACE, "file-entry", entryAttrs, true);
            }
            writer.writeCloseTag();
        }
        finally {
            writer.flush();
        }
    }
}

