/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class BaseProgressBarUI
extends BasicProgressBarUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseProgressBarUI();
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        Color[] colorArray = null;
        colorArray = !JTattooUtilities.isActive(jComponent) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (jComponent.isEnabled() ? AbstractLookAndFeel.getTheme().getProgressBarColors() : AbstractLookAndFeel.getTheme().getDisabledColors());
        Color color = ColorHelper.darker(colorArray[colorArray.length - 1], 5.0);
        Color color2 = ColorHelper.darker(colorArray[colorArray.length - 1], 10.0);
        Rectangle rectangle = this.getBox(null);
        if (rectangle != null) {
            graphics2D.setColor(this.progressBar.getForeground());
            JTattooUtilities.draw3DBorder(graphics, color, color2, rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            JTattooUtilities.fillHorGradient(graphics, colorArray, rectangle.x + 2, rectangle.y + 2, rectangle.width - 4, rectangle.height - 4);
        }
        if (this.progressBar.isStringPainted()) {
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(graphics2D, insets.left, insets.top, n, n2, rectangle.width, insets);
            } else {
                this.paintString(graphics2D, insets.left, insets.top, n, n2, rectangle.height, insets);
            }
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        }
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Insets insets = this.progressBar.getInsets();
        int n = this.progressBar.getWidth() - (insets.right + insets.left);
        int n2 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n3 = this.getAmountFull(insets, n, n2);
        Color[] colorArray = null;
        colorArray = !JTattooUtilities.isActive(jComponent) ? AbstractLookAndFeel.getTheme().getInActiveColors() : (jComponent.isEnabled() ? AbstractLookAndFeel.getTheme().getProgressBarColors() : AbstractLookAndFeel.getTheme().getDisabledColors());
        Color color = ColorHelper.darker(colorArray[colorArray.length - 1], 5.0);
        Color color2 = ColorHelper.darker(colorArray[colorArray.length - 1], 10.0);
        if (this.progressBar.getOrientation() == 0) {
            if (JTattooUtilities.isLeftToRight(this.progressBar)) {
                JTattooUtilities.draw3DBorder(graphics, color, color2, 2, 2, n3 - 2, n2 - 2);
                JTattooUtilities.fillHorGradient(graphics, colorArray, 3, 3, n3 - 4, n2 - 4);
            } else {
                JTattooUtilities.draw3DBorder(graphics, color, color2, n - n3 + 2, 2, n - 2, n2 - 2);
                JTattooUtilities.fillHorGradient(graphics, colorArray, n - n3 + 3, 3, n - 4, n2 - 4);
            }
        } else {
            JTattooUtilities.draw3DBorder(graphics, color, color2, 2, 2, n - 2, n3 - 2);
            JTattooUtilities.fillVerGradient(graphics, colorArray, 3, 3, n - 4, n3 - 4);
        }
        if (this.progressBar.isStringPainted()) {
            Object object = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            this.paintString(graphics, insets.left, insets.top, n, n2, n3, insets);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
            }
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            if (this.progressBar.isIndeterminate()) {
                this.paintIndeterminate(graphics, jComponent);
            } else {
                this.paintDeterminate(graphics, jComponent);
            }
        } else {
            this.paintDeterminate(graphics, jComponent);
        }
    }
}

