/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.luna;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.luna.LunaLookAndFeel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class LunaBorders
extends BaseBorders {
    private static Border textFieldBorder = null;
    private static Border comboBoxBorder = null;
    private static Border buttonBorder = null;
    private static Border toggleButtonBorder = null;
    private static Border rolloverToolButtonBorder = null;
    private static Border internalFrameBorder = null;
    private static Border tableHeaderBorder = null;

    public static Border getTextBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new TextFieldBorder();
        }
        return textFieldBorder;
    }

    public static Border getTextFieldBorder() {
        return LunaBorders.getTextBorder();
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new ComboBoxBorder();
        }
        return comboBoxBorder;
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new ToggleButtonBorder();
        }
        return toggleButtonBorder;
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static Border getTableHeaderBorder() {
        if (tableHeaderBorder == null) {
            tableHeaderBorder = new TableHeaderBorder();
        }
        return tableHeaderBorder;
    }

    public static class TableHeaderBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(0, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(ColorHelper.brighter(AbstractLookAndFeel.getControlBackgroundColor(), 40.0));
            graphics.drawLine(0, 0, 0, n4 - 1);
            graphics.setColor(ColorHelper.darker(AbstractLookAndFeel.getControlBackgroundColor(), 20.0));
            graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
            graphics.setColor(ColorHelper.darker(AbstractLookAndFeel.getControlBackgroundColor(), 10.0));
            graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public InternalFrameBorder() {
            this.insets.top = 3;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = this.isActive(component);
            int n5 = this.getTitleHeight(component);
            Color color = LunaLookAndFeel.getWindowTitleBackgroundColor();
            Color color2 = LunaLookAndFeel.getWindowBorderColor();
            if (!bl) {
                color = ColorHelper.brighter(color, 20.0);
                color2 = ColorHelper.brighter(color2, 20.0);
            }
            graphics.setColor(color);
            graphics.fillRect(n, n2 + 1, n3, this.insets.top - 1);
            graphics.setColor(color2);
            graphics.fillRect(n + 1, n2 + n4 - 5, n3 - 2, 4);
            graphics.fillRect(1, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            graphics.fillRect(n3 - 5, this.insets.top + n5 + 1, 4, n4 - n5 - 5);
            if (bl) {
                JTattooUtilities.fillHorGradient(graphics, LunaLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, LunaLookAndFeel.getTheme().getWindowTitleColors(), n3 - 5, this.insets.top, 5, n5 + 1);
            } else {
                JTattooUtilities.fillHorGradient(graphics, LunaLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 5, n5 + 1);
                JTattooUtilities.fillHorGradient(graphics, LunaLookAndFeel.getTheme().getWindowInactiveTitleColors(), n3 - 5, this.insets.top, 5, n5 + 1);
            }
            graphics.setColor(ColorHelper.darker(color2, 15.0));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.drawLine(n + 5 - 1, n2 + this.insets.top + n5, n + 5 - 1, n2 + n4 - 5);
            graphics.drawLine(n + n3 - 5, n2 + this.insets.top + n5, n + n3 - 5, n2 + n4 - 5);
            graphics.drawLine(n + 5 - 1, n2 + n4 - 5, n + n3 - 5, n2 + n4 - 5);
        }
    }

    public static class TextFieldBorder
    extends AbstractBorder
    implements UIResource {
        private static final Color fieldBorderColor = new Color(127, 157, 185);
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(fieldBorderColor);
            graphics.drawRect(n, n2, --n3, --n4);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    public static class ComboBoxBorder
    extends AbstractBorder
    implements UIResource {
        private static final Color fieldBorderColor = new Color(127, 157, 185);
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(fieldBorderColor);
            graphics.drawRect(n, n2, --n3, --n4);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    Color color = ColorHelper.darker(AbstractLookAndFeel.getToolbarBackgroundColor(), 20.0);
                    graphics.setColor(color);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.1f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.black);
                    graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isRollover()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = ColorHelper.darker(colorUIResource, 5.0);
                    Color color2 = ColorHelper.darker(colorUIResource, 30.0);
                    JTattooUtilities.draw3DBorder(graphics, color, color2, n, n2, n3, n4);
                    color = Color.white;
                    color2 = ColorHelper.brighter(color2, 60.0);
                    JTattooUtilities.draw3DBorder(graphics, color, color2, n + 1, n2 + 1, n3 - 2, n4 - 2);
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Composite composite = graphics2D.getComposite();
                    AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.2f);
                    graphics2D.setComposite(alphaComposite);
                    graphics.setColor(Color.white);
                    graphics.fillRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
                    graphics2D.setComposite(composite);
                } else if (buttonModel.isSelected()) {
                    ColorUIResource colorUIResource = AbstractLookAndFeel.getToolbarBackgroundColor();
                    Color color = Color.white;
                    Color color3 = ColorHelper.darker(colorUIResource, 30.0);
                    JTattooUtilities.draw3DBorder(graphics, color3, color, n, n2, n3, n4);
                }
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ToggleButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(3, 6, 3, 6);
        private static final Color frameHiColor1 = Color.white;
        private static final Color frameHiColor2 = new Color(220, 220, 220);
        private static final Color frameLoColor1 = new Color(150, 150, 150);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            if (buttonModel.isEnabled()) {
                if (buttonModel.isPressed() && buttonModel.isArmed() || buttonModel.isSelected()) {
                    JTattooUtilities.draw3DBorder(graphics, frameLoColor1, frameHiColor1, n, n2, n3, n4);
                    JTattooUtilities.draw3DBorder(graphics, AbstractLookAndFeel.getFrameColor(), ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0), n + 1, n2 + 1, n3 - 2, n4 - 2);
                } else {
                    JTattooUtilities.draw3DBorder(graphics, frameHiColor2, frameHiColor1, n, n2, n3, n4);
                    JTattooUtilities.draw3DBorder(graphics, ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0), AbstractLookAndFeel.getFrameColor(), n + 1, n2 + 1, n3 - 2, n4 - 2);
                }
                if (buttonModel.isRollover()) {
                    JTattooUtilities.drawBorder(graphics, AbstractLookAndFeel.getFocusColor(), n + 2, n2 + 2, n3 - 4, n4 - 4);
                    JTattooUtilities.drawBorder(graphics, AbstractLookAndFeel.getFocusColor(), n + 3, n2 + 3, n3 - 6, n4 - 6);
                }
            } else {
                JTattooUtilities.drawBorder(graphics, Color.lightGray, n, n2, n3, n4);
            }
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets borderInsets = new Insets(3, 6, 3, 6);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            AbstractButton abstractButton = (AbstractButton)component;
            ButtonModel buttonModel = abstractButton.getModel();
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = AbstractLookAndFeel.getTheme().getFrameColor();
            if (!JTattooUtilities.isFrameActive(abstractButton)) {
                color = ColorHelper.brighter(color, 40.0);
            }
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.white);
            graphics2D.drawRoundRect(n, n2, n3 - 1, n4 - 1, 6, 6);
            graphics2D.setColor(color);
            graphics2D.drawRoundRect(n, n2, n3 - 2, n4 - 2, 6, 6);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public Insets getBorderInsets(Component component) {
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

