/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdPolyPolygon
extends MfCmd {
    private Object[] points_x;
    private Object[] points_y;
    private Object[] scaled_points_x;
    private Object[] scaled_points_y;
    private int polycount;

    @Override
    public void replay(WmfFile file) {
        Graphics2D graph = file.getGraphics2D();
        MfDcState state = file.getCurrentState();
        GeneralPath genPath = new GeneralPath();
        for (int i = 0; i < this.polycount; ++i) {
            int[] pointsX = this.getScaledPointsX(i);
            int[] pointsY = this.getScaledPointsY(i);
            Polygon polygon = new Polygon(pointsX, pointsY, pointsX.length);
            genPath.append(polygon, false);
        }
        if (state.getLogBrush().isVisible()) {
            state.preparePaint();
            graph.fill(genPath);
            state.postPaint();
        }
        if (state.getLogPen().isVisible()) {
            state.prepareDraw();
            graph.draw(genPath);
            state.postDraw();
        }
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdPolyPolygon();
    }

    @Override
    public int getFunction() {
        return 1336;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[POLYPOLYGON] polycount=");
        b.append(this.getPolygonCount());
        b.append('\n');
        for (int p = 0; p < this.getPolygonCount(); ++p) {
            b.append("  Polygon ");
            b.append(p);
            int[] points_x = this.getPointsX(p);
            int[] points_y = this.getPointsY(p);
            int l = points_x.length;
            for (int i = 0; i < l; ++i) {
                if (i != 0) {
                    b.append(',');
                }
                b.append(" (");
                b.append(points_x[i]);
                b.append(',');
                b.append(points_y[i]);
                b.append(") ");
            }
            b.append('\n');
        }
        return b.toString();
    }

    @Override
    public void setRecord(MfRecord record) {
        int numberOfPolygons = record.getParam(0);
        int[] count = new int[numberOfPolygons];
        Object[] poly_points_x = new Object[numberOfPolygons];
        Object[] poly_points_y = new Object[numberOfPolygons];
        for (int i = 0; i < numberOfPolygons; ++i) {
            int numberOfPointsInPolygon;
            count[i] = numberOfPointsInPolygon = record.getParam(1 + i);
        }
        int readPosition = 1 + numberOfPolygons;
        for (int i = 0; i < numberOfPolygons; ++i) {
            int numberOfPoints = count[i];
            int[] points_x = new int[numberOfPoints];
            int[] points_y = new int[numberOfPoints];
            for (int point = 0; point < numberOfPoints; ++point) {
                points_x[point] = record.getParam(readPosition);
                points_y[point] = record.getParam(++readPosition);
                ++readPosition;
            }
            poly_points_x[i] = points_x;
            poly_points_y[i] = points_y;
        }
        this.setPolygonCount(numberOfPolygons);
        this.setPoints(poly_points_x, poly_points_y);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        int numberOfPolygons = this.getPolygonCount();
        int pointsTotal = 0;
        for (int i = 0; i < numberOfPolygons; ++i) {
            pointsTotal += this.getPointsX(i).length;
        }
        MfRecord record = new MfRecord(1 + numberOfPolygons + pointsTotal * 2);
        record.setParam(0, numberOfPolygons);
        int numberOfPointsRead = 0;
        for (int i = 0; i < numberOfPolygons; ++i) {
            int[] x_points = this.getPointsX(i);
            int[] y_points = this.getPointsY(i);
            int numberOfPointsInPolygon = x_points.length;
            record.setParam(1 + i, numberOfPointsInPolygon);
            int readPos = numberOfPointsRead * 2 + numberOfPolygons + 1;
            for (int j = 0; j < numberOfPointsInPolygon; ++j) {
                record.setParam(readPos + 1 + j * 2, x_points[i]);
                record.setParam(readPos + 2 + j * 2, y_points[i]);
            }
            numberOfPointsRead += numberOfPointsInPolygon;
        }
        return record;
    }

    public void setPoints(Object[] points_x, Object[] points_y) {
        this.points_x = points_x;
        this.points_y = points_y;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public int[] getPointsX(int polygon) {
        return (int[])this.points_x[polygon];
    }

    public int[] getPointsY(int polygon) {
        return (int[])this.points_y[polygon];
    }

    public int[] getScaledPointsX(int polygon) {
        return (int[])this.scaled_points_x[polygon];
    }

    public int[] getScaledPointsY(int polygon) {
        return (int[])this.scaled_points_y[polygon];
    }

    public void setPolygonCount(int count) {
        this.polycount = count;
    }

    public int getPolygonCount() {
        return this.polycount;
    }

    @Override
    protected void scaleXChanged() {
        if (this.scaled_points_x == null) {
            this.scaled_points_x = new Object[this.points_x.length];
        }
        if (this.scaled_points_x.length < this.points_x.length) {
            this.scaled_points_x = new Object[this.points_x.length];
        }
        for (int i = 0; i < this.polycount; ++i) {
            this.scaled_points_x[i] = this.applyScaleX((int[])this.points_x[i], (int[])this.scaled_points_x[i]);
        }
    }

    @Override
    protected void scaleYChanged() {
        if (this.scaled_points_y == null) {
            this.scaled_points_y = new Object[this.points_y.length];
        }
        if (this.scaled_points_y.length < this.points_y.length) {
            this.scaled_points_y = new Object[this.points_y.length];
        }
        for (int i = 0; i < this.polycount; ++i) {
            this.scaled_points_y[i] = this.applyScaleY((int[])this.points_y[i], (int[])this.scaled_points_y[i]);
        }
    }
}

