/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdRestoreDc
extends MfCmd {
    private int dcId;

    @Override
    public void replay(WmfFile file) {
        if (this.dcId == 0) {
            return;
        }
        if (this.dcId > 0) {
            file.restoreDCState(this.dcId);
        } else {
            file.restoreDCState(file.getStateCount() - this.dcId);
        }
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdRestoreDc();
    }

    @Override
    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setNSavedDC(id);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getNSavedDC());
        return record;
    }

    @Override
    public int getFunction() {
        return 295;
    }

    public int getNSavedDC() {
        return this.dcId;
    }

    public void setNSavedDC(int id) {
        this.dcId = id;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[RESTORE_DC] nSavedDC=");
        b.append(this.getNSavedDC());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

