/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSetStretchBltMode
extends MfCmd {
    private static final int RECORD_SIZE = 1;
    private static final int POS_STRETCHMODE = 0;
    private int stretchmode;

    @Override
    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setStretchBltMode(this.stretchmode);
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdSetStretchBltMode();
    }

    @Override
    public void setRecord(MfRecord record) {
        int id = record.getParam(0);
        this.setStretchMode(id);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(1);
        record.setParam(0, this.getStretchMode());
        return record;
    }

    @Override
    public int getFunction() {
        return 263;
    }

    public int getStretchMode() {
        return this.stretchmode;
    }

    public void setStretchMode(int id) {
        this.stretchmode = id;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_STRECH_BLT_MODE] stretchmode=");
        b.append(this.getStretchMode());
        return b.toString();
    }

    @Override
    protected void scaleXChanged() {
    }

    @Override
    protected void scaleYChanged() {
    }
}

