/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.grouping;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.grouping.CGroupingBehavior;
import bibliothek.gui.dock.common.grouping.DockableGrouping;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;

public class GroupingDockLocationListener
extends DockRegisterAdapter
implements DockableFocusListener {
    private CControl control;
    private Listener listener = new Listener();

    public GroupingDockLocationListener(CControl control) {
        this.control = control;
    }

    @Override
    public void dockableRegistered(DockController controller, Dockable dockable) {
        dockable.addDockHierarchyListener(this.listener);
        this.update(dockable);
    }

    @Override
    public void dockableUnregistered(DockController controller, Dockable dockable) {
        dockable.removeDockHierarchyListener(this.listener);
    }

    private void update(Dockable dockable) {
        CGroupingBehavior groupingBehavior = this.control.getProperty(CControl.GROUPING_BEHAVIOR);
        DockableGrouping grouping = groupingBehavior.getGrouping(dockable);
        if (grouping != null) {
            grouping.hierarchyChanged(dockable);
        }
    }

    @Override
    public void dockableFocused(DockableFocusEvent event) {
        CGroupingBehavior groupingBehavior;
        DockableGrouping grouping;
        Dockable dockable = event.getNewFocusOwner();
        if (dockable != null && (grouping = (groupingBehavior = this.control.getProperty(CControl.GROUPING_BEHAVIOR)).getGrouping(dockable)) != null) {
            grouping.focusGained(dockable);
        }
    }

    private class Listener
    implements DockHierarchyListener {
        private Listener() {
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
            GroupingDockLocationListener.this.update(event.getDockable());
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
        }
    }
}

