/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.grouping;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.grouping.DockableGrouping;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.stack.StackDockProperty;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;

public class PlaceholderGrouping
implements DockableGrouping {
    private CControl control;
    private Path placeholder;

    public PlaceholderGrouping(CControl control, Path placeholder) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        if (placeholder == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        this.control = control;
        this.placeholder = placeholder;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    protected Path getLastPlaceholder() {
        return this.placeholder.append("last");
    }

    @Override
    public Location getStoredLocation(Dockable dockable, CLocationMode mode, Location history) {
        return history;
    }

    @Override
    public Location getValidatedLocation(Dockable dockable, CLocationMode mode, Location validatedHistory) {
        Location result;
        if (validatedHistory != null && (result = this.findLocationFor(dockable, mode, validatedHistory)) != validatedHistory) {
            return result;
        }
        result = this.findLocationFor(dockable, mode);
        if (result == null) {
            result = validatedHistory;
        }
        return result;
    }

    @Override
    public ExtendedMode getInitialMode(Dockable dockable) {
        ExtendedMode mode = this.getInitialMode(dockable, true);
        if (mode == null) {
            mode = this.getInitialMode(dockable, false);
        }
        return mode;
    }

    private ExtendedMode getInitialMode(Dockable dockable, boolean validateMode) {
        Path lastPlaceholder = this.getLastPlaceholder();
        for (CLocationMode mode : this.control.getLocationManager().modes()) {
            for (String id : mode.getRepresentationIds()) {
                Dockable child;
                DockStation station = mode.getRepresentation(id);
                if (!station.getPlaceholderMapping().hasPlaceholder(lastPlaceholder)) continue;
                boolean valid = true;
                if (validateMode && (child = station.getPlaceholderMapping().getDockableAt(lastPlaceholder)) != null) {
                    valid = mode.isCurrentMode(child);
                }
                if (!valid) continue;
                return mode.getExtendedMode();
            }
        }
        return null;
    }

    protected Location findLocationFor(Dockable dockable, CLocationMode mode) {
        for (String root : mode.getRepresentationIds()) {
            DockableProperty location;
            DockStation station = mode.getRepresentation(root);
            if (!station.getPlaceholderMapping().hasPlaceholder(this.placeholder) || (location = this.getLocation(station)) == null) continue;
            return new Location(mode.getUniqueIdentifier(), root, location, false);
        }
        return null;
    }

    protected Location findLocationFor(Dockable dockable, CLocationMode mode, Location validatedHistory) {
        DockableProperty location;
        DockStation root = mode.getRepresentation(validatedHistory.getRoot());
        if (root != null && root.getPlaceholderMapping().hasPlaceholder(this.placeholder) && (location = this.getLocation(root)) != null) {
            return new Location(mode.getUniqueIdentifier(), validatedHistory.getRoot(), location, validatedHistory.isApplicationDefined());
        }
        return validatedHistory;
    }

    protected DockableProperty getLocation(DockStation root) {
        DockableProperty result;
        DockableProperty last = result = root.getPlaceholderMapping().getLocationAt(this.placeholder);
        DockableProperty previous = null;
        DockStation parent = root;
        while (last != previous) {
            DockableProperty next;
            PlaceholderMapping mapping;
            previous = last;
            Dockable child = parent.getPlaceholderMapping().getDockableAt(this.placeholder);
            if ((parent = child != null ? child.asDockStation() : null) == null || !(mapping = parent.getPlaceholderMapping()).hasPlaceholder(this.placeholder) || (next = mapping.getLocationAt(this.placeholder)) == null) continue;
            while (last.getSuccessor() != null) {
                last = last.getSuccessor();
            }
            last.setSuccessor(next);
            last = next;
        }
        while (last != null) {
            DockableProperty successor = last.getSuccessor();
            if (successor == null) {
                last.setSuccessor(new StackDockProperty(Integer.MAX_VALUE, this.placeholder));
            }
            last = successor;
        }
        return result;
    }

    @Override
    public void hierarchyChanged(Dockable dockable) {
        this.markLocation(dockable);
    }

    @Override
    public void focusGained(Dockable dockable) {
        this.markLocation(dockable);
    }

    protected void markLocation(Dockable dockable) {
        this.removePlaceholderInMode(dockable);
        this.removePlaceholderEverywhere();
        Path lastPlaceholder = this.getLastPlaceholder();
        DockStation parent = dockable.getDockParent();
        while (parent != null && dockable != null) {
            PlaceholderMapping mapping = parent.getPlaceholderMapping();
            mapping.addPlaceholder(dockable, this.placeholder);
            mapping.addPlaceholder(dockable, lastPlaceholder);
            dockable = parent.asDockable();
            if (dockable == null) continue;
            parent = dockable.getDockParent();
        }
    }

    private void removePlaceholderInMode(Dockable dockable) {
        CLocationMode mode = (CLocationMode)this.control.getLocationManager().getCurrentMode(dockable);
        if (mode == null) {
            return;
        }
        for (String id : mode.getRepresentationIds()) {
            DockStation station = mode.getRepresentation(id);
            if (DockUtilities.isAncestor(station, dockable)) continue;
            station.getPlaceholderMapping().removePlaceholder(this.placeholder);
        }
    }

    public void removePlaceholderEverywhere() {
        Path lastPlaceholder = this.getLastPlaceholder();
        for (CLocationMode mode : this.control.getLocationManager().modes()) {
            for (String id : mode.getRepresentationIds()) {
                DockStation station = mode.getRepresentation(id);
                station.getPlaceholderMapping().removePlaceholder(lastPlaceholder);
            }
        }
    }
}

