/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockFrontendListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.RootStationAdjacentFactory;
import bibliothek.gui.dock.common.intern.layout.CLayoutChangeStrategy;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationSettingConverter;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.support.mode.ModeSettings;
import java.util.ArrayList;
import java.util.List;

public class CDockFrontend
extends DockFrontend {
    private CControlAccess control;
    private List<CDockFrontendListener> listeners = new ArrayList<CDockFrontendListener>();
    private boolean revertToBasicModes = true;

    public CDockFrontend(CControlAccess control, DockController controller) {
        super(controller);
        this.control = control;
        this.setLayoutChangeStrategy(new CLayoutChangeStrategy(control.getOwner()));
        this.registerAdjacentFactory(new RootStationAdjacentFactory());
    }

    public void addListener(CDockFrontendListener listener) {
        this.listeners.add(listener);
    }

    protected CDockFrontendListener[] frontendListeners() {
        return this.listeners.toArray(new CDockFrontendListener[this.listeners.size()]);
    }

    public void removeListener(CDockFrontendListener listener) {
        this.listeners.remove(listener);
    }

    public void setRevertToBasicModes(boolean revertToBasicModes) {
        this.revertToBasicModes = revertToBasicModes;
    }

    public boolean isRevertToBasicModes() {
        return this.revertToBasicModes;
    }

    @Override
    public void remove(Dockable dockable) {
        CDockable cdockable;
        String key;
        if (dockable instanceof CommonDockable && (key = this.control.shouldStore(cdockable = ((CommonDockable)dockable).getDockable())) != null) {
            this.addEmpty(key);
        }
        super.remove(dockable);
    }

    @Override
    protected Setting createSetting() {
        CSetting setting = new CSetting();
        CLocationModeManager manager = this.control.getLocationManager();
        ModeSettings<Location, Location> modeSettings = manager.createSettings(new LocationSettingConverter(this.getController()));
        setting.setModes(modeSettings);
        return setting;
    }

    @Override
    public Setting getSetting(boolean entry) {
        CLocationModeManager manager = this.control.getLocationManager();
        CSetting setting = (CSetting)super.getSetting(entry);
        ModeSettings<Location, Location> modeSettings = manager.createSettings(new LocationSettingConverter(this.getController()));
        setting.setModes(modeSettings);
        manager.writeSettings(modeSettings);
        return setting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSetting(final Setting setting, final boolean entry) {
        for (CDockFrontendListener listener : this.frontendListeners()) {
            listener.loading(this, (CSetting)setting);
        }
        try {
            CLocationModeManager manager = this.control.getLocationManager();
            if (entry) {
                manager.resetWorkingAreaChildren();
            }
            manager.readSettings(((CSetting)setting).getModes());
            manager.runLayoutTransaction(new Runnable(){

                @Override
                public void run() {
                    CDockFrontend.super.setSetting(setting, entry);
                }
            });
            if (this.revertToBasicModes) {
                manager.ensureBasicModes();
            }
            manager.refresh();
        }
        finally {
            for (CDockFrontendListener listener : this.frontendListeners()) {
                listener.loaded(this, (CSetting)setting);
            }
        }
    }
}

