/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CSetting
extends Setting {
    private ModeSettings<Location, Location> modes;

    public void setModes(ModeSettings<Location, Location> modes) {
        this.modes = modes;
    }

    public ModeSettings<Location, Location> getModes() {
        return this.modes;
    }

    @Override
    public void write(DockSituation situation, PropertyTransformer transformer, boolean entry, DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_1_1);
        super.write(situation, transformer, entry, out);
        this.modes.write(out);
    }

    @Override
    public void writeXML(DockSituation situation, PropertyTransformer transformer, boolean entry, XElement element) {
        super.writeXML(situation, transformer, entry, element.addElement("base"));
        this.modes.writeXML(element.addElement("modes"));
    }

    @Override
    public void read(DockSituation situation, PropertyTransformer transformer, boolean entry, DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        boolean version7 = version.compareTo(Version.VERSION_1_0_7) >= 0;
        boolean version11 = version.compareTo(Version.VERSION_1_1_1) >= 0;
        super.read(situation, transformer, entry, in);
        this.modes.read(in);
        if (version7 && !version11) {
            int n = in.readInt();
            for (int i = 0; i < n; ++i) {
                in.readUTF();
                int m = in.readInt();
                for (int j = 0; j < m; ++j) {
                    in.readUTF();
                }
            }
        }
    }

    @Override
    public void readXML(DockSituation situation, PropertyTransformer transformer, boolean entry, XElement element) {
        super.readXML(situation, transformer, entry, element.getElement("base"));
        this.modes.readXML(element.getElement("modes"));
    }
}

