/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CSeparator;
import bibliothek.gui.dock.common.intern.AbstractCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.DefaultCommonDockable;
import bibliothek.gui.dock.dockable.IconHandling;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.Icon;

public class DefaultCDockable
extends AbstractCDockable {
    private boolean minimizable;
    private boolean maximizable;
    private boolean externalizable;
    private boolean closeable;
    private boolean stackable;

    public DefaultCDockable() {
        this(Permissions.DEFAULT);
    }

    public DefaultCDockable(Permissions permission) {
        this.setMinimizable(permission.isMinimizable());
        this.setMaximizable(permission.isMaximizable());
        this.setExternalizable(permission.isExternalizable());
        this.setStackable(permission.isStackable());
        this.setCloseable(permission.isCloseable());
    }

    @Override
    protected DefaultCommonDockable createCommonDockable() {
        return new DefaultCommonDockable(this, this.getClose());
    }

    public Container getContentPane() {
        return this.intern().getContentPane();
    }

    public void setLayout(LayoutManager layout) {
        this.getContentPane().setLayout(layout);
    }

    public void add(Component component) {
        this.getContentPane().add(component);
    }

    public void add(Component component, Object constraints) {
        this.getContentPane().add(component, constraints);
    }

    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    public void setTitleText(String text) {
        this.intern().setTitleText(text);
    }

    public String getTitleText() {
        return this.intern().getTitleText();
    }

    public void setTitleToolTip(String text) {
        this.intern().setTitleToolTip(text);
    }

    public String getTitleToolTip() {
        return this.intern().getTitleToolTip();
    }

    public void setTitleIconHandling(IconHandling handling) {
        this.intern().setTitleIconHandling(handling);
    }

    public IconHandling getTitleIconHandling() {
        return this.intern().getTitleIconHandling();
    }

    public void setTitleIcon(Icon icon) {
        this.intern().setTitleIcon(icon);
    }

    public Icon getTitleIcon() {
        return this.intern().getTitleIcon();
    }

    @Override
    public boolean isMinimizable() {
        return this.minimizable;
    }

    public void setMinimizable(boolean minimizable) {
        if (this.minimizable != minimizable) {
            this.minimizable = minimizable;
            this.listenerCollection.getCDockablePropertyListener().minimizableChanged(this);
            CControlAccess control = this.control();
            if (control != null) {
                control.getLocationManager().ensureValidLocation(this);
            }
        }
    }

    @Override
    public boolean isMaximizable() {
        return this.maximizable;
    }

    public void setMaximizable(boolean maximizable) {
        if (this.maximizable != maximizable) {
            this.maximizable = maximizable;
            this.listenerCollection.getCDockablePropertyListener().maximizableChanged(this);
            CControlAccess control = this.control();
            if (control != null) {
                control.getLocationManager().ensureValidLocation(this);
            }
        }
    }

    @Override
    public boolean isExternalizable() {
        return this.externalizable;
    }

    public void setExternalizable(boolean externalizable) {
        if (this.externalizable != externalizable) {
            this.externalizable = externalizable;
            this.listenerCollection.getCDockablePropertyListener().externalizableChanged(this);
            CControlAccess control = this.control();
            if (control != null) {
                control.getLocationManager().ensureValidLocation(this);
            }
        }
    }

    @Override
    public boolean isCloseable() {
        return this.closeable;
    }

    public void setStackable(boolean stackable) {
        this.stackable = stackable;
    }

    @Override
    public boolean isStackable() {
        return this.stackable;
    }

    public void setCloseable(boolean closeable) {
        if (this.closeable != closeable) {
            this.closeable = closeable;
            this.listenerCollection.getCDockablePropertyListener().closeableChanged(this);
        }
    }

    public void addAction(CAction action) {
        this.intern().getActions().add(action);
    }

    public void insertAction(int index, CAction action) {
        this.intern().getActions().insert(index, action);
    }

    public void addSeparator() {
        this.addAction(CSeparator.SEPARATOR);
    }

    public void insertSeparator(int index) {
        this.insertAction(index, CSeparator.SEPARATOR);
    }

    public void removeAction(int index) {
        this.intern().getActions().remove(index);
    }

    public void removeAction(CAction action) {
        this.intern().getActions().remove(action);
    }

    public int getActionCount() {
        return this.intern().getActions().getDockActionCount();
    }

    public CAction getAction(int index) {
        return this.intern().getActions().getAction(index);
    }

    @Override
    public DefaultCommonDockable intern() {
        return (DefaultCommonDockable)super.intern();
    }

    @Override
    public CStation<?> asStation() {
        return null;
    }

    public static enum Permissions {
        NONE(false, false, false, false, false),
        ALL(true, true, true, true, true),
        DEFAULT(true, true, true, true, false),
        MIN(true, false, false, false, false),
        MAX(false, true, false, false, false),
        EXT(false, false, true, false, false),
        STACK(false, false, false, true, false),
        CLOSE(false, false, false, false, true),
        MIN_MAX(true, true, false, false, false),
        MIN_EXT(true, false, true, false, false),
        MIN_STACK(true, false, false, true, false),
        MIN_CLOSE(true, false, false, false, true),
        MAX_EXT(false, true, true, false, false),
        MAX_STACK(false, true, false, true, false),
        MAX_CLOSE(false, true, false, false, true),
        EXT_STACK(false, false, true, true, false),
        EXT_CLOSE(false, false, true, false, true),
        STACK_CLOSE(false, false, false, true, true),
        MIN_MAX_EXT(true, true, true, false, false),
        MIN_MAX_STACK(true, true, false, true, true),
        MIN_MAX_CLOSE(true, true, false, false, true),
        MIN_EXT_STACK(true, false, true, true, false),
        MIN_EXT_CLOSE(true, false, true, false, true),
        MIN_STACK_CLOSE(true, false, false, true, true),
        MAX_EXT_STACK(false, true, true, true, false),
        MAX_EXT_CLOSE(false, true, true, false, true),
        MAX_STACK_CLOSE(false, true, false, true, true),
        MIN_MAX_EXT_STACK(true, true, true, true, false),
        MIN_MAX_EXT_CLOSE(true, true, true, false, true),
        MIN_MAX_STACK_CLOSE(true, true, false, true, true),
        MIN_EXT_STACK_CLOSE(true, false, true, true, true),
        MAX_EXT_STACK_CLOSE(false, true, true, true, true),
        MIN_MAX_EXT_STACK_CLOSE(true, true, true, true, true);

        private boolean minimizable;
        private boolean maximizable;
        private boolean externalizable;
        private boolean stackable;
        private boolean closeable;

        private Permissions(boolean min, boolean max, boolean ext, boolean stack, boolean close) {
            this.minimizable = min;
            this.maximizable = max;
            this.externalizable = ext;
            this.stackable = stack;
            this.closeable = close;
        }

        public boolean isCloseable() {
            return this.closeable;
        }

        public boolean isExternalizable() {
            return this.externalizable;
        }

        public boolean isMaximizable() {
            return this.maximizable;
        }

        public boolean isMinimizable() {
            return this.minimizable;
        }

        public boolean isStackable() {
            return this.stackable;
        }
    }
}

