/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.common.action.CAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CActionSource
extends AbstractDockActionSource {
    private List<CAction> actions = new ArrayList<CAction>();
    private LocationHint hint;

    public CActionSource(LocationHint hint) {
        if (hint == null) {
            throw new IllegalArgumentException("hint must not be null");
        }
        this.hint = hint;
    }

    public void add(CAction action) {
        this.insert(this.getDockActionCount(), action);
    }

    public void insert(int index, CAction action) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        this.actions.add(index, action);
        this.fireAdded(index, index);
    }

    public CAction set(int index, CAction action) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (index == this.actions.size()) {
            this.add(action);
            return null;
        }
        CAction result = this.remove(index);
        this.insert(index, action);
        return result;
    }

    public CAction remove(int index) {
        CAction action = this.actions.remove(index);
        this.fireRemoved(index, index);
        return action;
    }

    public boolean remove(CAction action) {
        int index = this.actions.indexOf(action);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public CAction getAction(int index) {
        return this.actions.get(index);
    }

    @Override
    public DockAction getDockAction(int index) {
        return this.getAction(index).intern();
    }

    @Override
    public int getDockActionCount() {
        return this.actions.size();
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private int index = 0;
            private boolean removed = false;

            @Override
            public boolean hasNext() {
                return this.index < CActionSource.this.getDockActionCount();
            }

            @Override
            public DockAction next() {
                this.removed = false;
                return CActionSource.this.getDockAction(this.index++);
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("item already removed");
                }
                this.removed = true;
                CActionSource.this.remove(this.index--);
            }
        };
    }
}

