/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.layout;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.dock.common.perspective.CControlPerspective;
import bibliothek.gui.dock.frontend.SettingsBlop;
import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CControlPerspectiveResource
implements ApplicationResource {
    private CControlPerspective control;
    private SettingsBlop settings = new SettingsBlop();

    public CControlPerspectiveResource(CControlPerspective control) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = control;
    }

    public SettingsBlop getSettings() {
        return this.settings;
    }

    public void setSettings(SettingsBlop settings) {
        this.settings = settings;
    }

    private DockFrontend getFrontend() {
        return this.control.getControl().intern();
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_0_4);
        this.getFrontend().writeBlop(this.settings, out);
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        if (Version.VERSION_1_1_1.compareTo(version) > 0) {
            throw new IOException("The perspective API cannot read files which were written before version 1.1.1");
        }
        version.checkCurrent();
        this.settings = this.getFrontend().readBlop(in);
    }

    @Override
    public void writeXML(XElement element) {
        this.getFrontend().writeBlopXML(this.settings, element.addElement("frontend"));
    }

    @Override
    public void readXML(XElement element) {
        this.settings = this.getFrontend().readBlopXML(element.getElement("frontend"));
    }
}

