/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.displayer.SingleTabDecider;
import bibliothek.gui.dock.event.SingleTabDeciderListener;
import java.util.ArrayList;
import java.util.List;

public class CommonSingleTabDecider
implements SingleTabDecider {
    private List<SingleTabDeciderListener> listeners = new ArrayList<SingleTabDeciderListener>();
    private CControl control;
    private CDockablePropertyListener dockableListener = new CDockableAdapter(){

        @Override
        public void singleTabShownChanged(CDockable cdockable) {
            CommonDockable dockable = cdockable.intern();
            for (SingleTabDeciderListener listener : CommonSingleTabDecider.this.listeners()) {
                listener.showSingleTabChanged(CommonSingleTabDecider.this, dockable);
            }
        }
    };

    public CommonSingleTabDecider(CControl control) {
        this.control = control;
    }

    @Override
    public void addSingleTabDeciderListener(SingleTabDeciderListener listener) {
        boolean empty = this.listeners.isEmpty();
        this.listeners.add(listener);
        if (empty) {
            this.control.addPropertyListener(this.dockableListener);
        }
    }

    @Override
    public void removeSingleTabDeciderListener(SingleTabDeciderListener listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.control.removePropertyListener(this.dockableListener);
        }
    }

    protected SingleTabDeciderListener[] listeners() {
        return this.listeners.toArray(new SingleTabDeciderListener[this.listeners.size()]);
    }

    @Override
    public boolean showSingleTab(DockStation station, Dockable dockable) {
        if (dockable.asDockStation() != null) {
            return false;
        }
        if (station instanceof StackDockStation) {
            return false;
        }
        if (dockable instanceof CommonDockable) {
            CDockable cdockable = ((CommonDockable)dockable).getDockable();
            return cdockable.isSingleTabShown();
        }
        return false;
    }
}

