/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractStackholdingLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.location.TreeLocationLeaf;
import bibliothek.gui.dock.common.location.TreeLocationNode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;

public abstract class AbstractTreeLocation
extends AbstractStackholdingLocation {
    private double size;
    private Side side;
    private long nodeId = -1L;

    public AbstractTreeLocation(double size, Side side, long nodeId) {
        if (size < 0.0) {
            throw new IllegalArgumentException("Size must be at least 0");
        }
        if (size > 1.0) {
            throw new IllegalArgumentException("Size must be no more than 1");
        }
        if (Double.isNaN(size)) {
            throw new IllegalArgumentException("Size must not be NaN");
        }
        if (side == null) {
            throw new NullPointerException("side must not be null");
        }
        this.size = size;
        this.side = side;
        this.nodeId = nodeId;
    }

    public Side getSide() {
        return this.side;
    }

    public double getSize() {
        return this.size;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public TreeLocationNode north(double size) {
        return this.north(size, -1L);
    }

    public TreeLocationNode north(double size, long nodeId) {
        return new TreeLocationNode(this, size, Side.NORTH, nodeId);
    }

    public TreeLocationNode south(double size) {
        return this.south(size, -1L);
    }

    public TreeLocationNode south(double size, long nodeId) {
        return new TreeLocationNode(this, size, Side.SOUTH, nodeId);
    }

    public TreeLocationNode east(double size) {
        return this.east(size, -1L);
    }

    public TreeLocationNode east(double size, long nodeId) {
        return new TreeLocationNode(this, size, Side.EAST, nodeId);
    }

    public TreeLocationNode west(double size) {
        return this.west(size, -1L);
    }

    public TreeLocationNode west(double size, long nodeId) {
        return new TreeLocationNode(this, size, Side.WEST, nodeId);
    }

    public TreeLocationLeaf leaf(long leafId) {
        return new TreeLocationLeaf(this, leafId);
    }

    @Override
    public ExtendedMode findMode() {
        return ExtendedMode.NORMALIZED;
    }

    protected abstract SplitDockPathProperty findParentProperty();

    @Override
    public SplitDockPathProperty findProperty(DockableProperty successor) {
        SplitDockPathProperty property = this.findParentProperty();
        property.setSuccessor(successor);
        switch (this.side) {
            case NORTH: {
                property.add(SplitDockPathProperty.Location.TOP, this.size, this.nodeId);
                break;
            }
            case SOUTH: {
                property.add(SplitDockPathProperty.Location.BOTTOM, this.size, this.nodeId);
                break;
            }
            case EAST: {
                property.add(SplitDockPathProperty.Location.RIGHT, this.size, this.nodeId);
                break;
            }
            case WEST: {
                property.add(SplitDockPathProperty.Location.LEFT, this.size, this.nodeId);
            }
        }
        return property;
    }

    @Override
    @Deprecated
    public CLocation aside() {
        return this.stack(1);
    }

    public String toString() {
        return "[normal " + (Object)((Object)this.side) + " " + this.size + "]";
    }
}

