/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableLayout;
import bibliothek.gui.dock.common.intern.station.CommonDockStationFactory;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CControlPerspectiveBlop;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.LocationHistory;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationSettingConverter;
import bibliothek.gui.dock.frontend.DockFrontendPerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.RegisteringDockFactory;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.layout.DockSituation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.PredefinedDockSituation;
import bibliothek.gui.dock.layout.PropertyTransformer;
import bibliothek.gui.dock.perspective.Perspective;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.perspective.PredefinedPerspective;
import bibliothek.gui.dock.support.mode.ModeSettings;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CControlPerspective {
    private CControlAccess control;

    public CControlPerspective(CControlAccess control) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = control;
    }

    public CControl getControl() {
        return this.control.getOwner();
    }

    public CPerspective createEmptyPerspective() {
        CPerspective perspective = new CPerspective(this.control);
        for (CStation<?> station : this.control.getOwner().getStations()) {
            perspective.addStation(station.createPerspective());
        }
        return perspective;
    }

    public CPerspective getPerspective(boolean includeWorkingAreas) {
        Setting setting = this.control.getOwner().intern().getSetting(!includeWorkingAreas);
        return this.convert((CSetting)setting, includeWorkingAreas);
    }

    public String[] getNames() {
        return this.control.getOwner().layouts();
    }

    public CPerspective getPerspective(String name) {
        return this.getPerspective(name, false);
    }

    public CPerspective getPerspective(String name, boolean includeWorkingAreas) {
        Setting setting = this.control.getOwner().intern().getSetting(name);
        if (setting == null) {
            return null;
        }
        return this.convert((CSetting)setting, includeWorkingAreas);
    }

    public void setPerspective(CPerspective perspective, boolean includeWorkingAreas) {
        this.control.getOwner().intern().setSetting(this.convert(perspective, includeWorkingAreas), !includeWorkingAreas);
    }

    public void setPerspective(String name, CPerspective perspective) {
        this.setPerspective(name, perspective, false);
    }

    public void setPerspective(String name, CPerspective perspective, boolean includeWorkingAreas) {
        this.control.getOwner().intern().setSetting(name, this.convert(perspective, includeWorkingAreas));
    }

    public void removePerspective(String name) {
        this.control.getOwner().delete(name);
    }

    public void renamePerspective(String source, String destination) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        CDockFrontend frontend = this.control.getOwner().intern();
        Setting layout = frontend.getSetting(source);
        if (layout == null) {
            throw new IllegalArgumentException("no perspective registered with name '" + source + "'");
        }
        frontend.setSetting(destination, layout);
        frontend.delete(source);
        if (source.equals(frontend.getCurrentSetting())) {
            frontend.setCurrentSettingName(destination);
        }
    }

    public void writeXML(XElement root, CPerspective perspective) {
        this.writeXML(root, perspective, true);
    }

    public void writeXML(XElement root, CPerspective perspective, boolean includeWorkingAreas) {
        perspective.storeLocations();
        DockFrontendPerspective frontend = this.conversion(perspective, includeWorkingAreas);
        PredefinedPerspective conversion = frontend.getPerspective();
        HashMap<String, DockLayoutComposition> stations = new HashMap<String, DockLayoutComposition>();
        for (String key : perspective.getStationKeys()) {
            CStationPerspective station = perspective.getStation(key);
            if (station.asDockable() != null && station.asDockable().getParent() != null) continue;
            stations.put(key, conversion.convert(station.intern()));
        }
        ((Perspective)conversion).getSituation().writeCompositionsXML(stations, root.addElement("stations"));
        XElement xinvisible = root.addElement("invisible");
        PropertyTransformer transformer = frontend.getPropertyTransformer();
        for (String key : perspective.getDockableKeys()) {
            CDockablePerspective dockable = perspective.getDockable(key);
            Location location = this.getInvisibleLocation(dockable);
            if (location == null) continue;
            XElement xdockable = xinvisible.addElement("dockable");
            xdockable.addString("key", key);
            if (dockable.getParent() == null) {
                ((Perspective)conversion).getSituation().writeCompositionXML(conversion.convert(dockable.intern()), xdockable.addElement("content"));
            }
            XElement xlocation = xdockable.addElement("location");
            xlocation.addString("root", location.getRoot());
            xlocation.addString("mode", dockable.getLocationHistory().getLastMode().getModeIdentifier().toString());
            xlocation.addBoolean("applicationDefined", location.isApplicationDefined());
            transformer.writeXML(location.getLocation(), xlocation);
        }
        ModeSettings<Location, Location> settings = perspective.getLocationManager().writeModes(this.control);
        settings.writeXML(root.addElement("modes"));
    }

    public void write(DataOutputStream out, CPerspective perspective) throws IOException {
        this.write(out, perspective, true);
    }

    public void write(DataOutputStream out, CPerspective perspective, boolean includeWorkingAreas) throws IOException {
        perspective.storeLocations();
        Version.write(out, Version.VERSION_1_1_2);
        DockFrontendPerspective frontend = this.conversion(perspective, includeWorkingAreas);
        PredefinedPerspective conversion = frontend.getPerspective();
        HashMap<String, DockLayoutComposition> stations = new HashMap<String, DockLayoutComposition>();
        for (String key : perspective.getStationKeys()) {
            CStationPerspective station = perspective.getStation(key);
            stations.put(key, conversion.convert(station.intern()));
        }
        ((Perspective)conversion).getSituation().writeCompositions(stations, out);
        String[] keys = perspective.getDockableKeys();
        out.writeInt(keys.length);
        PropertyTransformer transformer = frontend.getPropertyTransformer();
        for (String key : keys) {
            CDockablePerspective dockable = perspective.getDockable(key);
            Location location = this.getInvisibleLocation(dockable);
            if (location != null) {
                out.writeBoolean(true);
                out.writeUTF(key);
                if (dockable.getParent() == null) {
                    out.writeBoolean(true);
                    ((Perspective)conversion).getSituation().writeComposition(conversion.convert(dockable.intern()), out);
                } else {
                    out.writeBoolean(false);
                }
                out.writeUTF(location.getRoot());
                out.writeUTF(dockable.getLocationHistory().getLastMode().getModeIdentifier().toString());
                out.writeBoolean(location.isApplicationDefined());
                transformer.write(location.getLocation(), out);
                continue;
            }
            out.writeBoolean(false);
        }
        ModeSettings<Location, Location> settings = perspective.getLocationManager().writeModes(this.control);
        settings.write(out);
    }

    public CSetting write(CPerspective perspective, boolean includeWorkingAreas) {
        return this.convert(perspective, includeWorkingAreas);
    }

    public CControlPerspectiveBlop readAllXML(XElement root) throws XException {
        CControlPerspectiveBlop blop = new CControlPerspectiveBlop(this);
        blop.readXML(root);
        return blop;
    }

    public CPerspective readXML(XElement root) throws XException {
        return this.readXML(root, true);
    }

    public CPerspective readXML(XElement root, boolean includeWorkingAreas) throws XException {
        XElement xmodes;
        CPerspective perspective = this.createEmptyPerspective();
        PerspectiveElementFactory factory = new PerspectiveElementFactory(perspective);
        DockFrontendPerspective frontend = this.wrap(perspective, includeWorkingAreas, factory);
        PredefinedPerspective conversion = frontend.getPerspective();
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> item : this.control.getRegister().getFactories().entrySet()) {
            ((Perspective)conversion).getSituation().add(new CommonMultipleDockableFactory(item.getKey(), item.getValue(), this.control, perspective));
        }
        XElement xstations = root.getElement("stations");
        if (xstations == null) {
            throw new XException("missing element 'stations'");
        }
        Map<String, DockLayoutComposition> stations = ((Perspective)conversion).getSituation().readCompositionsXML(xstations);
        factory.setStations(stations);
        for (DockLayoutComposition composition : stations.values()) {
            CStationPerspective stationPerspective;
            XElement[] station = conversion.convert(composition);
            if (!(station instanceof CommonElementPerspective) || (stationPerspective = ((CommonElementPerspective)station).getElement().asStation()) == null) continue;
            perspective.addStation(stationPerspective);
        }
        perspective.storeLocations();
        XElement xinvisible = root.getElement("invisible");
        if (xinvisible != null) {
            PropertyTransformer transformer = frontend.getPropertyTransformer();
            for (XElement xdockable : xinvisible.getElements("dockable")) {
                ExtendedMode extendedMode;
                PerspectiveElement element;
                XElement xcontent;
                String key = xdockable.getString("key");
                CDockablePerspective dockable = perspective.getDockable(key);
                if (dockable == null && (xcontent = xdockable.getElement("content")) != null && (element = conversion.convert(((Perspective)conversion).getSituation().readCompositionXML(xcontent))) instanceof CommonElementPerspective && (dockable = ((CommonElementPerspective)element).getElement().asDockable()) != null) {
                    perspective.putDockable(dockable);
                }
                if (dockable == null) continue;
                XElement xlocation = xdockable.getElement("location");
                String locationRoot = xlocation.getString("root");
                DockableProperty location = transformer.readXML(xlocation);
                Path mode = new Path(xlocation.getString("mode"));
                boolean applicationDefined = false;
                if (xlocation.attributeExists("applicationDefined")) {
                    applicationDefined = xlocation.getBoolean("applicationDefined");
                }
                if ((extendedMode = perspective.getLocationManager().getMode(mode)) == null) continue;
                dockable.getLocationHistory().add(extendedMode, new Location(mode, locationRoot, location, applicationDefined));
            }
        }
        if ((xmodes = root.getElement("modes")) == null) {
            throw new XException("missing element 'modes'");
        }
        LocationSettingConverter converter = new LocationSettingConverter(this.control.getOwner().getController());
        ModeSettings<Location, Location> modes = this.control.getOwner().getLocationManager().createModeSettings(converter);
        modes.readXML(xmodes);
        perspective.getLocationManager().readModes(modes, perspective, this.control);
        return perspective;
    }

    public CControlPerspectiveBlop readAll(DataInputStream in) throws IOException {
        CControlPerspectiveBlop blop = new CControlPerspectiveBlop(this);
        blop.read(in);
        return blop;
    }

    public CPerspective read(DataInputStream in) throws IOException {
        return this.read(in, true);
    }

    public CPerspective read(DataInputStream in, boolean includeWorkingAreas) throws IOException {
        Version version = Version.read(in);
        boolean version111 = version.equals(Version.VERSION_1_1_1);
        boolean version111a = version.equals(Version.VERSION_1_1_1a);
        boolean version112 = version.equals(Version.VERSION_1_1_2);
        if (!(version111 || version111a || version112)) {
            throw new IOException("unknown version: " + version);
        }
        CPerspective perspective = this.createEmptyPerspective();
        PerspectiveElementFactory factory = new PerspectiveElementFactory(perspective);
        DockFrontendPerspective frontend = this.wrap(perspective, includeWorkingAreas, factory);
        PredefinedPerspective conversion = frontend.getPerspective();
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : this.control.getRegister().getFactories().entrySet()) {
            ((Perspective)conversion).getSituation().add(new CommonMultipleDockableFactory(entry.getKey(), entry.getValue(), this.control, perspective));
        }
        Map<String, DockLayoutComposition> stations = ((Perspective)conversion).getSituation().readCompositions(in);
        factory.setStations(stations);
        for (DockLayoutComposition composition : stations.values()) {
            CStationPerspective stationPerspective;
            PerspectiveElement station = conversion.convert(composition);
            if (!(station instanceof CommonElementPerspective) || (stationPerspective = ((CommonElementPerspective)station).getElement().asStation()) == null) continue;
            perspective.addStation(stationPerspective);
        }
        if (version111a || version112) {
            perspective.storeLocations();
            PropertyTransformer propertyTransformer = frontend.getPropertyTransformer();
            int n = in.readInt();
            for (int i = 0; i < n; ++i) {
                PerspectiveElement element;
                CDockablePerspective dockable;
                if (!in.readBoolean()) continue;
                String key = in.readUTF();
                DockLayoutComposition composition = null;
                if (in.readBoolean()) {
                    composition = ((Perspective)conversion).getSituation().readComposition(in);
                }
                if ((dockable = perspective.getDockable(key)) == null && composition != null && (element = conversion.convert(composition)) instanceof CommonElementPerspective && (dockable = ((CommonElementPerspective)element).getElement().asDockable()) != null) {
                    perspective.putDockable(dockable);
                }
                String locationRoot = in.readUTF();
                String modeId = in.readUTF();
                boolean applicationDefined = false;
                if (version112) {
                    applicationDefined = in.readBoolean();
                }
                DockableProperty location = propertyTransformer.read(in);
                if (dockable == null) continue;
                Path mode = new Path(modeId);
                ExtendedMode extendedMode = perspective.getLocationManager().getMode(mode);
                if (extendedMode == null) continue;
                dockable.getLocationHistory().add(extendedMode, new Location(mode, locationRoot, location, applicationDefined));
            }
        }
        LocationSettingConverter locationSettingConverter = new LocationSettingConverter(this.control.getOwner().getController());
        ModeSettings<Location, Location> modes = this.control.getOwner().getLocationManager().createModeSettings(locationSettingConverter);
        modes.read(in);
        perspective.getLocationManager().readModes(modes, perspective, this.control);
        return perspective;
    }

    public CPerspective read(CSetting setting, boolean includeWorkingAreas) {
        return this.convert(setting, includeWorkingAreas);
    }

    private CSetting convert(CPerspective perspective, boolean includeWorkingAreas) {
        perspective.storeLocations();
        DockFrontendPerspective frontend = this.conversion(perspective, includeWorkingAreas);
        PredefinedPerspective conversion = frontend.getPerspective();
        CSetting setting = new CSetting();
        for (String key : perspective.getStationKeys()) {
            CStationPerspective station = perspective.getStation(key);
            if (station.asDockable() != null && station.asDockable().getParent() != null) continue;
            setting.putRoot(key, conversion.convert(station.intern()));
        }
        for (String key : perspective.getDockableKeys()) {
            CDockablePerspective dockable = perspective.getDockable(key);
            Location location = this.getInvisibleLocation(dockable);
            if (location == null) continue;
            setting.addInvisible(key, location.getRoot(), null, location.getLocation());
        }
        ModeSettings<Location, Location> settings = perspective.getLocationManager().writeModes(this.control);
        setting.setModes(settings);
        return setting;
    }

    /*
     * WARNING - void declaration
     */
    private CPerspective convert(CSetting setting, boolean includeWorkingAreas) {
        void var8_12;
        CPerspective cperspective = this.createEmptyPerspective();
        PerspectiveElementFactory factory = new PerspectiveElementFactory(cperspective);
        DockFrontendPerspective frontend = this.wrap(cperspective, includeWorkingAreas, factory);
        PredefinedPerspective conversion = frontend.getPerspective();
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : this.control.getRegister().getFactories().entrySet()) {
            ((Perspective)conversion).getSituation().add(new CommonMultipleDockableFactory(entry.getKey(), entry.getValue(), this.control, cperspective));
        }
        HashMap<String, DockLayoutComposition> stations = new HashMap<String, DockLayoutComposition>();
        for (String root : setting.getRootKeys()) {
            stations.put(root, setting.getRoot(root));
        }
        factory.setStations(stations);
        for (DockLayoutComposition composition : stations.values()) {
            CStationPerspective stationPerspective;
            PerspectiveElement station = conversion.convert(composition);
            if (!(station instanceof CommonElementPerspective) || (stationPerspective = ((CommonElementPerspective)station).getElement().asStation()) == null) continue;
            cperspective.addStation(stationPerspective);
        }
        boolean bl = false;
        int n = setting.getInvisibleCount();
        while (var8_12 < n) {
            CDockablePerspective dockable;
            PerspectiveElement element;
            DockLayoutComposition composition = setting.getInvisibleLayout((int)var8_12);
            if (composition != null && (element = conversion.convert(composition)) instanceof CommonElementPerspective && (dockable = ((CommonElementPerspective)element).getElement().asDockable()) != null) {
                DockableProperty location = setting.getInvisibleLocation((int)var8_12);
                String root = setting.getInvisibleRoot((int)var8_12);
                ExtendedMode mode = cperspective.getLocationManager().getMode(root, location);
                if (mode != null) {
                    dockable.getLocationHistory().add(mode, new Location(mode.getModeIdentifier(), root, location, false));
                }
                cperspective.putDockable(dockable);
            }
            ++var8_12;
        }
        ModeSettings<Location, Location> modeSettings = setting.getModes();
        cperspective.getLocationManager().readModes(modeSettings, cperspective, this.control);
        return cperspective;
    }

    private Location getInvisibleLocation(CDockablePerspective dockable) {
        LocationHistory history = dockable.getLocationHistory();
        List<Path> order = history.getOrder();
        if (!order.isEmpty()) {
            Path mode = order.get(order.size() - 1);
            Location location = history.getLocations().get(mode);
            return location;
        }
        return null;
    }

    public DockFrontendPerspective conversion(CPerspective perspective, boolean includeWorkingAreas) {
        DockFrontendPerspective conversion = this.wrap(perspective, includeWorkingAreas);
        PredefinedDockSituation situation = conversion.getPerspective().getSituation();
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> item : this.control.getRegister().getFactories().entrySet()) {
            situation.add(new CommonMultipleDockableFactory(item.getKey(), item.getValue(), this.control, perspective));
        }
        return conversion;
    }

    private DockFrontendPerspective wrap(CPerspective perspective, boolean includeWorkingAreas) {
        PerspectiveElementFactory factory = new PerspectiveElementFactory(perspective);
        return this.wrap(perspective, includeWorkingAreas, factory);
    }

    private DockFrontendPerspective wrap(CPerspective perspective, boolean includeWorkingAreas, PerspectiveElementFactory factory) {
        DockFrontendPerspective frontend = this.control.getOwner().intern().getPerspective(!includeWorkingAreas, factory);
        PredefinedPerspective inner = frontend.getPerspective();
        factory.setBasePerspective(inner);
        CommonSingleDockableFactory singleDockableFactory = new CommonSingleDockableFactory(this.control.getOwner(), perspective);
        inner.getSituation().add(singleDockableFactory);
        inner.getSituation().addBackup(new RegisteringDockFactory<CommonDockable, CommonElementPerspective, CommonSingleDockableLayout>(this.control.getOwner().intern(), singleDockableFactory));
        inner.getSituation().add(new CommonDockStationFactory(this.control.getOwner(), factory, singleDockableFactory));
        return frontend;
    }

    private class PerspectiveElementFactory
    implements FrontendPerspectiveCache {
        private CPerspective perspective;
        private Perspective basePerspective;
        private Map<String, SingleCDockablePerspective> dockables = new HashMap<String, SingleCDockablePerspective>();
        private Map<String, DockLayoutComposition> stations;

        public PerspectiveElementFactory(CPerspective perspective) {
            this.perspective = perspective;
            Iterator<PerspectiveElement> elements = perspective.elements();
            while (elements.hasNext()) {
                PerspectiveElement element = elements.next();
                if (!(element instanceof SingleCDockablePerspective)) continue;
                SingleCDockablePerspective dockable = (SingleCDockablePerspective)((Object)element);
                this.dockables.put(dockable.getUniqueId(), dockable);
            }
        }

        public void setStations(Map<String, DockLayoutComposition> stations) {
            this.stations = stations;
        }

        public void setBasePerspective(Perspective basePerspective) {
            this.basePerspective = basePerspective;
        }

        @Override
        public PerspectiveElement get(String id, DockElement element, boolean isRootStation) {
            if (isRootStation) {
                return this.perspective.getStation(id).intern();
            }
            if (element instanceof CommonDockable) {
                CDockable dockable = ((CommonDockable)element).getDockable();
                if (dockable.asStation() != null) {
                    CStationPerspective station = this.perspective.getStation(dockable.asStation().getUniqueId());
                    if (station == null) {
                        throw new IllegalArgumentException("Found a non-root CStation that is not registered: " + dockable.asStation().getUniqueId());
                    }
                    return station.intern();
                }
                if (dockable instanceof SingleCDockable) {
                    String key = ((SingleCDockable)dockable).getUniqueId();
                    SingleCDockablePerspective result = this.dockables.get(key);
                    if (result == null) {
                        result = new SingleCDockablePerspective(key);
                        this.dockables.put(key, result);
                    }
                    return result.intern();
                }
                if (dockable instanceof MultipleCDockable) {
                    return null;
                }
            }
            throw new IllegalArgumentException("The intern DockFrontend of the CControl has elements registered that are not SingleCDockables: " + id + "=" + element);
        }

        @Override
        public PerspectiveElement get(String id, boolean rootStation) {
            String key = id;
            if (!rootStation && CControlPerspective.this.control.getRegister().isSingleId(id)) {
                key = CControlPerspective.this.control.getRegister().singleToNormalId(id);
            }
            DockLayoutComposition root = null;
            if (this.stations != null) {
                root = this.stations.get(key);
            }
            if (root == null) {
                root = this.getPredefinedStation(key, this.basePerspective.getSituation());
            }
            Path stationType = null;
            if (root != null) {
                CStationPerspective station;
                DockLayout<?> layout = root.getAdjacent("dock.RootStationAdjacentFactory");
                if (layout != null) {
                    stationType = (Path)layout.getData();
                }
                if ((station = this.perspective.getStation(key)) == null && (station = CControlPerspective.this.control.getOwner().getMissingPerspectiveStrategy().createStation(key, stationType)) != null) {
                    this.perspective.addStation(station);
                    station.setRoot(rootStation);
                }
                if (station == null) {
                    return null;
                }
                return station.intern();
            }
            if (CControlPerspective.this.control.getRegister().isSingleId(id)) {
                SingleCDockablePerspective result = this.dockables.get(key);
                if (result == null) {
                    result = new SingleCDockablePerspective(key);
                    this.dockables.put(key, result);
                }
                return result.intern();
            }
            return null;
        }

        protected DockLayoutComposition getPredefinedStation(String id, DockSituation situation) {
            if (this.stations != null) {
                for (DockLayoutComposition station : this.stations.values()) {
                    DockLayoutComposition result = this.getPredefinedStation(id, station, situation);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }

        private DockLayoutComposition getPredefinedStation(String id, DockLayoutComposition current, DockSituation situation) {
            List<DockLayoutComposition> children;
            String currentId = situation.getIdentifier(current);
            if (currentId != null) {
                if (id.length() == "root".length() + id.length() && currentId.startsWith("root") && currentId.endsWith(id)) {
                    return current;
                }
                if (currentId.startsWith("dockable")) {
                    currentId = currentId.substring("dockable".length());
                    if (CControlPerspective.this.control.getRegister().isSingleId(currentId)) {
                        currentId = CControlPerspective.this.control.getRegister().singleToNormalId(currentId);
                    } else if (CControlPerspective.this.control.getRegister().isMultiId(currentId)) {
                        currentId = CControlPerspective.this.control.getRegister().multiToNormalId(currentId);
                    }
                    if (currentId.equals(id)) {
                        return current;
                    }
                }
            }
            if ((children = current.getChildren()) != null) {
                for (DockLayoutComposition child : children) {
                    DockLayoutComposition result = this.getPredefinedStation(id, child, situation);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }

        @Override
        public String get(PerspectiveElement element) {
            CElementPerspective celement;
            for (String key : this.perspective.getStationKeys()) {
                CStationPerspective station = this.perspective.getStation(key);
                if (station.intern() != element) continue;
                return key;
            }
            if (element instanceof CommonElementPerspective && (celement = ((CommonElementPerspective)element).getElement()) instanceof SingleCDockablePerspective) {
                return CControlPerspective.this.control.getRegister().toSingleId(((SingleCDockablePerspective)celement).getUniqueId());
            }
            return null;
        }

        @Override
        public boolean isRootStation(PerspectiveStation element) {
            for (String key : this.perspective.getStationKeys()) {
                CStationPerspective station = this.perspective.getStation(key);
                if (station.intern() != element) continue;
                return true;
            }
            return false;
        }
    }
}

