/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.common.CMinimizeArea;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonDockStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.mode.CMinimizedModePerspective;
import bibliothek.gui.dock.common.perspective.mode.CModeAreaPerspective;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.flap.FlapDockPerspective;
import bibliothek.gui.dock.station.flap.FlapDockProperty;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.util.Path;

public class CMinimizePerspective
implements CStationPerspective {
    private CommonFlapDockPerspective delegate;
    private String id;
    private CPerspective perspective;
    private Path typeId;
    private boolean root = true;
    private CModeAreaPerspective mode = new CModeAreaPerspective(){

        @Override
        public String getUniqueId() {
            return CMinimizePerspective.this.getUniqueId();
        }

        @Override
        public boolean isChild(PerspectiveDockable dockable) {
            return dockable.getParent() == CMinimizePerspective.this.intern();
        }

        @Override
        public boolean isChildLocation(DockableProperty location) {
            return location instanceof FlapDockProperty;
        }
    };

    public CMinimizePerspective(String id) {
        this(id, null);
    }

    public CMinimizePerspective(String id, Path typeId) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.id = id;
        if (typeId == null) {
            typeId = CMinimizeArea.TYPE_ID;
        }
        this.typeId = typeId;
        this.delegate = new CommonFlapDockPerspective();
    }

    @Override
    public void setPerspective(CPerspective perspective) {
        CMinimizedModePerspective mode;
        if (this.perspective != null) {
            mode = (CMinimizedModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.MINIMIZED);
            mode.remove(this.mode);
        }
        this.perspective = perspective;
        if (this.perspective != null) {
            mode = (CMinimizedModePerspective)this.perspective.getLocationManager().getMode(ExtendedMode.MINIMIZED);
            mode.add(this.mode);
        }
    }

    @Override
    public CPerspective getPerspective() {
        return this.perspective;
    }

    @Override
    public Path getTypeId() {
        return this.typeId;
    }

    @Override
    public boolean isRoot() {
        return this.root;
    }

    @Override
    public void setRoot(boolean root) {
        this.root = root;
    }

    public void add(CDockablePerspective dockable) {
        this.delegate.add(dockable.intern().asDockable());
    }

    public void insert(int index, CDockablePerspective dockable) {
        this.delegate.insert(index, dockable.intern().asDockable());
    }

    public void addPlaceholder(CDockablePerspective dockable) {
        this.delegate.addPlaceholder(dockable.intern().asDockable());
    }

    public void addPlaceholder(Path placeholder) {
        this.delegate.addPlaceholder(placeholder);
    }

    public void insertPlaceholder(int index, CDockablePerspective dockable) {
        this.delegate.insertPlaceholder(index, dockable.intern().asDockable());
    }

    public void insertPlaceholder(int index, Path placeholder) {
        this.delegate.insertPlaceholder(index, placeholder);
    }

    public int indexOf(CDockablePerspective dockable) {
        return this.delegate.indexOf(dockable.intern().asDockable());
    }

    public boolean remove(CDockablePerspective dockable) {
        return this.delegate.remove(dockable.intern().asDockable());
    }

    public CDockablePerspective remove(int index) {
        PerspectiveDockable dockable = this.delegate.remove(index);
        if (dockable instanceof CommonElementPerspective) {
            return ((CommonElementPerspective)((Object)dockable)).getElement().asDockable();
        }
        return null;
    }

    @Override
    public CDockablePerspective asDockable() {
        return null;
    }

    @Override
    public CStationPerspective asStation() {
        return this;
    }

    public String getFactoryID() {
        return this.delegate.getFactoryID();
    }

    @Override
    public String getUniqueId() {
        return this.id;
    }

    @Override
    public CommonFlapDockPerspective intern() {
        return this.delegate;
    }

    public PlaceholderMap getPlaceholders() {
        return this.delegate.getPlaceholders();
    }

    public void setPlaceholders(PlaceholderMap placeholders) {
        this.delegate.setPlaceholders(placeholders);
    }

    @Override
    public boolean isWorkingArea() {
        return false;
    }

    public class CommonFlapDockPerspective
    extends FlapDockPerspective
    implements CommonDockStationPerspective {
        @Override
        public CElementPerspective getElement() {
            return CMinimizePerspective.this;
        }

        @Override
        public String getFactoryID() {
            return "CommonDockStationFactory";
        }

        @Override
        public String getConverterID() {
            return super.getFactoryID();
        }
    }
}

