/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.intern.action.panel.BasicPanelPopupGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelDropDownGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelMenuGenerator;
import bibliothek.gui.dock.common.intern.color.BasicButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.BasicTabTransmitter;
import bibliothek.gui.dock.common.intern.color.BasicTitleTransmitter;
import bibliothek.gui.dock.common.theme.CDockTheme;
import bibliothek.gui.dock.themes.BasicTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;

public class CBasicTheme
extends CDockTheme<BasicTheme> {
    public CBasicTheme(CControl control, BasicTheme theme) {
        super(theme);
        this.init(control);
    }

    public CBasicTheme(CControl control) {
        this(new BasicTheme());
        this.init(control);
    }

    private CBasicTheme(BasicTheme theme) {
        super(theme, new NoStackTheme(theme));
    }

    private void init(final CControl control) {
        this.initDefaultFontBridges(control);
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            @Override
            public ColorBridge create(ColorManager manager) {
                BasicTabTransmitter transmitter = new BasicTabTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_TITLE_COLOR, new ColorBridgeFactory(){

            @Override
            public ColorBridge create(ColorManager manager) {
                BasicTitleTransmitter transmitter = new BasicTitleTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            @Override
            public ColorBridge create(ColorManager manager) {
                BasicButtonTitleTransmitter transmitter = new BasicButtonTitleTransmitter(manager);
                transmitter.setControl(control);
                return transmitter;
            }
        });
    }

    @Override
    public void install(DockController controller) {
        super.install(controller);
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, new BasicPanelPopupGenerator());
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, new PanelMenuGenerator());
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, new PanelDropDownGenerator());
    }

    @Override
    public void uninstall(DockController controller) {
        ActionViewConverter converter = controller.getActionViewConverter();
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, null);
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, null);
        converter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, null);
        super.uninstall(controller);
    }
}

