/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.event.DockActionSourceListener;
import java.util.Iterator;

public class KeyedActionSource
extends AbstractDockActionSource {
    private CDockable dockable;
    private String key;
    private DockAction defaultAction;
    private LocationHint hint = LocationHint.UNKNOWN;
    private boolean visible = true;
    private boolean propertyListenerInstalled = false;
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        @Override
        public void actionChanged(CDockable dockable, String key, CAction oldAction, CAction newAction) {
            if (KeyedActionSource.this.visible) {
                boolean showing;
                boolean shown = oldAction != null || KeyedActionSource.this.defaultAction != null;
                boolean bl = showing = newAction != null || KeyedActionSource.this.defaultAction != null;
                if (shown && !showing) {
                    KeyedActionSource.this.fireRemoved(0, 0);
                } else if (!shown && showing) {
                    KeyedActionSource.this.fireAdded(0, 0);
                } else if (shown && showing) {
                    KeyedActionSource.this.visible = false;
                    KeyedActionSource.this.fireRemoved(0, 0);
                    KeyedActionSource.this.visible = true;
                    KeyedActionSource.this.fireAdded(0, 0);
                }
            }
        }
    };

    public KeyedActionSource(CDockable dockable, String key) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        this.dockable = dockable;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public void addDockActionSourceListener(DockActionSourceListener listener) {
        super.addDockActionSourceListener(listener);
        if (this.visible && !this.propertyListenerInstalled && !this.listeners.isEmpty()) {
            this.dockable.addCDockablePropertyListener(this.propertyListener);
            this.propertyListenerInstalled = true;
        }
    }

    @Override
    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        super.removeDockActionSourceListener(listener);
        if (this.visible && this.propertyListenerInstalled && this.listeners.isEmpty()) {
            this.dockable.removeCDockablePropertyListener(this.propertyListener);
            this.propertyListenerInstalled = false;
        }
    }

    public void destroy() {
        if (this.propertyListenerInstalled) {
            this.dockable.removeCDockablePropertyListener(this.propertyListener);
            this.propertyListenerInstalled = false;
        }
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            int updated;
            int current = this.getDockActionCount();
            this.visible = visible;
            if (visible) {
                if (!this.propertyListenerInstalled && !this.listeners.isEmpty()) {
                    this.dockable.addCDockablePropertyListener(this.propertyListener);
                    this.propertyListenerInstalled = true;
                }
            } else if (this.propertyListenerInstalled) {
                this.dockable.removeCDockablePropertyListener(this.propertyListener);
                this.propertyListenerInstalled = false;
            }
            if (current < (updated = this.getDockActionCount())) {
                this.fireAdded(0, 0);
            } else if (current > updated) {
                this.fireRemoved(0, 0);
            }
        }
    }

    public void setDefaultAction(DockAction defaultAction) {
        if (this.visible) {
            if (this.dockable.getAction(this.key) == null) {
                this.visible = false;
                this.fireRemoved(0, 0);
                this.defaultAction = defaultAction;
                this.visible = true;
                this.fireAdded(1, 1);
            } else {
                this.defaultAction = defaultAction;
            }
        } else {
            this.defaultAction = defaultAction;
        }
    }

    public DockAction getDefaultAction() {
        return this.defaultAction;
    }

    private DockAction currentAction() {
        if (!this.visible) {
            return null;
        }
        CAction result = this.dockable.getAction(this.key);
        if (result == null) {
            return this.defaultAction;
        }
        return result.intern();
    }

    @Override
    public DockAction getDockAction(int index) {
        if (index != 0) {
            throw new IllegalArgumentException("only index=0 supported");
        }
        return this.currentAction();
    }

    @Override
    public int getDockActionCount() {
        if (this.currentAction() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public LocationHint getLocationHint() {
        return this.hint;
    }

    @Override
    public Iterator<DockAction> iterator() {
        return new Iterator<DockAction>(){
            private DockAction action;
            {
                this.action = KeyedActionSource.this.currentAction();
            }

            @Override
            public boolean hasNext() {
                return this.action != null;
            }

            @Override
            public DockAction next() {
                if (this.action == null) {
                    throw new IllegalStateException("no elements left");
                }
                DockAction result = this.action;
                this.action = null;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

