/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.mode.ModeSettingsConverter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class MaximizedModeSetting
implements ModeSetting<Location> {
    public static ModeSettingFactory<Location> FACTORY = new ModeSettingFactory<Location>(){

        @Override
        public ModeSetting<Location> create() {
            return new MaximizedModeSetting();
        }

        @Override
        public Path getModeId() {
            return MaximizedMode.IDENTIFIER;
        }
    };
    private HashMap<String, Path> lastMaximizedMode = new HashMap();
    private HashMap<String, Location> lastMaximizedLocation = new HashMap();

    @Override
    public Path getModeId() {
        return MaximizedMode.IDENTIFIER;
    }

    public void setLastMaximizedLocation(Map<String, Location> lastMaximizedLocation) {
        this.lastMaximizedLocation = new HashMap<String, Location>(lastMaximizedLocation);
    }

    public void setLastMaximizedMode(Map<String, Path> lastMaximizedMode) {
        this.lastMaximizedMode = new HashMap<String, Path>(lastMaximizedMode);
    }

    public Map<String, Location> getLastMaximizedLocation() {
        return Collections.unmodifiableMap(this.lastMaximizedLocation);
    }

    public Map<String, Path> getLastMaximizedMode() {
        return Collections.unmodifiableMap(this.lastMaximizedMode);
    }

    @Override
    public <B> void write(DataOutputStream out, ModeSettingsConverter<Location, B> converter) throws IOException {
        int count;
        Version.write(out, Version.VERSION_1_0_8);
        if (this.lastMaximizedMode == null) {
            out.writeInt(0);
        } else {
            count = 0;
            for (Path path : this.lastMaximizedMode.values()) {
                if (path == null) continue;
                ++count;
            }
            out.writeInt(count);
            for (Map.Entry entry : this.lastMaximizedMode.entrySet()) {
                if (entry.getValue() == null) continue;
                out.writeUTF((String)entry.getKey());
                out.writeUTF(((Path)entry.getValue()).toString());
            }
        }
        if (this.lastMaximizedLocation == null) {
            out.writeInt(0);
        } else {
            count = 0;
            for (Location location : this.lastMaximizedLocation.values()) {
                if (location == null) continue;
                ++count;
            }
            out.writeInt(count);
            for (Map.Entry entry : this.lastMaximizedLocation.entrySet()) {
                if (entry.getValue() == null) continue;
                out.writeUTF((String)entry.getKey());
                converter.writeProperty(converter.convertToSetting((Location)entry.getValue()), out);
            }
        }
    }

    @Override
    public <B> void read(DataInputStream in, ModeSettingsConverter<Location, B> converter) throws IOException {
        String key;
        int i;
        Version version = Version.read(in);
        version.checkCurrent();
        this.lastMaximizedLocation = new HashMap();
        this.lastMaximizedMode = new HashMap();
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            key = in.readUTF();
            String value = in.readUTF();
            this.lastMaximizedMode.put(key, new Path(value));
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            key = in.readUTF();
            Location location = converter.convertToWorld(converter.readProperty(in));
            this.lastMaximizedLocation.put(key, location);
        }
    }

    @Override
    public <B> void write(XElement element, ModeSettingsConverter<Location, B> converter) {
        HashSet<String> keys = new HashSet<String>();
        if (this.lastMaximizedLocation != null) {
            keys.addAll(this.lastMaximizedLocation.keySet());
        }
        if (this.lastMaximizedMode != null) {
            keys.addAll(this.lastMaximizedMode.keySet());
        }
        if (!keys.isEmpty()) {
            XElement xmaximized = element.addElement("maximized");
            for (String key : keys) {
                Path mode = this.lastMaximizedMode.get(key);
                Location location = this.lastMaximizedLocation.get(key);
                if (mode == null && location == null) continue;
                XElement xitem = xmaximized.addElement("item");
                xitem.addString("id", key);
                if (mode != null) {
                    xitem.addElement("mode").setString(mode.toString());
                }
                if (location == null) continue;
                converter.writePropertyXML(converter.convertToSetting(location), xitem.addElement("location"));
            }
        }
    }

    @Override
    public <B> void read(XElement element, ModeSettingsConverter<Location, B> converter) {
        this.lastMaximizedLocation = new HashMap();
        this.lastMaximizedMode = new HashMap();
        XElement xmaximized = element.getElement("maximized");
        if (xmaximized != null) {
            for (XElement xitem : xmaximized.getElements("item")) {
                XElement xlocation;
                String key = xitem.getString("id");
                XElement xmode = xitem.getElement("mode");
                if (xmode != null) {
                    this.lastMaximizedMode.put(key, new Path(xmode.getString()));
                }
                if ((xlocation = xitem.getElement("location")) == null) continue;
                this.lastMaximizedLocation.put(key, converter.convertToWorld(converter.readPropertyXML(xlocation)));
            }
        }
    }
}

