/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.lookandfeel;

import bibliothek.gui.dock.support.lookandfeel.ComponentCollector;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelListener;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelUtilities;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class LookAndFeelList {
    private static LookAndFeelList list;
    private Wrapper defaultInfo;
    private Wrapper systemInfo;
    private Info currentInfo;
    private List<Info> infos = new ArrayList<Info>();
    private List<LookAndFeelListener> listeners = new ArrayList<LookAndFeelListener>();
    private List<ComponentCollector> componentCollectors = new ArrayList<ComponentCollector>();
    private boolean allowReadOnlyOnce = false;
    private boolean hasRead = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LookAndFeelList getDefaultList() {
        if (list != null) return list;
        Class<LookAndFeelList> clazz = LookAndFeelList.class;
        synchronized (LookAndFeelList.class) {
            if (list != null) return list;
            list = new LookAndFeelList();
            // ** MonitorExit[var0] (shouldn't be in output)
            return list;
        }
    }

    public static void setDefaultList(LookAndFeelList list) {
        LookAndFeelList.list = list;
    }

    protected LookAndFeelList() {
        LookAndFeel feel = UIManager.getLookAndFeel();
        this.setDefault(new Info(feel.getClass().getName(), feel.getName()));
        this.currentInfo = this.defaultInfo;
        this.setSystem(new Info(UIManager.getSystemLookAndFeelClassName(), "System"));
        UIManager.LookAndFeelInfo[] preset = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < preset.length; ++i) {
            this.add(new Info(preset[i].getClassName(), preset[i].getName()));
        }
        this.add(new Info(MetalLookAndFeel.class.getName(), "Retro"){
            private MetalTheme oldTheme;

            @Override
            protected void setup() {
                this.oldTheme = MetalLookAndFeel.getCurrentTheme();
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }

            @Override
            protected void kill() {
                MetalLookAndFeel.setCurrentTheme(this.oldTheme);
            }
        });
    }

    public boolean isAllowReadOnlyOnce() {
        return this.allowReadOnlyOnce;
    }

    public void setAllowReadOnlyOnce(boolean allowReadOnlyOnce) {
        this.allowReadOnlyOnce = allowReadOnlyOnce;
    }

    public void setReadOnce(boolean read) {
        this.hasRead = read;
    }

    public void addLookAndFeelListener(LookAndFeelListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeLookAndFeelListener(LookAndFeelListener listener) {
        this.listeners.remove(listener);
    }

    protected LookAndFeelListener[] listeners() {
        return this.listeners.toArray(new LookAndFeelListener[this.listeners.size()]);
    }

    public void addComponentCollector(ComponentCollector c) {
        this.componentCollectors.add(c);
    }

    public void removeComponentCollector(ComponentCollector c) {
        this.componentCollectors.remove(c);
    }

    public void add(Info info) {
        this.insert(this.infos.size(), info);
    }

    public void insert(int index, Info info) {
        if (info == null) {
            throw new NullPointerException("Info must not be null");
        }
        this.infos.add(index, info);
        for (LookAndFeelListener listener : this.listeners()) {
            listener.lookAndFeelAdded(this, info);
        }
    }

    public int size() {
        return this.infos.size();
    }

    public Info get(int index) {
        return this.infos.get(index);
    }

    public int indexOf(Info info) {
        return this.infos.indexOf(info);
    }

    public Info getFull(int index) {
        if (index == 0) {
            return this.getDefault();
        }
        if (index == 1) {
            return this.getSystem();
        }
        return this.get(index - 2);
    }

    public int indexOfFull(Info info) {
        if (info == this.defaultInfo) {
            return 0;
        }
        if (info == this.systemInfo) {
            return 1;
        }
        int index = this.indexOf(info);
        if (index < 0) {
            return -1;
        }
        return index + 2;
    }

    public Info getFull(String key) {
        if ("s.default".equals(key)) {
            return this.getDefault();
        }
        if ("s.system".equals(key)) {
            return this.getSystem();
        }
        for (Info info : this.infos) {
            if (!key.equals(this.keyOfFullNormal(info))) continue;
            return info;
        }
        return null;
    }

    public String keyOfFull(Info info) {
        if (info == this.defaultInfo) {
            return "s.default";
        }
        if (info == this.systemInfo) {
            return "s.system";
        }
        return this.keyOfFullNormal(info);
    }

    private String keyOfFullNormal(Info info) {
        return "l." + info.getName().length() + "." + info.getName() + "." + info.className;
    }

    public void remove(Info info) {
        int index = this.indexOf(info);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        Info info = this.infos.remove(index);
        for (LookAndFeelListener listener : this.listeners()) {
            listener.lookAndFeelRemoved(this, info);
        }
    }

    public Info getLookAndFeel() {
        return this.currentInfo;
    }

    public void setLookAndFeel(Info lookAndFeel) {
        if (lookAndFeel == this.currentInfo) {
            return;
        }
        if (lookAndFeel == null) {
            throw new NullPointerException("lookAndFeel must not be null");
        }
        try {
            this.currentInfo.kill();
            this.currentInfo = lookAndFeel;
            lookAndFeel.setup();
            UIManager.setLookAndFeel(lookAndFeel.getClassName());
            LookAndFeelUtilities.updateUI(this.listComponents());
            for (LookAndFeelListener listener : this.listeners()) {
                listener.lookAndFeelChanged(this, lookAndFeel);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    public Info getDefault() {
        return this.defaultInfo;
    }

    public void setDefault(Info defaultInfo) {
        if (defaultInfo == null) {
            throw new NullPointerException("argument must not be null");
        }
        this.defaultInfo = new Wrapper(defaultInfo);
        for (LookAndFeelListener listener : this.listeners()) {
            listener.defaultLookAndFeelChanged(this, this.defaultInfo);
        }
    }

    public Info getSystem() {
        return this.systemInfo;
    }

    public void setSystem(Info systemInfo) {
        if (systemInfo == null) {
            throw new NullPointerException("argument must not be null");
        }
        this.systemInfo = new Wrapper(systemInfo);
        for (LookAndFeelListener listener : this.listeners()) {
            listener.systemLookAndFeelChanged(this, this.systemInfo);
        }
    }

    public void write(DataOutputStream out) throws IOException {
        Version.write(out, Version.VERSION_1_1_1);
        out.writeUTF(this.keyOfFull(this.getLookAndFeel()));
    }

    public void read(DataInputStream in) throws IOException {
        Version version = Version.read(in);
        version.checkCurrent();
        if (version.equals(Version.VERSION_1_0_4)) {
            int index = in.readInt();
            if (!(this.hasRead && this.allowReadOnlyOnce || index < 0 || index >= this.size() + 2)) {
                this.setLookAndFeel(this.getFull(index));
            }
            this.hasRead = true;
        } else {
            String key = in.readUTF();
            if (!this.hasRead || !this.allowReadOnlyOnce) {
                Info laf = this.getFull(key);
                if (laf == null) {
                    laf = this.getDefault();
                }
                if (laf != null) {
                    this.setLookAndFeel(laf);
                }
            }
            this.hasRead = true;
        }
    }

    public void writeXML(XElement element) {
        element.addElement("key").setString(this.keyOfFull(this.getLookAndFeel()));
    }

    public void readXML(XElement element) {
        if (!this.hasRead || !this.allowReadOnlyOnce) {
            XElement xkey = element.getElement("key");
            Info info = null;
            if (xkey == null) {
                XElement xindex = element.getElement("index");
                int index = xindex.getInt();
                if (index >= 0 && index < this.size() + 2) {
                    info = this.getFull(index);
                }
                info = this.getFull(xindex.getInt());
            } else {
                info = this.getFull(xkey.getString());
            }
            if (info == null) {
                info = this.getDefault();
            }
            if (info != null) {
                this.setLookAndFeel(info);
            }
        }
        this.hasRead = true;
    }

    protected Collection<Component> listComponents() {
        ArrayList<Component> list = new ArrayList<Component>();
        for (ComponentCollector c : this.componentCollectors) {
            list.addAll(c.listComponents());
        }
        return list;
    }

    public static class Info {
        private String className;
        private String name;

        public Info(String className, String name) {
            this.className = className;
            this.name = name;
        }

        public String getClassName() {
            return this.className;
        }

        public String getName() {
            return this.name;
        }

        protected void setup() {
        }

        protected void kill() {
        }
    }

    private class Wrapper
    extends Info {
        private Info info;

        public Wrapper(Info info) {
            super(info.getClassName(), info.getName());
            this.info = info;
        }

        @Override
        protected void setup() {
            this.info.setup();
        }

        @Override
        protected void kill() {
            this.info.kill();
        }
    }
}

