/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.util.CDockUtilities;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.support.mode.HistoryRewriter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CStationContainerHistoryRewriter
implements HistoryRewriter<Location, CLocationMode> {
    private CControl control;

    public CStationContainerHistoryRewriter(CControl control) {
        this.control = control;
    }

    public CControl getControl() {
        return this.control;
    }

    protected CStation<?> getMatchingStation(Dockable dockable, String root) {
        CStation<?> rootStation = this.control.getStation(root);
        if (rootStation == null) {
            return null;
        }
        CStationContainer rootContainer = this.getContainer(rootStation);
        if (rootContainer == null) {
            return rootStation;
        }
        CStation<?> station = this.getParent(dockable);
        CStationContainer container = this.getContainer(station);
        if (container != null) {
            if (rootContainer == container) {
                return rootStation;
            }
            return container.getMatchingStation(rootContainer, rootStation);
        }
        List history = this.control.getLocationManager().getPropertyHistory(dockable);
        for (int i = history.size() - 1; i >= 0; --i) {
            CStation<?> result;
            String historyRoot = ((Location)history.get(i)).getRoot();
            CStation<?> historyStation = this.control.getStation(historyRoot);
            if (historyStation == null || (container = this.getContainer(historyStation)) == null || (result = container.getMatchingStation(rootContainer, rootStation)) == null) continue;
            return result;
        }
        return null;
    }

    protected CStation<?> getMatchingStation(Dockable dockable, ExtendedMode mode) {
        CStation<?> station = this.getParent(dockable);
        CStation<?> workingArea = this.getWorkingArea(dockable);
        if (station != null && workingArea != null && !this.isValidParent(station, workingArea)) {
            return workingArea;
        }
        CStationContainer container = this.getContainer(station);
        if (container != null) {
            return container.getDefaultStation(mode);
        }
        List history = this.control.getLocationManager().getPropertyHistory(dockable);
        for (int i = history.size() - 1; i >= 0; --i) {
            CStation<?> result;
            String historyRoot = ((Location)history.get(i)).getRoot();
            CStation<?> rootStation = this.control.getStation(historyRoot);
            if (rootStation == null || (container = this.getContainer(rootStation)) == null || (result = container.getDefaultStation(mode)) == null || !this.isValidParent(result, workingArea)) continue;
            return result;
        }
        return null;
    }

    private boolean isValidParent(CStation<?> parent, CStation<?> workingArea) {
        return parent != null && CDockUtilities.getFirstWorkingArea(parent) == workingArea;
    }

    protected CStation<?> getWorkingArea(Dockable dockable) {
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable().getWorkingArea();
        }
        return null;
    }

    protected CStation<?> getParent(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            if (dockStation instanceof CommonDockStation) {
                return ((CommonDockStation)dockStation).getStation();
            }
            if (dockStation.asDockable() == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockStation.asDockable().getDockParent();
        }
        return null;
    }

    protected CStationContainer getContainer(CStation<?> child) {
        if (child == null) {
            return null;
        }
        Object station = child.getStation();
        while (station != null) {
            Dockable dockable;
            if (station instanceof CommonDockStation) {
                CStation next = ((CommonDockStation)station).getStation();
                CStationContainer container = this.control.getRegister().getContainer(next);
                if (container != null) {
                    return container;
                }
            }
            if ((dockable = station.asDockable()) == null) {
                return null;
            }
            station = dockable.getDockParent();
            if (station != null) continue;
            return null;
        }
        return null;
    }

    @Override
    public Location rewrite(Dockable dockable, CLocationMode mode, Location history) {
        CStation<?> replacement = null;
        if (history != null) {
            replacement = this.getMatchingStation(dockable, history.getRoot());
        }
        if (replacement == null) {
            replacement = this.getMatchingStation(dockable, mode.getExtendedMode());
        }
        if (replacement == null) {
            return history;
        }
        if (history == null) {
            return new Location(mode.getUniqueIdentifier(), replacement.getUniqueId(), null, false);
        }
        return new Location(mode.getUniqueIdentifier(), replacement.getUniqueId(), history.getLocation(), history.isApplicationDefined());
    }
}

