/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.station.CScreenDockStation;
import bibliothek.gui.dock.common.location.CExternalizedLocation;
import bibliothek.gui.dock.common.location.CMaximalExternalizedLocation;
import bibliothek.gui.dock.common.mode.CExternalizedModeArea;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CModeArea;
import bibliothek.gui.dock.facile.mode.ExternalizedMode;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.screen.ScreenDockStationListener;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CScreenDockStationHandle {
    private CStation<CScreenDockStation> station;
    private External external = new External();
    private Maximal maximal = new Maximal();
    private LocationMode externalMode;
    private CMaximizedMode maximizedMode;
    private CLocationModeManager manager;

    public CScreenDockStationHandle(CStation<CScreenDockStation> station, CLocationModeManager manager) {
        this.station = station;
        this.manager = manager;
        station.getStation().addScreenDockStationListener(new ScreenDockStationListener(){

            public void windowRegistering(ScreenDockStation station, Dockable dockable, ScreenDockWindow window) {
            }

            public void windowDeregistering(ScreenDockStation station, Dockable dockable, ScreenDockWindow window) {
            }

            public void fullscreenChanged(ScreenDockStation station, Dockable dockable) {
                ModeAreaListener[] listeners;
                CModeArea source;
                if (station.isFullscreen(dockable)) {
                    source = CScreenDockStationHandle.this.maximal;
                    listeners = CScreenDockStationHandle.this.maximal.listeners();
                } else {
                    source = CScreenDockStationHandle.this.external;
                    listeners = CScreenDockStationHandle.this.external.listeners();
                }
                HashSet<Dockable> dockables = new HashSet<Dockable>();
                dockables.add(dockable);
                for (ModeAreaListener listener : listeners) {
                    listener.internalLocationChange(source, dockables);
                }
            }
        });
    }

    public CExternalizedModeArea getExternalizedModeArea() {
        return this.external;
    }

    public CMaximizedModeArea getMaximizedModeArea() {
        return this.maximal;
    }

    public CLocation getCLocation(Dockable dockable) {
        DockableProperty property = DockUtilities.getPropertyChain(this.station.getStation(), dockable);
        return this.expand(property);
    }

    public CLocation getCLocation(Dockable dockable, Location location) {
        DockableProperty property = location.getLocation();
        if (property == null) {
            return null;
        }
        return this.expand(property);
    }

    private CLocation expand(DockableProperty property) {
        if (property instanceof ScreenDockProperty) {
            ScreenDockProperty screen = (ScreenDockProperty)property;
            CExternalizedLocation result = screen.isFullscreen() ? new CMaximalExternalizedLocation(screen.getX(), screen.getY(), screen.getWidth(), screen.getHeight()) : new CExternalizedLocation(screen.getX(), screen.getY(), screen.getWidth(), screen.getHeight());
            if (property.getSuccessor() != null) {
                return result.expandProperty(this.station.getStation().getController(), property.getSuccessor());
            }
            return result;
        }
        return null;
    }

    protected class Maximal
    implements CMaximizedModeArea {
        private List<ModeAreaListener> listeners = new ArrayList<ModeAreaListener>();

        protected Maximal() {
        }

        public Dockable[] getMaximized() {
            return ((CScreenDockStation)CScreenDockStationHandle.this.station.getStation()).getFullscreenChildren();
        }

        public boolean isRepresenting(DockStation station) {
            return CScreenDockStationHandle.this.station.getStation() == station;
        }

        public boolean autoDefaultArea() {
            return false;
        }

        public boolean isLocationRoot() {
            return true;
        }

        public DockableProperty getLocation(Dockable child) {
            return DockUtilities.getPropertyChain(this.getStation(), child);
        }

        public Runnable onApply(LocationModeEvent event) {
            if (event.isDone()) {
                return null;
            }
            Location location = event.getLocation();
            Dockable dockable = event.getDockable();
            if (event.getMode().getUniqueIdentifier().equals(ExternalizedMode.IDENTIFIER)) {
                MaximizedModeArea area;
                CLocationMode last = (CLocationMode)CScreenDockStationHandle.this.manager.getCurrentMode(dockable);
                CLocationMode secondLast = (CLocationMode)CScreenDockStationHandle.this.manager.getPreviousMode(dockable);
                if (last != null && secondLast != null && ExternalizedMode.IDENTIFIER.equals(secondLast.getUniqueIdentifier()) && MaximizedMode.IDENTIFIER.equals(last.getUniqueIdentifier()) && (area = (MaximizedModeArea)CScreenDockStationHandle.this.maximizedMode.get(location.getRoot())) == this) {
                    dockable = CScreenDockStationHandle.this.maximizedMode.getMaximizingElement(dockable);
                    area.setMaximized(dockable, false, null, event.getAffected());
                    event.done(true);
                    return null;
                }
            }
            return null;
        }

        public Runnable onApply(LocationModeEvent event, Dockable replacement) {
            return null;
        }

        public void prepareApply(Dockable dockable, Location history, AffectedSet set) {
        }

        public LocationMode getUnmaximizedMode() {
            return CScreenDockStationHandle.this.externalMode;
        }

        public void setMaximized(Dockable dockable, boolean maximized, Location history, AffectedSet set) {
            ScreenDockStation station = this.getStation();
            DockStation parent = dockable.getDockParent();
            if (maximized) {
                if (parent == station) {
                    station.setFullscreen(dockable, true);
                } else {
                    Dockable child = DockUtilities.getDirectChild(station, dockable);
                    if (child == null) {
                        throw new IllegalArgumentException("dockable not a child of this station");
                    }
                    if (!parent.canDrag(dockable)) {
                        throw new IllegalArgumentException("cannot drag dockable from its parent");
                    }
                    parent.drag(dockable);
                    if (!station.drop(dockable, child)) {
                        throw new IllegalStateException("cannot drop dockable on this station");
                    }
                    station.setFullscreen(dockable, true);
                }
            } else if (parent == station) {
                station.setFullscreen(dockable, false);
            } else {
                Dockable child = DockUtilities.getDirectChild(station, dockable);
                ScreenDockProperty location = station.getLocation(child, dockable);
                if (!parent.canDrag(dockable)) {
                    throw new IllegalArgumentException("cannot drag dockable from its current parent");
                }
                location.setFullscreen(false);
                if (!station.drop(dockable, location, true)) {
                    throw new IllegalStateException("could not drop dockable on this station");
                }
            }
        }

        public void addModeAreaListener(ModeAreaListener listener) {
            this.listeners.add(listener);
        }

        public void removeModeAreaListener(ModeAreaListener listener) {
            this.listeners.remove(listener);
        }

        public ModeAreaListener[] listeners() {
            return this.listeners.toArray(new ModeAreaListener[this.listeners.size()]);
        }

        public ScreenDockStation getStation() {
            return (ScreenDockStation)CScreenDockStationHandle.this.station.getStation();
        }

        public String getUniqueId() {
            return CScreenDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            ScreenDockStation station = this.getStation();
            return dockable.getDockParent() == station && station.isFullscreen(dockable);
        }

        public boolean respectWorkingAreas() {
            return false;
        }

        public void setController(DockController controller) {
        }

        public void setMode(LocationMode mode) {
            CScreenDockStationHandle.this.maximizedMode = (CMaximizedMode)mode;
        }

        public CLocation getCLocation(Dockable dockable) {
            return CScreenDockStationHandle.this.getCLocation(dockable);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            return CScreenDockStationHandle.this.getCLocation(dockable, location);
        }
    }

    protected class External
    implements CExternalizedModeArea {
        private List<ModeAreaListener> listeners = new ArrayList<ModeAreaListener>();

        protected External() {
        }

        public DockableProperty getLocation(Dockable child) {
            return DockUtilities.getPropertyChain(this.getStation(), child);
        }

        public boolean autoDefaultArea() {
            return true;
        }

        public boolean isLocationRoot() {
            return true;
        }

        public boolean setLocation(Dockable dockable, DockableProperty location, AffectedSet set) {
            set.add(dockable);
            if (this.isChild(dockable)) {
                if (location != null) {
                    ((CScreenDockStation)CScreenDockStationHandle.this.station.getStation()).move(dockable, location);
                }
                return true;
            }
            boolean acceptable = DockUtilities.acceptable(this.getStation(), dockable);
            if (!acceptable) {
                return false;
            }
            if (location != null && !((CScreenDockStation)CScreenDockStationHandle.this.station.getStation()).drop(dockable, location)) {
                location = null;
            }
            if (location == null) {
                ((CScreenDockStation)CScreenDockStationHandle.this.station.getStation()).drop(dockable);
            }
            return true;
        }

        public void addModeAreaListener(ModeAreaListener listener) {
            this.listeners.add(listener);
        }

        public void removeModeAreaListener(ModeAreaListener listener) {
            this.listeners.remove(listener);
        }

        public ModeAreaListener[] listeners() {
            return this.listeners.toArray(new ModeAreaListener[this.listeners.size()]);
        }

        public DockStation getStation() {
            return CScreenDockStationHandle.this.station.getStation();
        }

        public String getUniqueId() {
            return CScreenDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            return dockable.getDockParent() == CScreenDockStationHandle.this.station.getStation() && !((CScreenDockStation)CScreenDockStationHandle.this.station.getStation()).isFullscreen(dockable);
        }

        public boolean respectWorkingAreas() {
            return false;
        }

        public void setController(DockController controller) {
        }

        public void setMode(LocationMode mode) {
            CScreenDockStationHandle.this.externalMode = mode;
        }

        public CLocation getCLocation(Dockable dockable) {
            return CScreenDockStationHandle.this.getCLocation(dockable);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            return CScreenDockStationHandle.this.getCLocation(dockable, location);
        }
    }
}

