/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElementRepresentative;
import bibliothek.gui.dock.control.focus.FocusController;
import bibliothek.gui.dock.control.focus.FocusRequest;
import bibliothek.gui.dock.control.focus.RepeatingFocusRequest;
import bibliothek.gui.dock.event.FocusVetoListener;
import bibliothek.gui.dock.title.DockTitle;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.Stack;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;

public class EnsuringFocusRequest
implements FocusRequest {
    private Dockable dockable;
    private boolean dockableOnly;
    private Component mouseClicked;

    public EnsuringFocusRequest(Dockable dockable, boolean dockableOnly) {
        this(dockable, dockableOnly, null);
    }

    public EnsuringFocusRequest(Dockable dockable, boolean dockableOnly, Component mouseClicked) {
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.dockable = dockable;
        this.dockableOnly = dockableOnly;
        this.mouseClicked = mouseClicked;
    }

    public DockElementRepresentative getSource() {
        return this.dockable;
    }

    public Component getComponent() {
        return this.mouseClicked;
    }

    public int getDelay() {
        return 0;
    }

    public boolean isHardRequest() {
        return false;
    }

    public void veto(FocusVetoListener.FocusVeto veto) {
    }

    public boolean acceptable(Component component) {
        if (this.dockableOnly) {
            return SwingUtilities.isDescendingFrom(component, this.dockable.getComponent());
        }
        return true;
    }

    public boolean validate(FocusController controller) {
        if (controller.getFocusedDockable() != this.dockable) {
            return false;
        }
        Stack<Dockable> front = new Stack<Dockable>();
        Dockable temp = this.dockable;
        while (temp != null) {
            DockStation parent = temp.getDockParent();
            if (parent != null) {
                front.push(temp);
            }
            temp = parent == null ? null : parent.asDockable();
        }
        while (!front.isEmpty()) {
            Dockable element = (Dockable)front.pop();
            element.getDockParent().setFrontDockable(element);
        }
        if (!this.dockableOnly) {
            DockTitle[] titles = this.dockable.listBoundTitles();
            Component focused = FocusManager.getCurrentManager().getFocusOwner();
            if (focused != null) {
                if (SwingUtilities.isDescendingFrom(focused, this.dockable.getComponent())) {
                    return false;
                }
                for (DockTitle title : titles) {
                    if (!SwingUtilities.isDescendingFrom(focused, title.getComponent())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public FocusRequest grant(Component component) {
        if (component.isFocusable()) {
            component.requestFocus();
            component.requestFocusInWindow();
            return new RepeatingFocusRequest(this.dockable, component, this.isHardRequest());
        }
        if (this.mouseClicked != null && this.mouseClicked != this.dockable.getComponent()) {
            this.mouseClicked.requestFocus();
            this.mouseClicked.requestFocusInWindow();
            return new RepeatingFocusRequest(this.dockable, this.mouseClicked, this.isHardRequest());
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(component);
        return null;
    }
}

