/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.screen.ScreenDockProperty;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderMetaMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;
import java.awt.Rectangle;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScreenDockPerspective
implements PerspectiveStation {
    private PerspectivePlaceholderList<ScreenPerspectiveWindow> dockables = new PerspectivePlaceholderList();

    public void read(PlaceholderMap map, final Map<Integer, PerspectiveDockable> children) {
        PerspectivePlaceholderList<ScreenPerspectiveWindow> next = new PerspectivePlaceholderList<ScreenPerspectiveWindow>();
        next.read(map, new PlaceholderListItemAdapter<PerspectiveDockable, ScreenPerspectiveWindow>(){

            @Override
            public ScreenPerspectiveWindow convert(ConvertedPlaceholderListItem item) {
                if (children == null) {
                    return null;
                }
                int id = item.getInt("id");
                PerspectiveDockable dockable = (PerspectiveDockable)children.get(id);
                if (dockable != null) {
                    ScreenPerspectiveWindow child = new ScreenPerspectiveWindow(dockable);
                    dockable.setParent(ScreenDockPerspective.this);
                    child.setX(item.getInt("x"));
                    child.setY(item.getInt("y"));
                    child.setWidth(item.getInt("width"));
                    child.setHeight(item.getInt("height"));
                    child.setFullscreen(item.getBoolean("fullscreen"));
                    return child;
                }
                return null;
            }
        });
        this.dockables = next;
    }

    @Override
    public PerspectiveDockable getDockable(int index) {
        return ((ScreenPerspectiveWindow)this.dockables.dockables().get(index)).asDockable();
    }

    @Override
    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    @Override
    public PerspectiveDockable asDockable() {
        return null;
    }

    @Override
    public PerspectiveStation asStation() {
        return this;
    }

    @Override
    public String getFactoryID() {
        return "screen dock";
    }

    @Override
    public void setPlaceholders(PlaceholderMap placeholders) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are already children on this station");
        }
        this.dockables = new PerspectivePlaceholderList(placeholders);
    }

    @Override
    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public PlaceholderMap toMap(final Map<PerspectiveDockable, Integer> children) {
        return this.dockables.toMap(new PlaceholderListItemAdapter<PerspectiveDockable, ScreenPerspectiveWindow>(){

            @Override
            public ConvertedPlaceholderListItem convert(int index, ScreenPerspectiveWindow child) {
                if (children == null) {
                    return null;
                }
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                item.putInt("id", (Integer)children.get(child.asDockable()));
                item.putInt("x", child.getX());
                item.putInt("y", child.getY());
                item.putInt("width", child.getWidth());
                item.putInt("height", child.getHeight());
                item.putBoolean("fullscreen", child.isFullscreen());
                Path placeholder = child.asDockable().getPlaceholder();
                if (placeholder != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    public void add(PerspectiveDockable dockable, Rectangle bounds) {
        this.add(dockable, bounds, false);
    }

    public void add(PerspectiveDockable dockable, Rectangle bounds, boolean fullscreen) {
        this.add(dockable, bounds.x, bounds.y, bounds.width, bounds.height, fullscreen);
    }

    public void add(PerspectiveDockable dockable, int x, int y, int width, int height) {
        this.add(dockable, x, y, width, height, false);
    }

    public void add(PerspectiveDockable dockable, int x, int y, int width, int height, boolean fullscreen) {
        DockUtilities.ensureTreeValidity(this, dockable);
        ScreenPerspectiveWindow child = new ScreenPerspectiveWindow(dockable);
        dockable.setParent(this);
        child.setX(x);
        child.setY(y);
        child.setWidth(width);
        child.setHeight(height);
        child.setFullscreen(fullscreen);
        this.dockables.dockables().add(child);
    }

    public void addPlaceholder(PerspectiveDockable dockable, Rectangle bounds) {
        this.addPlaceholder(dockable, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void addPlaceholder(PerspectiveDockable dockable, int x, int y, int width, int height) {
        ScreenPerspectiveWindow child = new ScreenPerspectiveWindow(dockable);
        child.setX(x);
        child.setY(y);
        child.setWidth(width);
        child.setHeight(height);
        child.setFullscreen(false);
        this.dockables.dockables().add(child);
        this.remove(dockable);
    }

    public void addPlaceholder(Path placeholder, Rectangle bounds) {
        this.addPlaceholder(placeholder, bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void addPlaceholder(Path placeholder, int x, int y, int width, int height) {
        int index = this.dockables.list().size();
        this.dockables.list().insertPlaceholder(index, placeholder);
        PlaceholderMetaMap map = this.dockables.list().getMetaMap(index);
        map.putInt("x", x);
        map.putInt("y", y);
        map.putInt("width", width);
        map.putInt("height", height);
    }

    public int indexOf(PerspectiveDockable dockable) {
        int count = 0;
        for (ScreenPerspectiveWindow child : this.dockables.dockables()) {
            if (child.asDockable() == dockable) {
                return count;
            }
            ++count;
        }
        return -1;
    }

    @Override
    public boolean remove(PerspectiveDockable dockable) {
        int index = this.indexOf(dockable);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public PerspectiveDockable remove(int index) {
        PlaceholderMetaMap map = this.dockables.dockables().getMetaMap(index);
        ScreenPerspectiveWindow child = (ScreenPerspectiveWindow)this.dockables.dockables().get(index);
        map.putInt("x", child.getX());
        map.putInt("y", child.getY());
        map.putInt("width", child.getWidth());
        map.putInt("height", child.getHeight());
        this.dockables.remove(child);
        child.dockable.setParent(null);
        return child.dockable;
    }

    @Override
    public void replace(PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
        int index = this.indexOf(oldDockable);
        if (index < 0) {
            throw new IllegalArgumentException("oldDockable is not a child of this station");
        }
        DockUtilities.ensureTreeValidity(this, newDockable);
        ScreenPerspectiveWindow window = (ScreenPerspectiveWindow)this.dockables.dockables().get(index);
        Path placeholder = oldDockable.getPlaceholder();
        if (placeholder != null) {
            this.dockables.put(placeholder, window);
        }
        oldDockable.setParent(null);
        newDockable.setParent(this);
        window.dockable = newDockable;
        if (oldDockable.asStation() != null) {
            int listIndex = this.dockables.levelToBase(index, PlaceholderList.Level.DOCKABLE);
            PlaceholderList.Item item = this.dockables.list().get(listIndex);
            item.setPlaceholderMap(oldDockable.asStation().getPlaceholders());
        }
    }

    public ScreenPerspectiveWindow getWindow(PerspectiveDockable dockable) {
        for (ScreenPerspectiveWindow child : this.dockables.dockables()) {
            if (child.asDockable() != dockable) continue;
            return child;
        }
        return null;
    }

    @Override
    public DockableProperty getDockableProperty(PerspectiveDockable child, PerspectiveDockable target) {
        ScreenPerspectiveWindow window = this.getWindow(child);
        if (window == null) {
            throw new IllegalArgumentException("child is not a child of this station");
        }
        Path placeholder = null;
        placeholder = target != null ? target.getPlaceholder() : child.getPlaceholder();
        return new ScreenDockProperty(window.getX(), window.getY(), window.getWidth(), window.getHeight(), placeholder, window.isFullscreen());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScreenPerspectiveWindow
    implements PlaceholderListItem<PerspectiveDockable> {
        private PerspectiveDockable dockable;
        private int x;
        private int y;
        private int width;
        private int height;
        private boolean fullscreen;

        public ScreenPerspectiveWindow(PerspectiveDockable dockable) {
            if (dockable == null) {
                throw new IllegalArgumentException("dockable must not be null");
            }
            this.dockable = dockable;
        }

        @Override
        public PerspectiveDockable asDockable() {
            return this.dockable;
        }

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            if (width < 0) {
                throw new IllegalArgumentException("width must be >= 0: " + width);
            }
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            if (height < 0) {
                throw new IllegalArgumentException("height must be >= 0: " + height);
            }
            this.height = height;
        }

        public boolean isFullscreen() {
            return this.fullscreen;
        }

        public void setFullscreen(boolean fullscreen) {
            this.fullscreen = fullscreen;
        }
    }
}

