/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.window;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.screen.ScreenDockFullscreenStrategy;
import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.ScreenDockWindowListener;
import bibliothek.gui.dock.station.screen.window.ScreenDockWindowBackgroundComponent;
import bibliothek.gui.dock.station.screen.window.WindowConfiguration;
import bibliothek.gui.dock.station.screen.window.WindowMover;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPaint;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class DisplayerScreenDockWindow
implements ScreenDockWindow {
    private ScreenDockStation station;
    private StationChildHandle handle;
    private List<ScreenDockWindowListener> listeners = new ArrayList<ScreenDockWindowListener>();
    private DockableDisplayerListener displayerListener = new DockableDisplayerListener(){

        public void discard(DockableDisplayer displayer) {
            DisplayerScreenDockWindow.this.discardDisplayer();
        }

        public void moveableElementChanged(DockableDisplayer displayer) {
            DisplayerScreenDockWindow.this.updateTitleMover();
        }
    };
    private DockController controller;
    private boolean showTitle = true;
    private ScreenDockFullscreenStrategy strategy;
    private Rectangle normalBounds;
    private Background background = new Background();
    private WindowMover titleMover;
    private WindowConfiguration configuration;
    private boolean configured = false;

    public DisplayerScreenDockWindow(ScreenDockStation station, WindowConfiguration configuration) {
        if (station == null) {
            throw new IllegalArgumentException("station must not be null");
        }
        this.station = station;
        this.configuration = configuration;
    }

    protected void init(WindowConfiguration configuration) {
        if (configuration.isMoveOnTitleGrab()) {
            this.titleMover = this.createTitleMover();
            this.titleMover.setAllowDragAndDrop(configuration.isAllowDragAndDropOnTitle());
            this.titleMover.setResetOnDropable(configuration.isResetOnDropable());
        }
    }

    protected boolean isMoveOnTitleGrab() {
        return this.titleMover != null;
    }

    protected WindowMover createTitleMover() {
        return new WindowMover(this);
    }

    public void addScreenDockWindowListener(ScreenDockWindowListener listener) {
        this.listeners.add(listener);
    }

    public void removeScreenDockWindowListener(ScreenDockWindowListener listener) {
        this.listeners.remove(listener);
    }

    protected ScreenDockWindowListener[] listeners() {
        return this.listeners.toArray(new ScreenDockWindowListener[this.listeners.size()]);
    }

    protected void fireFullscreenChanged() {
        for (ScreenDockWindowListener listener : this.listeners()) {
            listener.fullscreenStateChanged(this);
        }
    }

    protected void fireVisibilityChanged() {
        for (ScreenDockWindowListener listener : this.listeners()) {
            listener.visibilityChanged(this);
        }
    }

    protected void fireShapeChanged() {
        for (ScreenDockWindowListener listener : this.listeners()) {
            listener.shapeChanged(this);
        }
    }

    protected void fireWindowClosing() {
        for (ScreenDockWindowListener listener : this.listeners()) {
            listener.windowClosing(this);
        }
    }

    protected abstract void showDisplayer(DockableDisplayer var1);

    protected abstract Component getWindowComponent();

    protected abstract void setBackground(BackgroundAlgorithm var1);

    public void setShowTitle(boolean showTitle) {
        if (this.showTitle != showTitle) {
            this.showTitle = showTitle;
            if (this.handle != null) {
                if (showTitle) {
                    this.handle.setTitleRequest(this.station.getTitleVersion());
                } else {
                    this.handle.setTitleRequest(null);
                }
            }
        }
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    public Dockable getDockable() {
        if (this.handle == null) {
            return null;
        }
        return this.handle.getDockable();
    }

    public DockableDisplayer getDockableDisplayer() {
        if (this.handle == null) {
            return null;
        }
        return this.handle.getDisplayer();
    }

    public void setDockable(Dockable dockable) {
        DockableDisplayer displayer;
        if (dockable != null && !this.configured) {
            this.init(this.configuration);
            this.configured = true;
        }
        if (this.handle != null) {
            displayer = this.handle.getDisplayer();
            displayer.removeDockableDisplayerListener(this.displayerListener);
            this.handle.destroy();
            this.updateTitleMover();
            this.handle = null;
        }
        displayer = null;
        if (dockable != null) {
            this.handle = new StationChildHandle(this.station, this.station.getDisplayers(), dockable, this.showTitle ? this.station.getTitleVersion() : null){

                protected void updateTitle(DockTitle title) {
                    super.updateTitle(title);
                    DisplayerScreenDockWindow.this.updateTitleMover();
                }
            };
            this.handle.updateDisplayer();
            displayer = this.handle.getDisplayer();
            displayer.addDockableDisplayerListener(this.displayerListener);
            this.updateTitleMover();
        }
        this.showDisplayer(displayer);
    }

    public WindowConfiguration getConfiguration() {
        return this.configuration;
    }

    private void updateTitleMover() {
        if (this.titleMover != null) {
            if (this.handle != null && this.handle.getDisplayer() != null) {
                this.titleMover.setElement(this.handle.getDisplayer().getMoveableElement());
            } else {
                this.titleMover.setElement(null);
            }
        }
    }

    protected void discardDisplayer() {
        DockableDisplayer displayer = this.handle.getDisplayer();
        displayer.removeDockableDisplayerListener(this.displayerListener);
        this.handle.updateDisplayer();
        displayer = this.handle.getDisplayer();
        displayer.addDockableDisplayerListener(this.displayerListener);
        this.showDisplayer(displayer);
    }

    public void setFullscreenStrategy(ScreenDockFullscreenStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean isFullscreen() {
        if (this.strategy == null) {
            if (this.isVisible()) {
                throw new IllegalStateException("no strategy available");
            }
            return false;
        }
        return this.strategy.isFullscreen(this);
    }

    public void setFullscreen(boolean fullscreen) {
        if (this.strategy == null) {
            throw new IllegalStateException("no strategy available");
        }
        boolean state = this.isFullscreen();
        if (state != fullscreen) {
            this.strategy.setFullscreen(this, fullscreen);
            this.fireFullscreenChanged();
        }
    }

    public void setNormalBounds(Rectangle bounds) {
        this.normalBounds = bounds;
    }

    public Rectangle getNormalBounds() {
        return this.normalBounds;
    }

    public Dimension getMinimumWindowSize() {
        return this.getWindowComponent().getMinimumSize();
    }

    public void setController(DockController controller) {
        if (this.handle != null && this.controller != null) {
            this.handle.setTitleRequest(null);
        }
        this.background.setController(controller);
        this.controller = controller;
        if (this.handle != null && this.controller != null && this.isShowTitle()) {
            this.handle.setTitleRequest(this.station.getTitleVersion());
        }
    }

    public Point getTitleCenter() {
        if (this.handle == null) {
            return null;
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return null;
        }
        Point center = displayer.getTitleCenter();
        if (center == null) {
            return null;
        }
        Component base = this.getWindowComponent();
        if (base == null) {
            return null;
        }
        return SwingUtilities.convertPoint(displayer.getComponent(), center, base);
    }

    public Point getOffsetDrop() {
        if (this.handle == null) {
            return null;
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return null;
        }
        Insets insets = this.getDockableInsets();
        return new Point(insets.left, insets.top);
    }

    public Point getOffsetMove() {
        if (this.handle == null) {
            return null;
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return null;
        }
        DockTitle title = displayer.getTitle();
        if (title == null) {
            return null;
        }
        Component base = this.getWindowComponent();
        if (base == null) {
            return null;
        }
        Point zero = new Point(0, 0);
        zero = SwingUtilities.convertPoint(title.getComponent(), zero, base);
        return zero;
    }

    public boolean inTitleArea(int x, int y) {
        if (this.handle == null) {
            return false;
        }
        DockableDisplayer displayer = this.handle.getDisplayer();
        if (displayer == null) {
            return false;
        }
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, displayer.getComponent());
        return displayer.titleContains(point.x, point.y);
    }

    public boolean inCombineArea(int x, int y) {
        return this.inTitleArea(x, y);
    }

    public boolean contains(int x, int y) {
        Component component = this.getWindowComponent();
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, component);
        return component.contains(point);
    }

    public DockController getController() {
        return this.controller;
    }

    public ScreenDockStation getStation() {
        return this.station;
    }

    protected class Background
    extends BackgroundAlgorithm
    implements ScreenDockWindowBackgroundComponent {
        public Background() {
            super(ScreenDockWindowBackgroundComponent.KIND, "dock.background.station.screen");
        }

        public void set(BackgroundPaint value) {
            super.set(value);
            if (this.getPaint() == null) {
                DisplayerScreenDockWindow.this.setBackground(null);
            } else {
                DisplayerScreenDockWindow.this.setBackground(this);
            }
        }

        public ScreenDockWindow getWindow() {
            return DisplayerScreenDockWindow.this;
        }

        public DockStation getStation() {
            return this.getWindow().getStation();
        }

        public Component getComponent() {
            return DisplayerScreenDockWindow.this.getWindowComponent();
        }
    }
}

