/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util;

import bibliothek.gui.DockController;
import bibliothek.util.workarounds.Workaround;
import java.awt.Component;
import java.awt.Shape;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class Workarounds {
    private static Workarounds workarounds = new Workarounds();
    private List<Workaround> code = new ArrayList<Workaround>();

    public static Workarounds getDefault() {
        return workarounds;
    }

    public static boolean tryAddWorkaround(String className) {
        try {
            Class<?> clazz = Class.forName(className, true, Workarounds.class.getClassLoader());
            Object instance = clazz.newInstance();
            Workarounds.getDefault().addWorkaround((Workaround)instance);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setDefault(Workarounds workarounds) {
        if (workarounds == null) {
            throw new IllegalArgumentException("workarounds must not be null");
        }
        Workarounds.workarounds = workarounds;
    }

    public void addWorkaround(Workaround workaround) {
        this.code.add(workaround);
    }

    public void removeWorkaround(Workaround workaround) {
        this.code.remove(workaround);
    }

    public Workaround[] getWorkarounds() {
        return this.code.toArray(new Workaround[this.code.size()]);
    }

    public void markAsGlassPane(Component component) {
        for (Workaround listener : this.code.toArray(new Workaround[this.code.size()])) {
            listener.markAsGlassPane(component);
        }
    }

    public boolean supportsTransparency(Window window) {
        for (Workaround listener : this.code.toArray(new Workaround[this.code.size()])) {
            if (!listener.supportsPerpixelTransparency(window)) continue;
            return true;
        }
        return false;
    }

    public boolean setTransparent(Window window, Shape shape) {
        boolean result = false;
        for (Workaround listener : this.code.toArray(new Workaround[this.code.size()])) {
            result = listener.setTransparent(window, shape) || result;
        }
        return result;
    }

    public boolean supportsTranslucency(Window window) {
        for (Workaround listener : this.code.toArray(new Workaround[this.code.size()])) {
            if (!listener.supportsPerpixelTranslucency(window)) continue;
            return true;
        }
        return false;
    }

    public boolean setTranslucent(Window window) {
        boolean result = false;
        for (Workaround listener : this.code.toArray(new Workaround[this.code.size()])) {
            result = listener.setTranslucent(window) || result;
        }
        return result;
    }

    public void setup(DockController controller) {
        for (Workaround listener : this.code.toArray(new Workaround[this.code.size()])) {
            listener.setup(controller);
        }
    }

    static {
        String version = System.getProperty("java.version");
        if (!version.startsWith("1.5")) {
            if (version.startsWith("1.6")) {
                Workarounds.tryAddWorkaround("bibliothek.util.workarounds.Java6Workaround");
            } else if (version.startsWith("1.7") || version.startsWith("1.8")) {
                Workarounds.tryAddWorkaround("bibliothek.util.workarounds.Java7Workaround");
            } else {
                Workarounds.tryAddWorkaround("bibliothek.util.workarounds.Java9Workaround");
            }
        }
    }
}

