/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javafx.packager;

import com.sun.tools.linker.Linker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.jar.Pack200;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class Main {
    private static final Map<Profile, String> PROFILES = new HashMap<Profile, String>(4);
    private static final String CDC_CONFIG = "/cdc.properties";
    private static final String CLDC_CONFIG = "/cldc.properties";
    Profile profile;
    File workDir;
    File distDir;
    File keyStore;
    File paramFile;
    File progressJar;
    String sdkHome;
    String applicationName;
    String applicationVersion;
    String applicationVendor;
    String applicationClass;
    String appletWidth;
    String appletHeight;
    String applicationCodebaseUrl;
    String encoding;
    String keyStorePassword;
    String keyalias;
    String keyaliasPassword;
    String splashScreenImage;
    String progressClass;
    String jnlpResourcesInclude;
    String[] sourceRoots;
    String[] libraryRoots;
    String[] resourceRoots;
    boolean verbose;
    boolean sign;
    boolean pack200;
    boolean draggable;
    boolean shortcut;
    boolean noCPinManifest;
    List<String> compilerFlags;
    Set<String> extPackages;
    UpdateCheck updateCheck;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/tools/javafx/packager/Bundle");
    private static final String version = bundle.getString("MSG_Version");
    private static final String help = bundle.getString("MSG_Help");
    private static final Pattern extPattern = Pattern.compile("\\[warnonuse\\].*(javafx(\\.ext\\.\\w+)+)");
    private boolean tempWorkDir;
    private String classpath;
    private String bootcp;
    private String bootcpPrep;
    private String bootcpApp;
    private String runtimeCodebase;
    private String runtimeVer;
    private String preverifyCp;
    private File javaHome;
    private File workDirGenerated;
    private File workDirCompiled;
    private File workDirOptimized;
    private File workDirShrinked;
    private File workDirVerified;
    private File workDirLib;
    private File distDirLib;
    private File distDirRT;
    private File java;
    private File javac;
    private File javafxc;
    private File preverify;
    private File jarSigner;
    private File keyTool;
    private File applicationJar;
    private File applicationJad;
    private File appletJnlp;
    private File applicationJnlp;
    private File applicationHtml;
    private File applicationJnlpJar;
    private String[] runtimeRoots;
    private String[] distRT;
    private File[] distLibs;
    private KeyStore _keyStore;
    private Properties parameters;
    private Properties manglerConfig;

    public Main() {
        PROFILES.put(Profile.DESKTOP, "profiles/desktop.properties");
        PROFILES.put(Profile.MOBILE, "profiles/mobile.properties");
        PROFILES.put(Profile.MIDP, "profiles/mobile.properties");
        PROFILES.put(Profile.TV, "profiles/tv.properties");
        this.profile = Profile.DESKTOP;
        this.distDir = new File("dist");
        this.sdkHome = System.getProperty("javafx.home", System.getenv("JAVAFX_HOME"));
        this.applicationVersion = "1.0";
        this.applicationVendor = System.getProperty("user.name");
        this.appletWidth = "200";
        this.appletHeight = "200";
        this.applicationCodebaseUrl = "";
        this.progressClass = "com.javafx.progressbar.ProgressManager";
        this.compilerFlags = new ArrayList<String>();
        this.extPackages = new HashSet<String>();
        this.updateCheck = UpdateCheck.BACKGROUND;
        this.manglerConfig = new Properties();
    }

    private static String nextArg(String[] args, int i) {
        return i == args.length - 1 ? "" : args[i + 1];
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length == 1 && args[0].equals("-help")) {
            System.out.println(help);
        } else if (args.length == 1 && args[0].equals("-version")) {
            System.out.println(version);
        } else {
            Main m = new Main();
            try {
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.equalsIgnoreCase("-sdkHome")) {
                        m.sdkHome = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-src") || arg.equalsIgnoreCase("-sourcepath")) {
                        m.sourceRoots = (Main.nextArg(args, i++) + ';').replace(File.pathSeparatorChar, ';').split(";");
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-cp") || arg.equalsIgnoreCase("-classpath") || arg.equalsIgnoreCase("-librarypath")) {
                        m.libraryRoots = (Main.nextArg(args, i++) + ';').replace(File.pathSeparatorChar, ';').split(";");
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-res") || arg.equalsIgnoreCase("-resourcepath")) {
                        m.resourceRoots = (Main.nextArg(args, i++) + ';').replace(File.pathSeparatorChar, ';').split(";");
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-d") || arg.equalsIgnoreCase("-destination")) {
                        m.distDir = new File(Main.nextArg(args, i++));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-workDir")) {
                        m.workDir = new File(Main.nextArg(args, i++));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-v") || arg.equalsIgnoreCase("-verbose")) {
                        m.verbose = true;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-p") || arg.equalsIgnoreCase("-profile")) {
                        try {
                            m.profile = Profile.valueOf(Main.nextArg(args, i++).toUpperCase());
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw new Exception(MessageFormat.format(bundle.getString("ERR_UnknownProfile"), args[i]));
                        }
                    }
                    if (arg.equalsIgnoreCase("-appName")) {
                        m.applicationName = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-appVendor")) {
                        m.applicationVendor = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-appVersion")) {
                        m.applicationVersion = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-appClass")) {
                        m.applicationClass = Main.nextArg(args, i++).trim();
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-appWidth")) {
                        m.appletWidth = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-appHeight")) {
                        m.appletHeight = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-appCodebase")) {
                        m.applicationCodebaseUrl = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-encoding")) {
                        m.encoding = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-paramFile")) {
                        m.paramFile = new File(Main.nextArg(args, i++));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-keystore")) {
                        m.keyStore = new File(Main.nextArg(args, i++));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-keystorePassword")) {
                        m.keyStorePassword = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-keyalias")) {
                        m.keyalias = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-keyaliasPassword")) {
                        m.keyaliasPassword = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-sign")) {
                        m.sign = true;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-pack200")) {
                        m.pack200 = true;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-draggable")) {
                        m.draggable = true;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-shortcut")) {
                        m.shortcut = true;
                        continue;
                    }
                    if (arg.startsWith("-J")) {
                        m.compilerFlags.add(arg);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-XXcustomProgressJar")) {
                        m.progressJar = new File(Main.nextArg(args, i++));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-XXcustomProgressClass")) {
                        m.progressClass = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-XXjnlpResourcesInclude")) {
                        m.jnlpResourcesInclude = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-XXnoCPinManifest")) {
                        m.noCPinManifest = true;
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-splash") || arg.equalsIgnoreCase("-splashScreenImage")) {
                        m.splashScreenImage = Main.nextArg(args, i++);
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-extpackages")) {
                        m.extPackages.addAll(Arrays.asList(Main.nextArg(args, i++).split(",")));
                        continue;
                    }
                    if (arg.equalsIgnoreCase("-updatecheck")) {
                        try {
                            m.updateCheck = UpdateCheck.valueOf(Main.nextArg(args, i++).toUpperCase());
                            continue;
                        }
                        catch (IllegalArgumentException e) {
                            throw new Exception(MessageFormat.format(bundle.getString("ERR_UnknownUpdateCheck"), args[i]));
                        }
                    }
                    if (arg.trim().length() <= 0) continue;
                    throw new Exception(MessageFormat.format(bundle.getString("ERR_UnknownArgument"), args[i]));
                }
                m.execute();
            }
            catch (Exception e) {
                if (m.verbose) {
                    throw e;
                }
                System.err.println(e.getMessage());
                System.exit(-1);
            }
        }
    }

    private String cutAndReplace(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() > 1 && s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s.replace("${javafx_home}", this.sdkHome).replace(';', File.pathSeparatorChar);
    }

    private void init() throws Exception {
        if (this.sourceRoots == null || this.sourceRoots.length == 0) {
            throw new Exception(bundle.getString("ERR_SrcNotSpecified"));
        }
        if (this.applicationClass == null || this.applicationClass.length() == 0) {
            throw new Exception(bundle.getString("ERR_ClassNotSpecified"));
        }
        if (this.applicationName == null) {
            this.applicationName = this.applicationClass.substring(this.applicationClass.lastIndexOf(46) + 1);
        }
        if (this.sdkHome == null) {
            throw new Exception(bundle.getString("ERR_SDKNotSet"));
        }
        String exe = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
        this.javafxc = new File(this.sdkHome, "bin/javafxc" + exe);
        this.preverify = new File(this.sdkHome, "emulator/mobile/bin/preverify" + exe);
        Properties props = new Properties();
        File propFile = new File(this.sdkHome, PROFILES.get((Object)this.profile));
        if (!propFile.isFile()) {
            throw new Exception(MessageFormat.format(bundle.getString("ERR_MissingProfileProperties"), propFile.getAbsolutePath()));
        }
        props.load(new FileInputStream(propFile));
        propFile = new File(this.sdkHome, "lib/javafx-runtime.properties");
        if (!propFile.isFile()) {
            throw new Exception(MessageFormat.format(bundle.getString("ERR_MissingProperties"), propFile.getAbsolutePath()));
        }
        props.load(new FileInputStream(propFile));
        String dt_ = props.getProperty("default_toolkit") + "_";
        this.bootcp = this.cutAndReplace(props.getProperty(dt_ + "compile_bootclasspath"));
        this.bootcpPrep = this.cutAndReplace(props.getProperty(dt_ + "compile_bootclasspath_prepend"));
        this.bootcpApp = this.cutAndReplace(props.getProperty(dt_ + "compile_bootclasspath_append"));
        this.classpath = this.cutAndReplace(props.getProperty(dt_ + "compile_classpath"));
        this.preverifyCp = this.cutAndReplace(props.getProperty(dt_ + "preverify_classpath"));
        String runtime = this.cutAndReplace(props.getProperty(dt_ + "runtime_classpath"));
        if (runtime != null) {
            this.runtimeRoots = runtime.split(File.pathSeparator);
        }
        this.runtimeCodebase = props.getProperty("runtime.url");
        this.runtimeVer = props.getProperty("runtime.ver");
        String jHome = this.cutAndReplace(props.getProperty("java_home"));
        if (jHome == null) {
            jHome = System.getenv("JAVA_HOME");
        }
        if (jHome == null) {
            jHome = System.getProperty("java.home");
        }
        if (jHome == null) {
            throw new Exception(bundle.getString("ERR_JavaHomeNotKnown"));
        }
        this.javaHome = new File(jHome);
        this.java = new File(this.javaHome, "bin/java" + exe);
        this.javac = new File(this.javaHome, "bin/javac" + exe);
        this.jarSigner = new File(this.javaHome, "bin/jarsigner" + exe);
        this.keyTool = new File(this.javaHome, "bin/keytool" + exe);
        if (this.workDir == null) {
            this.tempWorkDir = true;
            this.workDir = File.createTempFile("JavaFXToolchain", "workdir");
            this.workDir.delete();
            if (this.verbose) {
                System.err.println(MessageFormat.format(bundle.getString("MSG_TempWorkdir"), this.workDir));
            }
        }
        this.workDirGenerated = new File(this.workDir, "generated");
        this.workDirCompiled = new File(this.workDir, "compiled");
        this.workDirOptimized = new File(this.workDir, "optimized");
        this.workDirShrinked = new File(this.workDir, "shrinked");
        this.workDirVerified = new File(this.workDir, "verified");
        this.workDirLib = new File(this.workDir, "lib");
        if (this.distDir == null) {
            this.distDir = new File("dist");
        }
        this.applicationJad = new File(this.distDir, this.applicationName + ".jad");
        this.applicationJar = new File(this.distDir, this.applicationName + ".jar");
        this.applicationJnlpJar = new File(this.distDir, this.applicationName + "_jnlp.jar");
        this.appletJnlp = new File(this.distDir, this.applicationName + "_browser.jnlp");
        this.applicationJnlp = new File(this.distDir, this.applicationName + ".jnlp");
        this.applicationHtml = new File(this.distDir, this.applicationName + ".html");
        this.distDirLib = new File(this.distDir, "lib");
        this.distDirRT = new File(this.distDir, "rt");
        if (this.applicationCodebaseUrl.length() > 0 && !this.applicationCodebaseUrl.endsWith("/")) {
            this.applicationCodebaseUrl = this.applicationCodebaseUrl + '/';
        }
        if (this.paramFile != null) {
            this.parameters = new Properties();
            FileInputStream in = new FileInputStream(this.paramFile);
            this.parameters.load(in);
            in.close();
        }
        if (this.keyaliasPassword == null) {
            this.keyaliasPassword = this.keyStorePassword;
        }
    }

    private void genMidlet() throws IOException, InterruptedException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_MIDletGeneration"));
        }
        this.workDirGenerated.mkdirs();
        File midlet = new File(this.workDirGenerated, this.applicationClass.replace('.', '/') + "_MIDlet.java");
        midlet.getParentFile().mkdirs();
        PrintWriter pw = this.encoding == null ? new PrintWriter(midlet) : new PrintWriter(midlet, this.encoding);
        int i = this.applicationClass.lastIndexOf(46);
        if (i > 0) {
            pw.println("package " + this.applicationClass.substring(0, i) + ";");
        }
        pw.println("public class " + this.applicationClass.substring(i + 1) + "_MIDlet extends com.sun.javafx.runtime.adapter.FXMIDlet {");
        pw.println("    protected void start() throws java.lang.Throwable {");
        pw.println("        com.sun.javafx.runtime.adapter.AutoWrapper.autoWrap(" + this.applicationClass + ".javafx$run$(null));");
        pw.println("    }");
        pw.println("}");
        pw.flush();
        pw.close();
        String cp = this.classpath + File.pathSeparatorChar + this.toClasspath(this.libraryRoots);
        int ret = this.execute(this.javac.getAbsolutePath(), this.compilerFlags, "-target", "1.5", "-source", "1.5", this.verbose ? "-verbose" : null, this.encoding == null ? null : "-encoding", this.encoding, "-g", this.bootcp == null ? null : "-bootclasspath", this.bootcp, this.bootcpPrep == null ? null : "-Xbootclasspath/p:" + this.bootcpPrep, this.bootcpApp == null ? null : "-Xbootclasspath/a:" + this.bootcpApp, "-cp", cp + File.pathSeparatorChar + this.workDirCompiled.getAbsolutePath(), "-d", this.workDirCompiled.getAbsolutePath(), midlet.getAbsolutePath());
        if (ret != 0) {
            throw new RuntimeException(MessageFormat.format(bundle.getString("ERR_MIDletCompilationFailed"), ret));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void javac() throws IOException, InterruptedException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_JavaCompilation"));
        }
        this.workDir.mkdirs();
        File tmpFile = File.createTempFile("javac", "sources", this.workDir);
        tmpFile.deleteOnExit();
        FileWriter sources = new FileWriter(tmpFile);
        try {
            for (String srcRoot : this.sourceRoots) {
                this.scan(new File(srcRoot), sources, ".java");
            }
        }
        finally {
            sources.close();
        }
        this.workDirCompiled.mkdirs();
        if (tmpFile.length() == 0L) {
            if (this.verbose) {
                System.err.println(bundle.getString("MSG_NothingToCompile"));
            }
        } else {
            String cp = this.classpath + File.pathSeparatorChar + this.toClasspath(this.libraryRoots);
            int ret = this.execute(this.javac.getAbsolutePath(), this.compilerFlags, "-target", "1.5", "-source", "1.5", this.verbose ? "-verbose" : null, this.encoding == null ? null : "-encoding", this.encoding, "-g", this.bootcp == null ? null : "-bootclasspath", this.bootcp, this.bootcpPrep == null ? null : "-Xbootclasspath/p:" + this.bootcpPrep, this.bootcpApp == null ? null : "-Xbootclasspath/a:" + this.bootcpApp, "-classpath", cp, "-d", this.workDirCompiled.getAbsolutePath(), "@" + tmpFile.getAbsolutePath());
            tmpFile.delete();
            if (ret != 0) {
                throw new RuntimeException(MessageFormat.format(bundle.getString("ERR_JavacFailed"), ret));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void javafxc() throws IOException, InterruptedException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_JavaFXCompilation"));
        }
        this.workDir.mkdirs();
        File tmpFile = File.createTempFile("javafxc", "sources", this.workDir);
        tmpFile.deleteOnExit();
        FileWriter sources = new FileWriter(tmpFile);
        try {
            for (String srcRoot : this.sourceRoots) {
                this.scan(new File(srcRoot), sources, ".fx");
            }
        }
        finally {
            sources.close();
        }
        this.workDirCompiled.mkdirs();
        if (tmpFile.length() == 0L) {
            System.out.println(bundle.getString("MSG_NothingToCompile"));
        } else {
            String cp = this.classpath + File.pathSeparatorChar + this.toClasspath(this.libraryRoots) + File.pathSeparator + this.workDirCompiled.getAbsolutePath();
            int ret = this.execute(this.javafxc.getAbsolutePath(), this.compilerFlags, "-target", "1.5", "-source", "1.5", this.verbose ? "-verbose" : null, "-profile", this.profile.toString().toLowerCase(), this.encoding == null ? null : "-encoding", this.encoding, "-g", this.bootcp == null ? null : "-bootclasspath", this.bootcp, this.bootcpPrep == null ? null : "-Xbootclasspath/p:" + this.bootcpPrep, this.bootcpApp == null ? null : "-Xbootclasspath/a:" + this.bootcpApp, "-classpath", cp, "-d", this.workDirCompiled.getAbsolutePath(), "@" + tmpFile.getAbsolutePath());
            tmpFile.delete();
            if (ret != 0) {
                throw new RuntimeException(MessageFormat.format(bundle.getString("ERR_JavaFXCFailed"), ret));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManglerConfig(String config) throws IOException {
        InputStream is = Main.class.getResourceAsStream(config);
        if (is == null) {
            throw new IOException(bundle.getString("ERR_MissingConfiguration"));
        }
        try {
            this.manglerConfig.load(is);
            if (this.verbose) {
                System.err.println(bundle.getString("MSG_ManglerConfiguration"));
                this.manglerConfig.list(System.err);
            }
        }
        finally {
            is.close();
        }
    }

    private void mangle() throws IOException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_BytecodeMangling"));
        }
        Linker mangler = new Linker();
        mangler.addFile(this.workDirCompiled.getAbsolutePath());
        mangler.setDestDir(this.workDirOptimized.getAbsolutePath());
        switch (this.profile) {
            case MIDP: 
            case MOBILE: {
                mangler.addFilters("FxMobile");
                break;
            }
            case TV: {
                mangler.addFilters("FxTV");
            }
        }
        mangler.configureFromProperties(this.manglerConfig);
        this.workDirOptimized.mkdirs();
        mangler.executeFilters();
    }

    private String quotePath(String path) {
        StringBuffer sb = new StringBuffer();
        for (String s : path.split(File.pathSeparator)) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append('\'').append(s).append('\'');
        }
        return sb.toString();
    }

    private void shrink() throws IOException, InterruptedException {
        File proguard = new File(this.sdkHome, "lib/shared/proguard.jar");
        if (proguard.isFile()) {
            if (this.verbose) {
                System.err.println(bundle.getString("MSG_BytecodeShrinking"));
            }
            this.workDirShrinked.mkdirs();
            int ret = this.execute(this.java.getAbsolutePath(), "-jar", proguard.getAbsolutePath(), this.preverifyCp != null ? "-libraryjars" : "", this.preverifyCp != null ? this.quotePath(this.preverifyCp) : "", "-injars", '\'' + this.workDirOptimized.getAbsolutePath() + '\'', "-outjars", '\'' + this.workDirShrinked.getAbsolutePath() + '\'', "-dontoptimize", "-dontobfuscate", "-dontpreverify", "-ignorewarnings", "-keep public class * extends javax.microedition.midlet.MIDlet");
            if (ret != 0) {
                throw new RuntimeException(MessageFormat.format(bundle.getString("ERR_ShrinkingFailed"), ret));
            }
        } else {
            this.workDirShrinked = this.workDirOptimized;
        }
    }

    private void preverify() throws IOException, InterruptedException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_BytecodePreverification"));
        }
        this.workDirVerified.mkdirs();
        int ret = this.execute(this.preverify.getAbsolutePath(), this.preverifyCp != null ? "-classpath" : "", this.preverifyCp != null ? this.preverifyCp : "", "-d", this.workDirVerified.getAbsolutePath(), this.workDirShrinked.getAbsolutePath());
        if (ret != 0) {
            throw new RuntimeException(MessageFormat.format(bundle.getString("ERR_PreverifyFailed"), ret));
        }
    }

    private void midpJar() throws IOException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_MIDPJarpackaging"));
        }
        Manifest m = new Manifest();
        Attributes attr = m.getMainAttributes();
        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attr.put(new Attributes.Name("Created-By"), "JavaFX Packager");
        attr.put(new Attributes.Name("MIDlet-Name"), this.applicationName);
        attr.put(new Attributes.Name("MIDlet-Version"), this.applicationVersion);
        attr.put(new Attributes.Name("MIDlet-Vendor"), this.applicationVendor);
        attr.put(new Attributes.Name("MicroEdition-Profile"), this.profile == Profile.MIDP ? "MIDP-2.0" : "JAVAFX-1.3");
        attr.put(new Attributes.Name("MicroEdition-Configuration"), "CLDC-1.1");
        attr.put(new Attributes.Name("MIDlet-1"), this.applicationName + ",," + this.applicationClass + "_MIDlet");
        if (this.splashScreenImage != null) {
            attr.put(new Attributes.Name("JavaFX-Splashscreen-Image"), this.splashScreenImage);
        }
        this.distDir.mkdirs();
        if (this.applicationJar.exists() && !this.applicationJar.delete()) {
            throw new IOException(MessageFormat.format(bundle.getString("ERR_LockedJar"), this.applicationJar.getAbsolutePath()));
        }
        JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(this.applicationJar), m);
        this.jar(this.workDirVerified, out, Filter.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getJarSignature() throws IOException, GeneralSecurityException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_GettingJarSignature"));
        }
        this._keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        this._keyStore.load(new FileInputStream(this.keyStore), this.keyStorePassword.toCharArray());
        if (this.keyaliasPassword == null) {
            this.keyaliasPassword = this.keyStorePassword;
        }
        Key pk = this._keyStore.getKey(this.keyalias, this.keyaliasPassword.toCharArray());
        Signature signature = Signature.getInstance(pk.getAlgorithm());
        signature.initSign((PrivateKey)pk);
        byte[] buff = new byte[10240];
        FileInputStream jar = new FileInputStream(this.applicationJar);
        try {
            int i;
            while ((i = jar.read(buff)) >= 0) {
                signature.update(buff, 0, i);
            }
        }
        finally {
            jar.close();
        }
        return signature.sign();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJad() throws IOException, GeneralSecurityException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_JadGeneration"));
        }
        this.applicationJad.getParentFile().mkdirs();
        PrintWriter jad = new PrintWriter(this.applicationJad, "UTF-8");
        try {
            jad.write("MIDlet-Name: " + this.applicationName + '\n');
            jad.write("MIDlet-Version: " + this.applicationVersion + '\n');
            jad.write("MIDlet-Vendor: " + this.applicationVendor + '\n');
            jad.write("MicroEdition-Profile: " + (this.profile == Profile.MIDP ? "MIDP-2.0" : "JAVAFX-1.3") + '\n');
            jad.write("MicroEdition-Configuration: CLDC-1.1\n");
            jad.write("MIDlet-1: " + this.applicationName + ",," + this.applicationClass + "_MIDlet\n");
            jad.write("MIDlet-Jar-URL: " + this.applicationCodebaseUrl + this.applicationJar.getName() + '\n');
            jad.write("MIDlet-Jar-Size: " + this.applicationJar.length() + '\n');
            if (this.keyalias != null && this.keyStore != null && this.keyStorePassword != null) {
                jad.write("MIDlet-Jar-RSA-SHA1: " + this.encodeBase64(this.getJarSignature()) + '\n');
                Certificate[] chain = this._keyStore.getCertificateChain(this.keyalias);
                for (int i = 0; i < chain.length; ++i) {
                    jad.write("MIDlet-Certificate-1-" + (i + 1) + ": " + this.encodeBase64(chain[i].getEncoded()) + '\n');
                }
            }
            if (this.parameters != null) {
                for (Map.Entry<Object, Object> en : this.parameters.entrySet()) {
                    jad.write(en.getKey() + ": " + en.getValue() + "\n");
                }
            }
            if (this.splashScreenImage != null) {
                jad.write("JavaFX-Splashscreen-Image: " + this.splashScreenImage + '\n');
            }
        }
        finally {
            jad.close();
        }
    }

    private void tvJar() throws IOException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_JarPackaging"));
        }
        this.applicationJar.getParentFile().mkdirs();
        Manifest m = new Manifest();
        Attributes attr = m.getMainAttributes();
        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attr.put(new Attributes.Name("Created-By"), "JavaFX Packager");
        attr.put(Attributes.Name.MAIN_CLASS, "com.sun.javafx.runtime.adapter.XletRunner");
        attr.put(Attributes.Name.CLASS_PATH, "lib/tv/javafxrt-cdc.jar");
        attr.put(new Attributes.Name("JavaFXRuntime-Version"), "1.1");
        attr.put(new Attributes.Name("MainJavaFXScript"), this.applicationClass);
        attr.put(new Attributes.Name("JavaFXScript-Name"), this.applicationName);
        attr.put(new Attributes.Name("JavaFXScript-Vendor"), this.applicationVendor);
        attr.put(new Attributes.Name("JavaFXScript-Version"), this.applicationVersion);
        StringBuffer cp = new StringBuffer();
        if (this.distLibs != null) {
            for (File lib : this.distLibs) {
                cp.append(' ').append(this.distDirLib.getName()).append('/').append(lib.getName());
            }
        }
        if (cp.length() > 1) {
            attr.put(new Attributes.Name("JavaFXScript-Class-Path"), cp.substring(1));
        }
        if (this.parameters != null) {
            for (Map.Entry<Object, Object> en : this.parameters.entrySet()) {
                attr.put(new Attributes.Name("JavaFXArg-" + en.getKey()), en.getValue());
            }
        }
        if (this.applicationJar.exists() && !this.applicationJar.delete()) {
            throw new IOException(MessageFormat.format(bundle.getString("ERR_LockedJar"), this.applicationJar.getAbsolutePath()));
        }
        this.jar(this.workDirOptimized, new JarOutputStream((OutputStream)new FileOutputStream(this.applicationJar), m), Filter.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packJar() throws IOException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_JarPackaging"));
        }
        this.applicationJar.getParentFile().mkdirs();
        Manifest m = new Manifest();
        Attributes attr = m.getMainAttributes();
        attr.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attr.put(new Attributes.Name("Created-By"), "JavaFX Packager");
        attr.put(Attributes.Name.MAIN_CLASS, this.applicationClass);
        if (this.extPackages.size() > 0) {
            Iterator<String> it = this.extPackages.iterator();
            StringBuffer sb = new StringBuffer(it.next());
            while (it.hasNext()) {
                sb.append(' ').append(it.next());
            }
            Attributes.Name javafxExtName = new Attributes.Name("JavaFX-Extensions");
            attr.put(javafxExtName, sb.toString());
        }
        if (this.noCPinManifest) {
            if (this.applicationJnlpJar.exists() && !this.applicationJnlpJar.delete()) {
                throw new IOException(MessageFormat.format(bundle.getString("ERR_LockedJar"), this.applicationJnlpJar.getAbsolutePath()));
            }
            this.jar(this.workDirCompiled, new JarOutputStream((OutputStream)new FileOutputStream(this.applicationJnlpJar), m), Filter.ALL);
            if (this.pack200) {
                File pack = new File(this.workDir, this.applicationJnlpJar.getName() + ".pack");
                if (this.verbose) {
                    System.err.println(bundle.getString("MSG_Pack200Compression"));
                }
                FileOutputStream packOut = new FileOutputStream(pack);
                try {
                    Pack200.newPacker().pack(new JarFile(this.applicationJnlpJar), (OutputStream)packOut);
                }
                finally {
                    packOut.close();
                }
                if (this.verbose) {
                    System.err.println(bundle.getString("MSG_Pack200Decompression"));
                }
                JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(this.applicationJnlpJar));
                try {
                    Pack200.newUnpacker().unpack(pack, jarOut);
                }
                finally {
                    jarOut.close();
                }
            }
        }
        StringBuffer cp = new StringBuffer();
        if (this.distLibs != null) {
            for (File lib : this.distLibs) {
                cp.append(' ').append(this.distDirLib.getName()).append('/').append(lib.getName());
            }
        }
        if (this.distRT != null) {
            for (String rt : this.distRT) {
                cp.append(' ').append(this.distDirRT.getName()).append('/').append(rt);
            }
        }
        if (cp.length() > 1) {
            attr.put(Attributes.Name.CLASS_PATH, cp.substring(1));
        }
        if (this.applicationJar.exists() && !this.applicationJar.delete()) {
            throw new IOException(MessageFormat.format(bundle.getString("ERR_LockedJar"), this.applicationJar.getAbsolutePath()));
        }
        this.jar(this.workDirCompiled, new JarOutputStream((OutputStream)new FileOutputStream(this.applicationJar), m), Filter.ALL);
        if (this.pack200) {
            File pack = new File(this.workDir, this.applicationJar.getName() + ".pack");
            if (this.verbose) {
                System.err.println(bundle.getString("MSG_Pack200Compression"));
            }
            FileOutputStream packOut = new FileOutputStream(pack);
            try {
                Pack200.newPacker().pack(new JarFile(this.applicationJar), (OutputStream)packOut);
            }
            finally {
                packOut.close();
            }
            if (this.verbose) {
                System.err.println(bundle.getString("MSG_Pack200Decompression"));
            }
            JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(this.applicationJar));
            try {
                Pack200.newUnpacker().unpack(pack, jarOut);
            }
            finally {
                jarOut.close();
            }
        }
    }

    private void generateKeystore() throws IOException, InterruptedException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_KeystoreGeneration"));
        }
        this.keyStore = new File(this.workDir, ".keystore");
        if (this.keyStorePassword == null) {
            this.keyStorePassword = "password";
        }
        if (this.keyalias == null) {
            this.keyalias = "key1";
        }
        if (this.keyaliasPassword == null) {
            this.keyaliasPassword = this.keyStorePassword;
        }
        int ret = this.execute(this.keyTool.getAbsolutePath(), "-genkey", "-keystore", this.keyStore.getAbsolutePath(), "-storepass", this.keyStorePassword, "-alias", this.keyalias, "-keypass", this.keyaliasPassword, "-dname", "CN=" + this.applicationVendor.replaceAll("([\\,=\\+\\\\;])", "\\\\$1"));
    }

    private void signJar(File jar) throws IOException, InterruptedException {
        int ret;
        if (this.keyalias == null) {
            this.generateKeystore();
        }
        if (this.verbose) {
            System.err.println(MessageFormat.format(bundle.getString("MSG_SigningJar"), jar.getAbsolutePath()));
        }
        if ((ret = this.execute(this.jarSigner.getAbsolutePath(), this.keyStore == null ? null : "-keystore", this.keyStore == null ? null : this.keyStore.getAbsolutePath(), "-storepass", this.keyStorePassword, "-keypass", this.keyaliasPassword, jar.getAbsolutePath(), this.keyalias)) != 0) {
            throw new RuntimeException(MessageFormat.format(bundle.getString("ERR_JarsignerFailed"), ret));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzipJar(File jar) throws IOException {
        if (this.verbose) {
            System.err.println(MessageFormat.format(bundle.getString("MSG_Pack200"), jar));
        }
        GZIPOutputStream gOut = new GZIPOutputStream(new FileOutputStream(jar.getAbsolutePath() + ".pack.gz"));
        try {
            Pack200.newPacker().pack(new JarFile(jar), (OutputStream)gOut);
        }
        finally {
            gOut.close();
        }
    }

    private void copyRuntime() throws IOException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_CopyingRuntime"));
        }
        if (this.runtimeRoots != null && this.runtimeRoots.length > 0) {
            this.distDirRT.mkdirs();
            this.distRT = new String[this.runtimeRoots.length];
            for (int i = 0; i < this.runtimeRoots.length; ++i) {
                this.distRT[i] = new File(this.runtimeRoots[i]).getName();
                this.copy(new FileInputStream(this.runtimeRoots[i]), new File(this.distDirRT, this.distRT[i]));
            }
        }
    }

    private void repackLibs() throws IOException {
        if ((this.libraryRoots == null || this.libraryRoots.length == 0) && this.progressJar == null) {
            return;
        }
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_RepackagingLibraries"));
        }
        this.workDirLib.mkdirs();
        this.distDirLib.mkdirs();
        if (this.progressJar != null) {
            this.progressJar = this.repackLib(this.progressJar);
        }
        if (this.libraryRoots != null) {
            ArrayList<File> distLibraries = new ArrayList<File>();
            for (String lib : this.libraryRoots) {
                File distLib;
                File libRoot = new File(lib);
                if (libRoot.isDirectory()) {
                    String libName = libRoot.getName() + ".jar";
                    File libJar = new File(this.workDirLib, libRoot.getParentFile() == null ? libName : libRoot.getParentFile().getName() + "_" + libName);
                    if (this.verbose) {
                        System.err.println(MessageFormat.format(bundle.getString("MSG_JarPackagingLibrary"), libRoot, libJar));
                    }
                    this.jar(libRoot, new JarOutputStream(new FileOutputStream(libJar)), Filter.ALL);
                    libRoot = libJar;
                }
                if ((distLib = this.repackLib(libRoot)) == null) continue;
                distLibraries.add(distLib);
            }
            this.distLibs = distLibraries.toArray(new File[distLibraries.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File repackLib(File libRoot) throws IOException {
        if (libRoot.exists()) {
            File distLib = new File(this.distDirLib, libRoot.getName());
            if (distLib.exists() && !distLib.delete()) {
                throw new IOException(MessageFormat.format(bundle.getString("ERR_LockedJar"), distLib.getAbsolutePath()));
            }
            if (this.pack200) {
                File pack = new File(this.workDirLib, libRoot.getName() + ".pack");
                if (this.verbose) {
                    System.err.println(MessageFormat.format(bundle.getString("MSG_Pack200Compressing"), libRoot, pack));
                }
                FileOutputStream packOut = new FileOutputStream(pack);
                try {
                    Pack200.newPacker().pack(new JarFile(libRoot), (OutputStream)packOut);
                }
                finally {
                    packOut.close();
                }
                if (this.verbose) {
                    System.err.println(MessageFormat.format(bundle.getString("MSG_Pack200Decompressing"), pack, distLib));
                }
                JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(distLib));
                try {
                    Pack200.newUnpacker().unpack(pack, jarOut);
                }
                finally {
                    jarOut.close();
                }
            }
            this.copy(new FileInputStream(libRoot), distLib);
            return distLib;
        }
        if (this.verbose) {
            System.err.println(MessageFormat.format(bundle.getString("MSG_LibMissing"), libRoot));
        }
        return null;
    }

    private void mangleLibs() throws IOException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_ManglingLibraries"));
        }
        if (this.libraryRoots.length > 0) {
            this.distDirLib.mkdirs();
        }
        ArrayList<File> distLibraries = new ArrayList<File>();
        for (String lib : this.libraryRoots) {
            File libRoot = new File(lib);
            if (libRoot.exists()) {
                String libName = libRoot.isDirectory() ? (libRoot.getParentFile() == null ? libRoot.getName() : libRoot.getParentFile().getName() + "_" + libRoot.getName()) + ".jar" : libRoot.getName();
                File distLib = new File(this.distDirLib, libName);
                if (distLib.exists() && !distLib.delete()) {
                    throw new IOException(MessageFormat.format(bundle.getString("ERR_LockedJar"), distLib.getAbsolutePath()));
                }
                Linker mangler = new Linker();
                mangler.addFile(libRoot.getAbsolutePath());
                mangler.setDestFile(distLib.getAbsolutePath());
                switch (this.profile) {
                    case MIDP: 
                    case MOBILE: {
                        mangler.addFilters("FxMobile");
                        break;
                    }
                    case TV: {
                        mangler.addFilters("FxTV");
                    }
                }
                mangler.configureFromProperties(this.manglerConfig);
                mangler.executeFilters();
                distLibraries.add(distLib);
                continue;
            }
            if (!this.verbose) continue;
            System.err.println(MessageFormat.format(bundle.getString("MSG_LibMissing"), libRoot));
        }
        this.distLibs = distLibraries.toArray(new File[distLibraries.size()]);
    }

    private void signLibs() throws IOException, InterruptedException {
        if (this.distLibs == null && this.progressJar == null) {
            return;
        }
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_SigningLibraries"));
        }
        if (this.progressJar != null) {
            this.signJar(this.progressJar);
        }
        if (this.distLibs != null) {
            for (File lib : this.distLibs) {
                this.signJar(lib);
            }
        }
    }

    private void gzipLibs() throws IOException {
        if (this.distLibs == null && this.progressJar == null) {
            return;
        }
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_Pack200Libraries"));
        }
        if (this.progressJar != null) {
            this.gzipJar(this.progressJar);
        }
        if (this.distLibs != null) {
            for (File lib : this.distLibs) {
                this.gzipJar(lib);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJnlp(boolean applet) throws IOException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_JNLPGeneration"));
        }
        PrintWriter jnlp = new PrintWriter(applet ? this.appletJnlp : this.applicationJnlp, "UTF-8");
        try {
            jnlp.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            jnlp.write("<jnlp spec=\"1.0+\"");
            jnlp.write(" codebase=\"" + (this.applicationCodebaseUrl.length() == 0 ? this.distDir.toURI().toURL().toExternalForm() : this.applicationCodebaseUrl) + "\"");
            jnlp.write(" href=\"" + (applet ? this.appletJnlp : this.applicationJnlp).getName() + "\">\n");
            jnlp.write("    <information>\n");
            jnlp.write("        <title>" + this.applicationName + "</title>\n");
            jnlp.write("        <vendor>" + this.applicationVendor + "</vendor>\n");
            jnlp.write("        <homepage href=\"" + this.applicationCodebaseUrl + "\"/>\n");
            jnlp.write("        <description>" + this.applicationName + "</description>\n");
            jnlp.write("        <icon kind=\"splash\" href=\"" + this.runtimeCodebase + "splash.png\"/>\n");
            jnlp.write("        <offline-allowed/>\n");
            if (this.shortcut) {
                jnlp.write("        <shortcut>\n");
                jnlp.write("            <desktop/>\n");
                jnlp.write("        </shortcut>\n");
            }
            jnlp.write("    </information>\n");
            if (this.sign) {
                jnlp.write("    <security>\n");
                jnlp.write("        <all-permissions/>\n");
                jnlp.write("    </security>\n");
            }
            jnlp.write("    <resources>\n");
            if (this.jnlpResourcesInclude != null) {
                jnlp.write(this.unEscape(this.jnlpResourcesInclude));
            }
            jnlp.write("        <j2se version=\"1.5+\"/>\n");
            if (this.pack200) {
                jnlp.write("        <property name=\"jnlp.packEnabled\" value=\"true\"/>\n");
                jnlp.write("        <property name=\"jnlp.versionEnabled\" value=\"true\"/>\n");
            }
            jnlp.write("        <extension name=\"JavaFX Runtime\" href=\"" + this.runtimeCodebase + "javafx-rt.jnlp\"/>\n");
            jnlp.write("        <jar href=\"" + (this.noCPinManifest ? this.applicationJnlpJar : this.applicationJar).getName() + "\" main=\"true\" size=\"" + (this.noCPinManifest ? this.applicationJnlpJar : this.applicationJar).length() + "\"/>\n");
            if (this.progressJar != null) {
                jnlp.write("        <jar href=\"lib/" + this.progressJar.getName() + "\" size=\"" + this.progressJar.length() + "\" download=\"progress\"/>\n");
            }
            if (this.distLibs != null) {
                for (File lib : this.distLibs) {
                    jnlp.write("        <jar href=\"lib/" + lib.getName() + "\" size=\"" + lib.length() + "\"/>\n");
                }
            }
            jnlp.write("    </resources>\n");
            if (applet) {
                jnlp.write("    <applet-desc name=\"" + this.applicationName + "\" main-class=\"com.sun.javafx.runtime.adapter.Applet\" " + (this.progressClass == null ? "" : "progress-class=\"" + this.progressClass + "\" ") + "width=\"" + this.appletWidth + "\" height=\"" + this.appletHeight + "\">\n");
                jnlp.write("        <param name=\"MainJavaFXScript\" value=\"" + this.applicationClass + "\"/>\n");
                if (this.parameters != null) {
                    for (Map.Entry<Object, Object> en : this.parameters.entrySet()) {
                        jnlp.write("        <param name=\"" + en.getKey() + "\" value=\"" + en.getValue() + "\"/>\n");
                    }
                }
                jnlp.write("    </applet-desc>\n");
            } else {
                jnlp.write("    <application-desc main-class=\"com.sun.javafx.runtime.main.Main\"" + (this.progressClass == null ? ">\n" : " progress-class=\"" + this.progressClass + "\">\n"));
                jnlp.write("        <argument>MainJavaFXScript=" + this.applicationClass + "</argument>\n");
                if (this.parameters != null) {
                    for (Map.Entry<Object, Object> en : this.parameters.entrySet()) {
                        jnlp.write("        <argument>" + en.getKey() + "=" + en.getValue() + "</argument>\n");
                    }
                }
                jnlp.write("    </application-desc>\n");
            }
            jnlp.write("    <update check=\"" + this.updateCheck.toString().toLowerCase() + "\"/>\n");
            jnlp.write("</jnlp>\n");
        }
        finally {
            jnlp.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHtml() throws IOException {
        if (this.verbose) {
            System.err.println(bundle.getString("MSG_HTMLGeneration"));
        }
        PrintWriter html = new PrintWriter(this.applicationHtml, "UTF-8");
        try {
            html.write("<html>\n");
            html.write("<head>\n");
            html.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
            html.write("<title>" + this.applicationName + "</title>\n");
            html.write("</head>\n");
            html.write("<body>\n");
            html.write("<h1>" + this.applicationName + "</h1>\n");
            html.write("<script src=\"" + this.runtimeCodebase + "dtfx.js\"></script>\n");
            html.write("<script>\n");
            if (this.parameters != null) {
                html.write("    var appParams = new Array();\n");
                for (Map.Entry<Object, Object> en : this.parameters.entrySet()) {
                    html.write("    appParams[\"" + en.getKey() + "\"] = \"" + en.getValue() + "\";\n");
                }
            }
            html.write("    javafx(\n");
            html.write("        {\n");
            html.write("              archive: \"" + (this.noCPinManifest ? this.applicationJnlpJar : this.applicationJar).getName() + "\",\n");
            if (this.draggable) {
                html.write("              draggable: true,\n");
            }
            html.write("              width: " + this.appletWidth + ",\n");
            html.write("              height: " + this.appletHeight + ",\n");
            html.write("              code: \"" + this.applicationClass + "\",\n");
            if (this.extPackages.size() > 0) {
                html.write("              extPackages: \"");
                Iterator<String> it = this.extPackages.iterator();
                html.write(it.next());
                while (it.hasNext()) {
                    html.write(44);
                    html.write(it.next());
                }
                html.write("\",\n");
            }
            html.write("              name: \"" + this.applicationName + "\"\n");
            html.write("        }\n");
            if (this.parameters != null) {
                html.write("        , appParams\n");
            }
            html.write("    );\n");
            html.write("</script>\n");
            html.write("</body>\n");
            html.write("</html>\n");
        }
        finally {
            html.close();
        }
    }

    private boolean deleteRecursively(File f) {
        if (f.isDirectory()) {
            for (File ff : f.listFiles()) {
                this.deleteRecursively(ff);
            }
        }
        return f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(InputStream in, File f2) throws IOException {
        try {
            f2.getParentFile().mkdirs();
            byte[] b = new byte[65000];
            FileOutputStream out = new FileOutputStream(f2);
            try {
                int i;
                while ((i = in.read(b)) > 0) {
                    out.write(b, 0, i);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private void copy(File dir1, File dir2, Filter filter) throws IOException, InterruptedException {
        if (this.verbose) {
            System.err.println(MessageFormat.format(bundle.getString("MSG_Copying"), new Object[]{dir1, dir2, filter}));
        }
        for (File f : dir1.listFiles()) {
            if (f.isDirectory()) {
                this.copy(f, new File(dir2, f.getName()), filter);
                continue;
            }
            if (filter != Filter.ALL && (filter != Filter.CLASSES_ONLY || !f.getName().endsWith(".class")) && (filter != Filter.RESOURCES || !this.isResource(f.getAbsolutePath()))) continue;
            if (f.getName().endsWith(".fxz")) {
                this.unzip(new ZipFile(f), new File(dir2, f.getName()), Filter.ALL);
            } else {
                this.copy(new FileInputStream(f), new File(dir2, f.getName()));
            }
            if (!f.getName().endsWith(".css")) continue;
            String bssName = f.getName().substring(0, f.getName().length() - 3) + "bss";
            if (new File(f.getParentFile(), bssName).isFile()) continue;
            this.compileCSStoBSS(f, new File(dir2, bssName));
        }
    }

    private void compileCSStoBSS(File css, File bss) throws IOException, InterruptedException {
        if (this.verbose) {
            System.err.println(MessageFormat.format(bundle.getString("MSG_CompilingCSS"), css, bss));
        }
        this.execute(this.java.getAbsolutePath(), "-cp", new File(this.sdkHome, "lib/desktop/javafx-ui-common.jar").getAbsolutePath() + File.pathSeparator + new File(this.sdkHome, "lib/shared/javafxrt.jar").getAbsolutePath(), "com.sun.stylesheet.css.parser.Css2Bin", css.getAbsolutePath(), bss.getAbsolutePath());
    }

    private void unzip(ZipFile zip, File dir, Filter filter) throws IOException {
        if (this.verbose) {
            System.err.println(MessageFormat.format(bundle.getString("MSG_Unzipping"), new Object[]{zip.getName(), dir, filter}));
        }
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry ze = entries.nextElement();
            if (ze.isDirectory()) continue;
            if (filter != Filter.ALL && (filter != Filter.CLASSES_ONLY || !ze.getName().endsWith(".class")) && (filter != Filter.RESOURCES || !this.isResource(ze.getName()))) continue;
            this.copy(zip.getInputStream(ze), new File(dir, ze.getName()));
        }
        zip.close();
    }

    private void expand(String[] roots, File targetDir, Filter filter) throws IOException, InterruptedException {
        if (roots != null) {
            for (String rtPath : roots) {
                File rt = new File(rtPath);
                if (!rt.exists()) {
                    System.err.println(MessageFormat.format(bundle.getString("WARN_MissignFile"), rt.getAbsolutePath()));
                    continue;
                }
                if (rt.isDirectory()) {
                    this.copy(rt, targetDir, filter);
                    continue;
                }
                if (!rt.getName().endsWith("jar") && !rt.getName().endsWith("zip")) continue;
                this.unzip(new ZipFile(rt), targetDir, filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jar(File dir, JarOutputStream jar, Filter filter) throws IOException {
        try {
            this.jar(dir, jar, filter, dir.getAbsolutePath().length() + 1);
        }
        finally {
            jar.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jar(File dir, JarOutputStream jar, Filter filter, int cut) throws IOException {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.jar(f, jar, filter, cut);
                continue;
            }
            if (filter != Filter.ALL && (filter != Filter.CLASSES_ONLY || !f.getName().endsWith(".class")) && (filter != Filter.RESOURCES || !this.isResource(f.getAbsolutePath()))) continue;
            jar.putNextEntry(new ZipEntry(f.getAbsolutePath().substring(cut).replace('\\', '/')));
            byte[] b = new byte[65000];
            FileInputStream in = new FileInputStream(f);
            try {
                int i;
                while ((i = in.read(b)) > 0) {
                    jar.write(b, 0, i);
                }
            }
            finally {
                in.close();
            }
            jar.closeEntry();
        }
    }

    private boolean isResource(String name) {
        if (name.endsWith(".class")) {
            return false;
        }
        if (name.endsWith(".java")) {
            return false;
        }
        if (name.endsWith(".fx")) {
            return false;
        }
        if (name.endsWith(".cvsignore")) {
            return false;
        }
        if (name.endsWith(".hgignore")) {
            return false;
        }
        if (name.endsWith("vssver.scc")) {
            return false;
        }
        if (name.endsWith(".DS_Store")) {
            return false;
        }
        if (name.endsWith("~")) {
            return false;
        }
        if ((name = name.replace('\\', '/')).indexOf("/CVS/") >= 0) {
            return false;
        }
        if (name.indexOf("/.svn/") >= 0) {
            return false;
        }
        if (name.indexOf("/.hg/") >= 0) {
            return false;
        }
        if (name.indexOf("/.#") >= 0) {
            return false;
        }
        if (name.indexOf("/._") >= 0) {
            return false;
        }
        if (name.endsWith("#") && name.indexOf("/#") >= 0) {
            return false;
        }
        if (name.endsWith("%") && name.indexOf("/%") >= 0) {
            return false;
        }
        return !name.endsWith("MANIFEST.MF");
    }

    private void scan(File dir, Writer out, String extension) throws IOException {
        if (!dir.exists()) {
            System.err.println(MessageFormat.format(bundle.getString("WARN_MissignFile"), dir.getAbsolutePath()));
        } else {
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    this.scan(f, out, extension);
                    continue;
                }
                if (!f.getName().endsWith(extension)) continue;
                out.write('\'' + f.getAbsolutePath().replace('\\', '/') + "'\n");
            }
        }
    }

    private int execute(Object ... args) throws IOException, InterruptedException {
        ArrayList<String> l = new ArrayList<String>();
        for (Object a : args) {
            if (a instanceof List) {
                l.addAll((List)a);
                continue;
            }
            if (!(a instanceof String)) continue;
            l.add((String)a);
        }
        if (this.verbose) {
            System.err.println(MessageFormat.format(bundle.getString("MSG_Executing"), l));
        }
        Process p = Runtime.getRuntime().exec(l.toArray(new String[l.size()]));
        final BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    String line;
                    while ((line = in.readLine()) != null) {
                        System.out.println(line);
                        Matcher m = extPattern.matcher(line);
                        if (!m.find()) continue;
                        Main.this.extPackages.add(m.group(1));
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        t.setDaemon(true);
        t.start();
        final BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        t = new Thread(new Runnable(){

            public void run() {
                try {
                    String line;
                    while ((line = err.readLine()) != null) {
                        System.err.println(line);
                        Matcher m = extPattern.matcher(line);
                        if (!m.find()) continue;
                        Main.this.extPackages.add(m.group(1));
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        t.setDaemon(true);
        t.start();
        return p.waitFor();
    }

    private String toClasspath(String[] fs) {
        StringBuilder sb = new StringBuilder();
        if (fs != null) {
            for (String f : fs) {
                if (sb.length() > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append(f);
            }
        }
        return sb.toString();
    }

    private String encodeBase64(byte[] raw) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < raw.length; i += 3) {
            int bl = 0;
            int sl = raw.length - i - 1;
            int end = sl >= 2 ? 2 : sl;
            for (int j = 0; j <= end; ++j) {
                int b = raw[i + j];
                bl += (b < 0 ? b + 256 : b) << 8 * (2 - j);
            }
            char[] ch4 = new char[4];
            for (int j = 0; j < 4; ++j) {
                int ch = bl >>> 6 * (3 - j) & 0x3F;
                ch4[j] = ch <= 25 ? (int)(65 + ch) : (ch <= 51 ? (int)(97 + ch - 26) : (ch <= 61 ? (int)(48 + ch - 52) : (ch == 62 ? 43 : 47)));
            }
            if (sl < 1) {
                ch4[2] = 61;
            }
            if (sl < 2) {
                ch4[3] = 61;
            }
            ret.append(ch4);
        }
        return ret.toString();
    }

    private String unEscape(String s) {
        return s.replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&").replace("\\n", "\n").replace("\\r", "\r").replace("\\t", "\t").replace("\\\\", "\\");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void execute() throws Exception {
        if (this.verbose) {
            System.err.println(MessageFormat.format(bundle.getString("MSG_UsingProfile"), this.profile.name()));
        }
        this.init();
        try {
            this.javac();
            this.javafxc();
            switch (this.profile) {
                case MIDP: 
                case MOBILE: {
                    this.genMidlet();
                    this.expand(this.libraryRoots, this.workDirCompiled, Filter.CLASSES_ONLY);
                    this.loadManglerConfig(CLDC_CONFIG);
                    this.mangle();
                    this.expand(this.runtimeRoots, this.workDirOptimized, Filter.CLASSES_ONLY);
                    this.shrink();
                    this.preverify();
                    this.expand(this.runtimeRoots, this.workDirVerified, Filter.RESOURCES);
                    this.expand(this.libraryRoots, this.workDirVerified, Filter.RESOURCES);
                    this.expand(this.resourceRoots, this.workDirVerified, Filter.RESOURCES);
                    this.expand(this.sourceRoots, this.workDirVerified, Filter.RESOURCES);
                    this.midpJar();
                    this.createJad();
                    return;
                }
                case TV: {
                    this.loadManglerConfig(CDC_CONFIG);
                    this.mangle();
                    this.expand(this.resourceRoots, this.workDirOptimized, Filter.RESOURCES);
                    this.expand(this.sourceRoots, this.workDirOptimized, Filter.RESOURCES);
                    if (this.libraryRoots != null) {
                        this.mangleLibs();
                    }
                    this.tvJar();
                    return;
                }
                case DESKTOP: {
                    this.expand(this.sourceRoots, this.workDirCompiled, Filter.RESOURCES);
                    this.expand(this.resourceRoots, this.workDirCompiled, Filter.RESOURCES);
                    this.expand(this.runtimeRoots, this.workDirCompiled, Filter.ALL);
                    this.repackLibs();
                    if (this.sign) {
                        this.signLibs();
                    }
                    if (this.pack200) {
                        this.gzipLibs();
                    }
                    this.packJar();
                    if (this.sign) {
                        this.signJar(this.applicationJar);
                    }
                    if (this.pack200) {
                        this.gzipJar(this.applicationJar);
                    }
                    if (this.noCPinManifest) {
                        if (this.sign) {
                            this.signJar(this.applicationJnlpJar);
                        }
                        if (this.pack200) {
                            this.gzipJar(this.applicationJnlpJar);
                        }
                    }
                    this.createJnlp(false);
                    this.createJnlp(true);
                    this.createHtml();
                    return;
                }
            }
            return;
        }
        finally {
            if (this.tempWorkDir) {
                this.deleteRecursively(this.workDir);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Filter {
        ALL,
        CLASSES_ONLY,
        RESOURCES;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Profile {
        DESKTOP,
        MOBILE,
        MIDP,
        TV;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum UpdateCheck {
        BACKGROUND,
        TIMEOUT,
        ALWAYS;

    }
}

