/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker;

import com.sun.tools.linker.Entry;
import com.sun.tools.linker.FileEntry;
import com.sun.tools.linker.JarFileEntry;
import com.sun.tools.linker.JdkEntry;
import com.sun.tools.linker.filters.FilterChain;
import com.sun.tools.linker.filters.Retro14;
import com.sun.tools.linker.filters.Strip;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.objectweb.asm.ClassReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Linker {
    private FilterChain filters = new FilterChain();
    private List<File> libraries = new ArrayList<File>();
    private List<File> files = new ArrayList<File>();
    private List<String> jdkEntries = new ArrayList<String>();
    private File destDir;
    private File destFile;
    private boolean uncompressedOutputJar = false;
    private JarOutputStream jarOutputStream;
    private File jdkDir;
    private final Map<String, String> props = new HashMap<String, String>();
    private List<Entry> entries = new ArrayList<Entry>();
    private List<Entry> libraryEntries = new ArrayList<Entry>();
    private List<String> excludes = new ArrayList<String>();
    private static final String LINKER_PREFIX = "linker.";
    private static final String LINKER_JDK_PREFIX = "linker.loadjdkclass.";
    private static final String KEY_PREFIX = "linker.class.exclude.";

    public static void main(String[] args) throws IOException {
        Linker linker = new Linker();
        try {
            linker.setupFromArgs(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            Linker.printUsage();
            System.exit(1);
        }
        linker.executeFilters();
    }

    public void addFilters(String filterString) {
        for (String f : filterString.split(",")) {
            this.filters.addByClass(f);
        }
    }

    public void addLibrary(String library) {
        this.libraries.add(new File(library));
    }

    public void addFile(String file) {
        this.files.add(new File(file));
    }

    public void setDestDir(String dest) {
        if (this.destFile != null) {
            throw new IllegalArgumentException("Cannot use destFile and destDir simoultanously");
        }
        this.destDir = new File(dest);
    }

    public void setDestFile(String dest) {
        if (this.destDir != null) {
            throw new IllegalArgumentException("Cannot use destFile and destDir simoultanously");
        }
        this.destFile = new File(dest);
    }

    public void setJdkDir(String dir) {
        this.jdkDir = new File(dir);
    }

    public void setVerbose(boolean v) {
        this.addProp("verbose", Boolean.toString(v));
    }

    public void setDebug(boolean d) {
        this.addProp("debug", Boolean.toString(d));
    }

    public void configureFromFile(String file) throws IOException {
        this.configureFromFile(new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureFromFile(File file) throws IOException {
        Properties p = new Properties();
        FileInputStream is = new FileInputStream(file);
        try {
            p.load(is);
            this.configureFromProperties(p);
        }
        finally {
            is.close();
        }
    }

    public void configureFromProperties(Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            this.addProp((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void addProp(String key, String value) {
        this.props.put(key, value);
    }

    private void processProps() {
        for (Map.Entry<String, String> entry : this.props.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith(LINKER_JDK_PREFIX)) {
                String rest = key.substring(LINKER_JDK_PREFIX.length());
                String className = rest.replace('.', '/') + ".class";
                this.jdkEntries.add(className);
                continue;
            }
            if (!key.toLowerCase().startsWith(KEY_PREFIX)) continue;
            String className = key.substring(KEY_PREFIX.length()).replace('.', '/');
            this.excludes.add(className);
        }
    }

    private void setupFromArgs(String[] args) throws IOException, IllegalArgumentException {
        if (args.length == 0) {
            throw new IllegalArgumentException("No options specified");
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("--filters") || arg.equals("-f")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("No filters specified with --filters option");
                }
                this.addFilters(args[i]);
                continue;
            }
            if (arg.equals("--library") || arg.equals("-l")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("No library specified with --library option");
                }
                this.addLibrary(args[i]);
                continue;
            }
            if (arg.equals("--dest-dir") || arg.equals("-d")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("No destination dir specified with --dest-dir option");
                }
                if (args[i].endsWith(".jar")) {
                    this.setDestFile(args[i]);
                    continue;
                }
                this.setDestDir(args[i]);
                continue;
            }
            if (arg.equals("-0")) {
                this.uncompressedOutputJar = true;
                continue;
            }
            if (arg.equals("--jdk")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("No jdk specified with --jdk option");
                }
                this.setJdkDir(args[i]);
                continue;
            }
            if (arg.equals("-v") || arg.equals("--verbose")) {
                this.setVerbose(true);
                continue;
            }
            if (arg.equals("--debug")) {
                this.setDebug(true);
                continue;
            }
            if (arg.startsWith("-D")) {
                String whole;
                String name = whole = arg.substring("-D".length());
                String value = "";
                int indexOfEq = whole.indexOf(61);
                if (indexOfEq != -1) {
                    name = whole.substring(0, indexOfEq);
                    value = whole.substring(indexOfEq + 1);
                }
                this.addProp(name, value);
                continue;
            }
            if (arg.equals("-c") || arg.equals("--config")) {
                if (++i == args.length) {
                    throw new IllegalArgumentException("No file specified with " + arg + " option");
                }
                this.configureFromFile(args[i]);
                continue;
            }
            if (arg.startsWith("-")) {
                throw new IllegalArgumentException("Unknown option:" + arg);
            }
            this.addFile(arg);
        }
    }

    private void checkConfigurationAndInit() {
        if (this.destDir == null && this.destFile == null) {
            throw new IllegalArgumentException("Destination directory or file not set");
        }
        if (this.filters.size() == 0) {
            this.filters.add(new Strip());
            this.filters.add(new Retro14());
        }
        if (this.destDir != null && !this.destDir.exists()) {
            this.destDir.mkdir();
        }
    }

    private void populateEntriesList() throws IOException {
        for (File f : this.files) {
            if (f.isDirectory()) {
                this.processDir(f, f.toURI(), this.entries);
                continue;
            }
            if (f.getName().endsWith(".jar")) {
                this.processJar(f, this.entries);
                continue;
            }
            this.entries.add(new FileEntry(f, f.getName()));
        }
        for (File f : this.libraries) {
            if (f.isDirectory()) {
                this.processDir(f, f.toURI(), this.libraryEntries);
                continue;
            }
            if (f.getName().endsWith(".jar")) {
                this.processJar(f, this.libraryEntries);
                continue;
            }
            this.libraryEntries.add(new FileEntry(f, f.getName()));
        }
        if (this.jdkDir != null) {
            this.processJar(new File(this.jdkDir, "lib/tools.jar"), this.libraryEntries);
            for (File f : new File(this.jdkDir, "jre/lib").listFiles()) {
                if (!f.getName().endsWith(".jar")) continue;
                this.processJar(f, this.libraryEntries);
            }
        }
        for (String s : this.jdkEntries) {
            this.libraryEntries.add(new JdkEntry(s));
        }
    }

    private boolean shouldExclude(Entry e) {
        if (e.className != null) {
            for (String x : this.excludes) {
                if (!e.className.contains(x)) continue;
                if (this.props.get("debug") != null) {
                    System.out.print("Removing pattern " + e.className);
                    System.out.println(" because of " + x);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeFilters() throws IOException {
        this.processProps();
        this.checkConfigurationAndInit();
        this.populateEntriesList();
        this.filters.setProperties(this.props);
        this.filters.beforePreVisit();
        for (Entry e : this.entries) {
            if (!e.isClassFile()) continue;
            this.filters.preVisit(e, false);
        }
        for (Entry e : this.libraryEntries) {
            if (!e.isClassFile()) continue;
            this.filters.preVisit(e, true);
        }
        this.filters.afterPreVisit();
        try {
            for (Entry e : this.entries) {
                InputStream is;
                if (this.shouldExclude(e)) continue;
                if (e.isClassFile()) {
                    is = new ByteArrayInputStream(this.filters.visit(e));
                    ClassReader cr = new ClassReader(is);
                    e.setClassName(cr.getClassName() + ".class");
                    is.reset();
                } else {
                    is = e.getInputStream();
                }
                try {
                    this.saveFile(is, e.getRelativeOutputPath());
                }
                finally {
                    is.close();
                }
            }
        }
        finally {
            if (this.jarOutputStream != null) {
                this.jarOutputStream.close();
            }
        }
        this.filters.afterVisit();
    }

    public static void printUsage() {
        System.err.println("Usage: Linker [ -v|--verbose ] [ --debug ] [ -f|--filters filter,... ] [ -l|--library libraryJar ] [ --jdk jdkDir ] -d|--dest-dir outputDirectory inputFileOrDir...");
    }

    private void processDir(File source, URI sourceRoot, Collection<Entry> target) throws IOException {
        if (source.isDirectory()) {
            for (File f : source.listFiles()) {
                this.processDir(f, sourceRoot, target);
            }
        } else {
            if (source.getName().contains("/package-info.class") || source.getName().contains("/package-info$Intf.class")) {
                return;
            }
            target.add(new FileEntry(source, sourceRoot.relativize(source.toURI()).toString()));
        }
    }

    private void processJar(File file, Collection<Entry> target) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> e = jarFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory() || entry.getName().contains("/package-info.class") || entry.getName().contains("/package-info$Intf.class")) continue;
            target.add(new JarFileEntry(jarFile, entry, entry.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(InputStream is, String path) throws IOException {
        if (this.destDir != null) {
            File destFile = new File(this.destDir, path);
            destFile.getParentFile().mkdirs();
            FileOutputStream os = new FileOutputStream(destFile);
            try {
                this.saveFileToStream(is, os);
            }
            finally {
                os.close();
            }
        }
        if (this.jarOutputStream == null) {
            this.jarOutputStream = new JarOutputStream(new FileOutputStream(this.destFile));
            if (this.uncompressedOutputJar) {
                this.jarOutputStream.setLevel(0);
            }
        }
        this.jarOutputStream.putNextEntry(new ZipEntry(path));
        try {
            this.saveFileToStream(is, this.jarOutputStream);
        }
        finally {
            this.jarOutputStream.closeEntry();
        }
    }

    private void saveFileToStream(InputStream is, OutputStream os) throws IOException {
        int size;
        byte[] buffer = new byte[8192];
        while ((size = is.read(buffer)) != -1) {
            os.write(buffer, 0, size);
        }
    }
}

