/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.ant;

import com.sun.tools.linker.Linker;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class ManglerTask
extends Java {
    private String dest = null;
    private String src = null;
    private boolean quiet = false;
    private boolean filtersSet = false;
    private File config;
    private Path userLibs;
    private Path sources;
    private Properties properties;
    private boolean shouldFork = false;
    private String filters = "";
    private String jdkDir = "";
    private boolean verbose = false;
    private boolean debug = false;
    private BufferedReader rdr = null;
    private InputStream mis = null;
    private InputStreamReader isr = null;
    private List<String> vmOpts = null;
    private Path classpath = null;

    public void setJvmargs(String vmoptions) {
        String[] opts;
        this.vmOpts = new ArrayList<String>();
        for (String x : opts = vmoptions.split("\\s")) {
            this.vmOpts.add(x);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setConfig(File config) {
        this.config = config;
    }

    public void setFilters(String filters) {
        this.filtersSet = true;
        this.filters = filters;
    }

    public void setSource(String source) {
        this.src = source;
    }

    public void setDest(String destDir) {
        this.log("The dest attribute is deprecated, use destDir instead");
        this.setDestDir(destDir);
    }

    public void setDestDir(String destDir) {
        this.dest = destDir;
    }

    public void setDestFile(String destFile) {
        this.dest = destFile;
    }

    public Path createLibraries() {
        if (this.userLibs == null) {
            this.userLibs = new Path(this.getProject());
        }
        return this.userLibs.createPath();
    }

    public Path createSources() {
        if (this.sources == null) {
            this.sources = new Path(this.getProject());
        }
        return this.sources.createPath();
    }

    public void setJdk(String jdkDir) {
        this.jdkDir = jdkDir;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setQuiet(boolean q) {
        this.quiet = q;
    }

    public void setFork(boolean fork) {
        this.shouldFork = fork;
    }

    public void setClasspath(Path cpath) {
        this.classpath = cpath;
    }

    public void execute() throws BuildException {
        if (!this.quiet) {
            this.log("Mangle files from " + this.src + " to " + this.dest);
        }
        if (this.shouldFork) {
            this.executeOutProc();
        } else {
            this.executeInProc();
        }
    }

    private void executeInProc() throws BuildException {
        Iterator i;
        Linker linker = new Linker();
        linker.addFilters(this.filters);
        if (this.src != null) {
            linker.addFile(this.src);
        }
        if (!this.jdkDir.equals("")) {
            linker.setJdkDir(this.jdkDir);
        }
        if (this.verbose) {
            linker.setVerbose(this.verbose);
        }
        if (this.debug) {
            linker.setDebug(this.debug);
        }
        if (this.dest != null) {
            linker.setDestDir(this.dest);
        }
        if (this.userLibs != null) {
            i = this.userLibs.iterator();
            while (i.hasNext()) {
                linker.addLibrary(i.next().toString());
            }
        }
        if (this.sources != null) {
            i = this.sources.iterator();
            while (i.hasNext()) {
                linker.addFile(i.next().toString());
            }
        }
        if (!this.filtersSet) {
            throw new BuildException("No mangler filters specified");
        }
        if (this.config != null) {
            try {
                linker.configureFromFile(this.config);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.properties != null) {
            linker.configureFromProperties(this.properties);
        }
        try {
            linker.executeFilters();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String getJavaExe() {
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        String javaHome = System.getProperty("java.home");
        File binDir = new File(javaHome, "bin");
        File javaExe = new File(binDir, isWindows ? "java.exe" : "java");
        return javaExe.getAbsolutePath();
    }

    private void executeOutProc() {
        Iterator i;
        if (this.classpath == null) {
            throw new BuildException("tools classpath required in fork mode");
        }
        ArrayList<String> cmdsList = new ArrayList<String>();
        cmdsList.add(this.getJavaExe());
        if (this.vmOpts != null) {
            cmdsList.addAll(this.vmOpts);
        }
        cmdsList.add("-cp");
        cmdsList.add(this.classpath.toString());
        cmdsList.add("com.sun.tools.linker.Linker");
        if (!this.jdkDir.equals("")) {
            cmdsList.add("--jdk");
            cmdsList.add(this.jdkDir);
        }
        if (this.verbose) {
            cmdsList.add("--verbose");
        }
        if (this.debug) {
            cmdsList.add("--debug");
        }
        if (this.dest != null) {
            cmdsList.add("--dest-dir");
            cmdsList.add(this.dest);
        }
        if (this.userLibs != null) {
            i = this.userLibs.iterator();
            while (i.hasNext()) {
                cmdsList.add("--library");
                cmdsList.add(i.next().toString());
            }
        }
        if (!this.filtersSet) {
            throw new BuildException("No mangler filters specified");
        }
        cmdsList.add("--filters");
        cmdsList.add(this.filters);
        if (this.config != null) {
            cmdsList.add("--config");
            cmdsList.add(this.config.getAbsolutePath());
        }
        if (this.properties != null) {
            throw new BuildException("properties not supported in this mode");
        }
        if (this.src != null) {
            cmdsList.add(this.src);
        }
        if (this.sources != null) {
            i = this.sources.iterator();
            while (i.hasNext()) {
                cmdsList.add(i.next().toString());
            }
        }
        if (!this.quiet) {
            StringBuffer outBuf = new StringBuffer();
            this.log("Executing mangler with cmd:");
            for (String x : cmdsList) {
                outBuf = outBuf.append(x + " ");
            }
            this.log(outBuf.toString());
        }
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(cmdsList);
            pb.redirectErrorStream(true);
            Process mProc = pb.start();
            this.mis = mProc.getInputStream();
            this.isr = new InputStreamReader(this.mis);
            this.rdr = new BufferedReader(this.isr);
            String line = this.rdr.readLine();
            while (line != null) {
                System.out.println(line);
                line = this.rdr.readLine();
            }
            try {
                mProc.waitFor();
                if (mProc.exitValue() != 0) {
                    throw new BuildException("mangler did not terminate successfully");
                }
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            try {
                if (this.rdr != null) {
                    this.rdr.close();
                }
                if (this.isr != null) {
                    this.isr.close();
                }
                if (this.mis != null) {
                    this.mis.close();
                }
            }
            catch (IOException ignore) {}
        }
    }
}

