/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.Filter;
import com.sun.tools.linker.filters.FilterChain;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilter
implements Filter {
    protected Map<String, String> properties;
    protected FilterChain filterChain;
    protected Logger logger = Logger.getLogger("linker");
    protected boolean isDebug;
    protected boolean isVerbose;

    @Override
    public void setProperties(Map<String, String> props) {
        this.properties = props;
        this.isDebug = this.properties.containsKey("debug");
        this.isVerbose = this.properties.containsKey("verbose");
        if (this.isDebug) {
            this.logger.setLevel(Level.FINEST);
        }
        if (this.logger.getHandlers().length == 0) {
            this.logger.addHandler(new ConsoleHandler());
        }
    }

    @Override
    public void beforePreVisit() {
    }

    @Override
    public Collection<String> getRequiredFilters() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> getIncompatibleUpstreamFilters() {
        return Collections.emptyList();
    }

    @Override
    public void setFilterChain(FilterChain filterChain) {
        if (this.filterChain != null) {
            throw new RuntimeException("Cannot set filter chain twice");
        }
        this.filterChain = filterChain;
    }

    protected Filter getFilter(String name) {
        return this.filterChain.locateFilterByName(name);
    }

    @Override
    public ClassVisitor makePreVisitor(ClassVisitor chain) {
        return chain;
    }

    @Override
    public ClassVisitor makeLibPreVisitor(ClassVisitor chain) {
        return chain;
    }

    @Override
    public ClassVisitor makeVisitor(ClassVisitor chain) {
        return chain;
    }

    @Override
    public void afterPreVisit() {
    }

    @Override
    public void afterVisit() {
    }

    protected String getCurrentClass() {
        String className = "";
        if (this.filterChain.getCurrentEntry() != null) {
            className = this.filterChain.getCurrentEntry().getClassName();
        }
        return className;
    }

    protected void debug(String warningString) {
        if (this.isDebug) {
            this.logger.info("[" + this.getName() + "] (" + this.getCurrentClass() + "): " + warningString);
        }
    }

    protected void warning(String warningString) {
        this.logger.warning("[" + this.getName() + "] (" + this.getCurrentClass() + "): " + warningString);
    }

    protected void error(String warningString) {
        this.logger.severe("[" + this.getName() + "] (" + this.getCurrentClass() + "): " + warningString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractFilter)) {
            return false;
        }
        String name = this.getName();
        AbstractFilter that = (AbstractFilter)o;
        return !(name != null ? !name.equals(that.getName()) : that.getName() != null);
    }

    public int hashCode() {
        String name = this.getName();
        int result = name != null ? name.hashCode() : 0;
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

