/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import com.sun.tools.linker.filters.FilterUtil;
import com.sun.tools.linker.model.ClassModel;
import com.sun.tools.linker.model.FieldModel;
import com.sun.tools.linker.model.MethodModel;
import com.sun.tools.linker.model.PackageModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMapper
extends AbstractFilter {
    final Map<String, ClassModel> classMap = new HashMap<String, ClassModel>();
    final Map<String, PackageModel> packageMap = new HashMap<String, PackageModel>();
    final Collection<String> requiredJdkClasses = new ArrayList<String>();
    private boolean mappingMethods;
    private boolean mappingFields;

    @Override
    public String getName() {
        return "ApplicationMapper";
    }

    @Override
    public Collection<String> getIncompatibleUpstreamFilters() {
        return Collections.singleton("RetroLdc");
    }

    @Override
    public ClassVisitor makePreVisitor(ClassVisitor chain) {
        return new MappingClassAdapter(super.makePreVisitor(chain), true);
    }

    @Override
    public ClassVisitor makeLibPreVisitor(ClassVisitor chain) {
        return new MappingClassAdapter(super.makeLibPreVisitor(chain), false);
    }

    @Override
    public void afterPreVisit() {
        super.afterPreVisit();
        for (ClassModel cm : this.classMap.values()) {
            ClassModel superclassModel = this.classMap.get(cm.superclassName);
            if (superclassModel != null) {
                cm.setSuperclassModel(superclassModel);
                superclassModel.addSubclass(cm);
            }
            PackageModel packageModel = this.packageMap.get(cm.packageName);
            cm.setPackageModel(packageModel);
            if (packageModel != null) {
                packageModel.addClass(cm);
            }
            for (String s : cm.interfaceNames) {
                ClassModel interfaceModel = this.classMap.get(s);
                if (interfaceModel == null) continue;
                cm.addInterfaceModel(interfaceModel);
                interfaceModel.addImplementedBy(cm);
            }
        }
    }

    public PackageModel getPackageModel(String packageName) {
        if (packageName.indexOf("/") >= 0) {
            packageName = packageName.replaceAll("/", ".");
        }
        return this.packageMap.get(packageName);
    }

    public ClassModel getClassModel(String className) {
        return this.classMap.get(className);
    }

    public Collection<String> enumerateSubclasses(String className) {
        ArrayList<String> result = new ArrayList<String>();
        ClassModel cm = this.classMap.get(className);
        this.enumerateSubclasses(cm, result);
        return result;
    }

    private void enumerateSubclasses(ClassModel cm, Collection<String> result) {
        if (cm != null) {
            result.add(cm.fullName);
            for (ClassModel child : cm.getSubclassModels()) {
                this.enumerateSubclasses(child, result);
            }
            for (ClassModel child : cm.getImplementedBy()) {
                this.enumerateSubclasses(child, result);
            }
        }
    }

    public void addRequiredJdkClass(String clazz) {
        this.requiredJdkClasses.add(clazz);
    }

    public void setMapMethods() {
        this.mappingMethods = true;
    }

    public void setMapFields() {
        this.mappingFields = true;
    }

    private class MappingClassAdapter
    extends ClassAdapter {
        ClassModel currentClass;
        boolean isProject;

        public MappingClassAdapter(ClassVisitor chain, boolean isProject) {
            super(chain);
            this.isProject = isProject;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            String packagePart = FilterUtil.getPackagePart(name);
            String namePart = FilterUtil.getClassPart(name);
            PackageModel pm = ApplicationMapper.this.packageMap.get(packagePart);
            if (pm == null) {
                pm = new PackageModel(packagePart);
                ApplicationMapper.this.packageMap.put(packagePart, pm);
            }
            this.currentClass = ApplicationMapper.this.classMap.get(name);
            if (this.currentClass == null) {
                this.currentClass = new ClassModel(namePart, name, access, packagePart, superName, Arrays.asList(interfaces));
                this.currentClass.setLibraryClass(!this.isProject);
                this.currentClass.setDefiningEntry(ApplicationMapper.this.filterChain.getCurrentEntry());
                ApplicationMapper.this.classMap.put(name, this.currentClass);
            } else {
                ApplicationMapper.this.warning("duplicate class " + name);
            }
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public void visitEnd() {
            this.currentClass = null;
            super.visitEnd();
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            assert (this.currentClass != null);
            if (ApplicationMapper.this.mappingFields) {
                FieldModel fm = new FieldModel(name, this.currentClass.fullName, desc, signature, access);
                this.currentClass.addField(fm);
                fm.setOwnerClassModel(this.currentClass);
            }
            return super.visitField(access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            assert (this.currentClass != null);
            if (ApplicationMapper.this.mappingMethods) {
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
            final MethodModel mm = new MethodModel(name, this.currentClass.fullName, desc, signature, access, exceptions);
            this.currentClass.addMethod(mm);
            mm.setOwnerClassModel(this.currentClass);
            if (exceptions != null) {
                for (String string : exceptions) {
                    mm.addReferenceType(FilterUtil.extractBaseType(string));
                }
            }
            for (String string : Type.getArgumentTypes((String)desc)) {
                mm.addReferenceType(FilterUtil.extractBaseType((Type)string));
            }
            mm.addReferenceType(FilterUtil.extractBaseType(Type.getReturnType((String)desc)));
            return new MethodAdapter(super.visitMethod(access, name, desc, signature, exceptions)){

                public void visitTypeInsn(int opcode, String type) {
                    mm.addReferenceType(FilterUtil.extractBaseType(type));
                    super.visitTypeInsn(opcode, type);
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                    mm.addReferenceType(owner);
                    mm.addReferenceType(FilterUtil.extractBaseType(Type.getType((String)desc)));
                    super.visitFieldInsn(opcode, owner, name, desc);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                    mm.addReferenceType(owner);
                    mm.addReferenceMethod(owner, name, desc, opcode == 184);
                    super.visitMethodInsn(opcode, owner, name, desc);
                }

                public void visitLdcInsn(Object cst) {
                    if (cst instanceof Type) {
                        mm.addReferenceType(FilterUtil.extractBaseType(((Type)cst).getInternalName()));
                    }
                    super.visitLdcInsn(cst);
                }

                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                    mm.addReferenceType(type);
                    super.visitTryCatchBlock(start, end, handler, type);
                }

                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    mm.addReferenceType(FilterUtil.extractBaseType(Type.getType((String)desc)));
                    super.visitLocalVariable(name, desc, signature, start, end, index);
                }
            };
        }
    }
}

