/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.Entry;
import com.sun.tools.linker.filters.Filter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.EmptyVisitor;
import org.objectweb.asm.util.AltCheckClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterChain {
    private final Map<String, Filter> filterNames = new LinkedHashMap<String, Filter>();
    private final LinkedList<Filter> filters = new LinkedList();
    public final Logger logger = Logger.getLogger("linker");
    private Entry currentEntry;

    public int size() {
        return this.filterNames.size();
    }

    public void add(Filter filter) {
        if (!this.filterNames.containsKey(filter.getName())) {
            Collection<String> badFilters = filter.getIncompatibleUpstreamFilters();
            for (String badFilter : badFilters) {
                if (!this.filterNames.containsKey(badFilter)) continue;
                throw new RuntimeException(String.format("%s must precede %s if %s is present", filter.getName(), badFilter, badFilter));
            }
            this.filterNames.put(filter.getName(), filter);
            this.filters.addFirst(filter);
            filter.setFilterChain(this);
            for (String s : filter.getRequiredFilters()) {
                Filter required = this.locateFilterByClass(s);
                if (required == null) {
                    System.err.println("Can't find required filter " + s);
                    continue;
                }
                this.add(required);
            }
        }
    }

    public void addByClass(String filterClass) {
        this.add(this.locateFilterByClass(filterClass));
    }

    public void setProperties(Map<String, String> props) {
        if (this.logger.getHandlers().length == 0) {
            this.logger.addHandler(new ConsoleHandler());
        }
        if (props.containsKey("debug")) {
            this.logger.setLevel(Level.FINE);
        }
        for (Filter f : this.filters) {
            f.setProperties(props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] visit(Entry entry) throws IOException {
        InputStream inputStream = entry.getInputStream();
        try {
            ClassReader reader = new ClassReader(inputStream);
            ClassWriter writer = new ClassWriter(1);
            ClassAdapter visitor = new AltCheckClassAdapter((ClassVisitor)writer){

                public void checkIdentifier(String name, String msg) {
                }

                public void checkMethodIdentifier(String name, String msg) {
                }
            };
            this.currentEntry = entry;
            for (Filter f : this.filters) {
                visitor = f.makeVisitor((ClassVisitor)visitor);
            }
            if (this.currentEntry.getClassName() != null) {
                visitor = new NameCapture((ClassVisitor)visitor);
            }
            reader.accept((ClassVisitor)visitor, 8);
            byte[] byArray = writer.toByteArray();
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preVisit(Entry entry, boolean isLibrary) throws IOException {
        EmptyVisitor dummy;
        Object visitor = dummy = new EmptyVisitor();
        this.currentEntry = entry;
        for (Filter f : this.filters) {
            visitor = isLibrary ? f.makeLibPreVisitor((ClassVisitor)visitor) : f.makePreVisitor((ClassVisitor)visitor);
        }
        if (visitor != dummy) {
            visitor = new NameCapture((ClassVisitor)visitor);
            InputStream inputStream = entry.getInputStream();
            try {
                ClassReader reader = new ClassReader(inputStream);
                reader.accept((ClassVisitor)visitor, 0);
            }
            finally {
                inputStream.close();
            }
        }
    }

    public void afterPreVisit() {
        this.currentEntry = null;
        for (Filter f : this.filters) {
            f.afterPreVisit();
        }
    }

    public void beforePreVisit() {
        for (Filter f : this.filters) {
            f.beforePreVisit();
        }
    }

    public void afterVisit() {
        this.currentEntry = null;
        for (Filter f : this.filters) {
            f.afterVisit();
        }
    }

    public Filter locateFilterByName(String name) {
        return this.filterNames.get(name);
    }

    public Entry getCurrentEntry() {
        return this.currentEntry;
    }

    public Filter locateFilterByClass(String filterClass) {
        Filter result;
        try {
            Class<?> filterClazz = filterClass.contains(".") ? Class.forName(filterClass) : Class.forName("com.sun.tools.linker.filters." + filterClass);
            result = (Filter)filterClazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.filterNames.containsKey(result.getName())) {
            result = this.filterNames.get(result.getName());
        }
        return result;
    }

    private class NameCapture
    extends ClassAdapter {
        private NameCapture(ClassVisitor cv) {
            super(cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            FilterChain.this.currentEntry.setClassName(name);
            super.visit(version, access, name, signature, superName, interfaces);
        }
    }
}

