/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodDescriptor
implements Comparable<MethodDescriptor> {
    public final String owner;
    public final String name;
    public final String desc;
    public final boolean isStatic;
    private static final String STATIC = "static ";

    public MethodDescriptor(String owner, String name, String desc, boolean isStatic) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
        this.isStatic = isStatic;
    }

    public MethodDescriptor(String owner, String name, String desc) {
        this(owner, name, desc, false);
    }

    public String toString() {
        return this.owner + "." + this.name + this.desc;
    }

    public String toSerialized() {
        return (this.isStatic ? STATIC : "") + this.owner + " " + this.name + " " + this.desc;
    }

    public static MethodDescriptor fromSerialized(String ser) {
        boolean isStatic = ser.startsWith(STATIC);
        if (isStatic) {
            ser = ser.substring(STATIC.length());
        }
        String[] components = ser.split(" ");
        return new MethodDescriptor(components[0], components[1], components[2], isStatic);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)o;
        if (this.isStatic != that.isStatic) {
            return false;
        }
        if (this.desc != null ? !this.desc.equals(that.desc) : that.desc != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.owner != null ? !this.owner.equals(that.owner) : that.owner != null);
    }

    public int hashCode() {
        int result = this.owner != null ? this.owner.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.desc != null ? this.desc.hashCode() : 0);
        result = 31 * result + (this.isStatic ? 1 : 0);
        return result;
    }

    @Override
    public int compareTo(MethodDescriptor o) {
        int ct = this.owner.compareTo(o.owner);
        if (ct != 0) {
            return ct;
        }
        ct = this.name.compareTo(o.name);
        if (ct != 0) {
            return ct;
        }
        return this.desc.compareTo(o.desc);
    }
}

