/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

public class PackageRenamer
extends AbstractFilter {
    Map<String, String> packageMap = new HashMap<String, String>();
    private static final String KEY_PREFIX = "packagerenamer.";
    private static final String KEY_PACKAGE_PREFIX = "packagerenamer.rename.";

    public String getName() {
        return "PackageRenamer";
    }

    public void afterPreVisit() {
        for (Map.Entry entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.toLowerCase().startsWith(KEY_PREFIX) || !key.toLowerCase().startsWith(KEY_PACKAGE_PREFIX)) continue;
            String fromPackageName = key.substring(KEY_PACKAGE_PREFIX.length()).replace('.', '/');
            String toPackageName = ((String)entry.getValue()).replace('.', '/');
            this.debug(String.format("Mapping package '%s' to '%s'%n", fromPackageName, toPackageName));
            this.packageMap.put(fromPackageName, toPackageName);
        }
    }

    public ClassVisitor makeVisitor(ClassVisitor chain) {
        return new RemappingClassAdapter(chain, new Remapper(){

            public String map(String typeName) {
                String longestKey = null;
                for (String key : PackageRenamer.this.packageMap.keySet()) {
                    if (!typeName.startsWith(key) || typeName.charAt(key.length()) != '/' || longestKey != null && key.length() <= longestKey.length()) continue;
                    longestKey = key;
                }
                return longestKey == null ? typeName : PackageRenamer.this.packageMap.get(longestKey) + typeName.substring(longestKey.length());
            }
        });
    }
}

